/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.vec;

import com.creativemd.creativecore.common.utils.math.VectorUtils;
import com.creativemd.creativecore.common.utils.math.box.BoxCorner;
import com.creativemd.creativecore.common.utils.math.box.OrientatedBoundingBox;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public interface IVecOrigin {
    public double offX();

    public double offY();

    public double offZ();

    public double rotX();

    public double rotY();

    public double rotZ();

    public double offXLast();

    public double offYLast();

    public double offZLast();

    public double rotXLast();

    public double rotYLast();

    public double rotZLast();

    public boolean isRotated();

    public void offX(double var1);

    public void offY(double var1);

    public void offZ(double var1);

    public void off(double var1, double var3, double var5);

    public void rotX(double var1);

    public void rotY(double var1);

    public void rotZ(double var1);

    public void rot(double var1, double var3, double var5);

    public Vector3d center();

    public void setCenter(Vector3d var1);

    public Matrix3d rotation();

    public Matrix3d rotationInv();

    public Vector3d translation();

    public void tick();

    public IVecOrigin getParent();

    default public double translationCombined(EnumFacing.Axis axis) {
        return VectorUtils.get(axis, (Tuple3d)this.translation());
    }

    default public void transformPointToWorld(Vector3d vec) {
        vec.sub((Tuple3d)this.center());
        this.rotation().transform((Tuple3d)vec);
        vec.add((Tuple3d)this.center());
        vec.add((Tuple3d)this.translation());
    }

    default public void transformPointToFakeWorld(Vector3d vec) {
        vec.sub((Tuple3d)this.translation());
        vec.sub((Tuple3d)this.center());
        this.rotationInv().transform((Tuple3d)vec);
        vec.add((Tuple3d)this.center());
    }

    default public Vec3d transformPointToWorld(Vec3d vec) {
        Vector3d real = new Vector3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        this.transformPointToWorld(real);
        return new Vec3d(real.x, real.y, real.z);
    }

    default public Vec3d transformPointToFakeWorld(Vec3d vec) {
        Vector3d real = new Vector3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        this.transformPointToFakeWorld(real);
        return new Vec3d(real.x, real.y, real.z);
    }

    default public AxisAlignedBB getAxisAlignedBox(AxisAlignedBB box) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            Vector3d vec = BoxCorner.values()[i].getVector(box);
            this.transformPointToWorld(vec);
            minX = Math.min(minX, vec.x);
            minY = Math.min(minY, vec.y);
            minZ = Math.min(minZ, vec.z);
            maxX = Math.max(maxX, vec.x);
            maxY = Math.max(maxY, vec.y);
            maxZ = Math.max(maxZ, vec.z);
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    default public OrientatedBoundingBox getOrientatedBox(AxisAlignedBB box) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            Vector3d vec = BoxCorner.values()[i].getVector(box);
            this.transformPointToFakeWorld(vec);
            minX = Math.min(minX, vec.x);
            minY = Math.min(minY, vec.y);
            minZ = Math.min(minZ, vec.z);
            maxX = Math.max(maxX, vec.x);
            maxY = Math.max(maxY, vec.y);
            maxZ = Math.max(maxZ, vec.z);
        }
        return new OrientatedBoundingBox(this, minX, minY, minZ, maxX, maxY, maxZ);
    }

    @SideOnly(value=Side.CLIENT)
    default public void setupRenderingInternal(Entity entity, float partialTicks) {
        double rotX = this.rotXLast() + (this.rotX() - this.rotXLast()) * (double)partialTicks;
        double rotY = this.rotYLast() + (this.rotY() - this.rotYLast()) * (double)partialTicks;
        double rotZ = this.rotZLast() + (this.rotZ() - this.rotZLast()) * (double)partialTicks;
        double offX = this.offXLast() + (this.offX() - this.offXLast()) * (double)partialTicks;
        double offY = this.offYLast() + (this.offY() - this.offYLast()) * (double)partialTicks;
        double offZ = this.offZLast() + (this.offZ() - this.offZLast()) * (double)partialTicks;
        Vector3d rotationCenter = this.center();
        GlStateManager.func_179137_b((double)offX, (double)offY, (double)offZ);
        GlStateManager.func_179137_b((double)rotationCenter.x, (double)rotationCenter.y, (double)rotationCenter.z);
        GL11.glRotated((double)rotX, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)rotY, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)rotZ, (double)0.0, (double)0.0, (double)1.0);
        GlStateManager.func_179137_b((double)(-rotationCenter.x), (double)(-rotationCenter.y), (double)(-rotationCenter.z));
    }

    @SideOnly(value=Side.CLIENT)
    default public void setupRendering(Entity entity, float partialTicks) {
        GlStateManager.func_179137_b((double)(-TileEntityRendererDispatcher.field_147554_b), (double)(-TileEntityRendererDispatcher.field_147555_c), (double)(-TileEntityRendererDispatcher.field_147552_d));
        this.setupRenderingInternal(entity, partialTicks);
    }

    default public boolean hasChanged() {
        return this.offXLast() != this.offX() || this.offYLast() != this.offY() || this.offZLast() != this.offZ() || this.rotXLast() != this.rotX() || this.rotYLast() != this.rotY() || this.rotZLast() != this.rotZ();
    }
}

