/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.box;

import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.VectorUtils;
import com.creativemd.creativecore.common.utils.math.box.BoxCorner;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import net.minecraft.util.EnumFacing;

public enum BoxFace {
    EAST(EnumFacing.EAST, new BoxCorner[]{BoxCorner.EUS, BoxCorner.EDS, BoxCorner.EDN, BoxCorner.EUN}),
    WEST(EnumFacing.WEST, new BoxCorner[]{BoxCorner.WUN, BoxCorner.WDN, BoxCorner.WDS, BoxCorner.WUS}),
    UP(EnumFacing.UP, new BoxCorner[]{BoxCorner.WUN, BoxCorner.WUS, BoxCorner.EUS, BoxCorner.EUN}),
    DOWN(EnumFacing.DOWN, new BoxCorner[]{BoxCorner.WDS, BoxCorner.WDN, BoxCorner.EDN, BoxCorner.EDS}),
    SOUTH(EnumFacing.SOUTH, new BoxCorner[]{BoxCorner.WUS, BoxCorner.WDS, BoxCorner.EDS, BoxCorner.EUS}),
    NORTH(EnumFacing.NORTH, new BoxCorner[]{BoxCorner.EUN, BoxCorner.EDN, BoxCorner.WDN, BoxCorner.WUN});

    public final EnumFacing facing;
    public final BoxCorner[] corners;
    private final EnumFacing.Axis one;
    private final EnumFacing.Axis two;
    private final BoxTriangle triangleFirst;
    private final BoxTriangle triangleFirstInv;
    private final BoxTriangle triangleSecond;
    private final BoxTriangle triangleSecondInv;

    private BoxFace(EnumFacing facing, BoxCorner[] corners) {
        this.facing = facing;
        this.corners = corners;
        this.one = RotationUtils.getOne(facing.func_176740_k());
        this.two = RotationUtils.getTwo(facing.func_176740_k());
        this.triangleFirst = new BoxTriangle(new BoxCorner[]{corners[0], corners[1], corners[2]});
        this.triangleFirstInv = new BoxTriangle(new BoxCorner[]{corners[0], corners[1], corners[3]});
        this.triangleSecond = new BoxTriangle(new BoxCorner[]{corners[0], corners[2], corners[3]});
        this.triangleSecondInv = new BoxTriangle(new BoxCorner[]{corners[1], corners[2], corners[3]});
    }

    private BoxTriangle getTriangle(boolean first, boolean inverted) {
        if (first) {
            if (inverted) {
                return this.triangleFirstInv;
            }
            return this.triangleFirst;
        }
        if (inverted) {
            return this.triangleSecondInv;
        }
        return this.triangleSecond;
    }

    public BoxCorner[] getTriangleFirst(boolean inverted) {
        return this.getTriangle(true, inverted).corners;
    }

    public BoxCorner[] getTriangleSecond(boolean inverted) {
        return this.getTriangle(false, inverted).corners;
    }

    public Vector3d first(Vector3d[] corners) {
        return corners[this.corners[0].ordinal()];
    }

    public Vector3d normal(Vector3d[] corners) {
        Vector3d origin = this.first(corners);
        Vector3d first = new Vector3d(corners[this.corners[1].ordinal()]);
        Vector3d second = new Vector3d(corners[this.corners[2].ordinal()]);
        first.sub((Tuple3d)origin);
        second.sub((Tuple3d)origin);
        return new Vector3d(first.y * second.z - first.z * second.y, first.z * second.x - first.x * second.z, first.x * second.y - first.y * second.x);
    }

    public Boolean isFacingOutwards(boolean first, boolean inverted, Vector3f normal) {
        Boolean outwardTwo;
        Boolean outwardOne;
        BoxTriangle triangle = this.getTriangle(first, inverted);
        float valueOne = VectorUtils.get(this.one, (Tuple3f)normal);
        float valueTwo = VectorUtils.get(this.two, (Tuple3f)normal);
        Boolean bl = valueOne == 0.0f ? null : (outwardOne = Boolean.valueOf(valueOne > 0.0f));
        Boolean bl2 = valueTwo == 0.0f ? null : (outwardTwo = Boolean.valueOf(valueTwo > 0.0f));
        if (outwardOne == outwardTwo) {
            return outwardOne;
        }
        if (outwardOne != null && outwardTwo == null) {
            return outwardOne;
        }
        if (outwardOne == null && outwardTwo != null) {
            return outwardTwo;
        }
        if (valueOne == valueTwo) {
            return null;
        }
        if (valueOne > valueTwo) {
            return outwardOne;
        }
        return outwardTwo;
    }

    public static Vector3f getTraingleNormal(BoxCorner[] triangle, Vector3f[] corners) {
        Vector3f a = new Vector3f(corners[triangle[0].ordinal()]);
        a.sub((Tuple3f)corners[triangle[1].ordinal()]);
        Vector3f b = new Vector3f(corners[triangle[2].ordinal()]);
        b.sub((Tuple3f)corners[triangle[1].ordinal()]);
        Vector3f normal = new Vector3f();
        normal.cross(b, a);
        return normal;
    }

    public static void ensureSameLength(Vector3f one, Vector3f two) {
        float normVecOne = one.x * one.x + one.y * one.y + one.z * one.z;
        float normVecTwo = two.x * two.x + two.y * two.y + two.z * two.z;
        one.scale(normVecTwo);
        two.scale(normVecOne);
    }

    public static BoxFace get(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case UP: {
                return UP;
            }
            case DOWN: {
                return DOWN;
            }
            case SOUTH: {
                return SOUTH;
            }
            case NORTH: {
                return NORTH;
            }
        }
        return null;
    }

    public static BoxFace get(EnumFacing.Axis axis, boolean direction) {
        switch (axis) {
            case X: {
                return direction ? EAST : WEST;
            }
            case Y: {
                return direction ? UP : DOWN;
            }
            case Z: {
                return direction ? SOUTH : NORTH;
            }
        }
        return null;
    }

    public static Vector3f[] getVecArray(BoxCorner[] corners, Vector3f[] vecs) {
        Vector3f[] result = new Vector3f[corners.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = vecs[corners[i].ordinal()];
        }
        return result;
    }

    private class BoxTriangle {
        private final BoxCorner[] corners;
        private final boolean outwardDirectionOne;
        private final boolean outwardDirectionTwo;

        public BoxTriangle(BoxCorner[] corners) {
            this.corners = corners;
            this.outwardDirectionOne = corners[1].getFacing(BoxFace.this.one).func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
            this.outwardDirectionTwo = corners[1].getFacing(BoxFace.this.two).func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
        }
    }
}

