/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.box;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.box.CreativeAxisAlignedBB;
import javax.vecmath.Vector3d;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public enum BoxCorner {
    EUN(EnumFacing.EAST, EnumFacing.UP, EnumFacing.NORTH),
    EUS(EnumFacing.EAST, EnumFacing.UP, EnumFacing.SOUTH),
    EDN(EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.NORTH),
    EDS(EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.SOUTH),
    WUN(EnumFacing.WEST, EnumFacing.UP, EnumFacing.NORTH),
    WUS(EnumFacing.WEST, EnumFacing.UP, EnumFacing.SOUTH),
    WDN(EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.NORTH),
    WDS(EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.SOUTH);

    public final EnumFacing x;
    public final EnumFacing y;
    public final EnumFacing z;
    public BoxCorner neighborOne;
    public BoxCorner neighborTwo;
    public BoxCorner neighborThree;
    private static BoxCorner[][] facingCorners;

    private BoxCorner(EnumFacing x, EnumFacing y, EnumFacing z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    private void init() {
        this.neighborOne = BoxCorner.getCorner(this.x.func_176734_d(), this.y, this.z);
        this.neighborTwo = BoxCorner.getCorner(this.x, this.y.func_176734_d(), this.z);
        this.neighborThree = BoxCorner.getCorner(this.x, this.y, this.z.func_176734_d());
    }

    public Vector3d getVector(AxisAlignedBB box) {
        return new Vector3d(CreativeAxisAlignedBB.getCornerX(box, this), CreativeAxisAlignedBB.getCornerY(box, this), CreativeAxisAlignedBB.getCornerZ(box, this));
    }

    public boolean isFacingPositive(EnumFacing.Axis axis) {
        return this.getFacing(axis).func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
    }

    public EnumFacing getFacing(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.x;
            }
            case Y: {
                return this.y;
            }
            case Z: {
                return this.z;
            }
        }
        return null;
    }

    public BoxCorner flip(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return BoxCorner.getCorner(this.x.func_176734_d(), this.y, this.z);
            }
            case Y: {
                return BoxCorner.getCorner(this.x, this.y.func_176734_d(), this.z);
            }
            case Z: {
                return BoxCorner.getCorner(this.x, this.y, this.z.func_176734_d());
            }
        }
        return null;
    }

    public BoxCorner rotate(Rotation rotation) {
        int normalX = this.x.func_176743_c().func_179524_a();
        int normalY = this.y.func_176743_c().func_179524_a();
        int normalZ = this.z.func_176743_c().func_179524_a();
        return BoxCorner.getCorner(EnumFacing.func_181076_a((EnumFacing.AxisDirection)(rotation.getMatrix().getX(normalX, normalY, normalZ) > 0 ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)EnumFacing.Axis.X), EnumFacing.func_181076_a((EnumFacing.AxisDirection)(rotation.getMatrix().getY(normalX, normalY, normalZ) > 0 ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)EnumFacing.Axis.Y), EnumFacing.func_181076_a((EnumFacing.AxisDirection)(rotation.getMatrix().getZ(normalX, normalY, normalZ) > 0 ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)EnumFacing.Axis.Z));
    }

    public static BoxCorner getCornerUnsorted(EnumFacing facing, EnumFacing facing2, EnumFacing facing3) {
        return BoxCorner.getCorner(facing.func_176740_k() != EnumFacing.Axis.X ? (facing2.func_176740_k() != EnumFacing.Axis.X ? facing3 : facing2) : facing, facing.func_176740_k() != EnumFacing.Axis.Y ? (facing2.func_176740_k() != EnumFacing.Axis.Y ? facing3 : facing2) : facing, facing.func_176740_k() != EnumFacing.Axis.Z ? (facing2.func_176740_k() != EnumFacing.Axis.Z ? facing3 : facing2) : facing);
    }

    public static BoxCorner getCorner(EnumFacing x, EnumFacing y, EnumFacing z) {
        for (BoxCorner corner : BoxCorner.values()) {
            if (corner.x != x || corner.y != y || corner.z != z) continue;
            return corner;
        }
        return null;
    }

    public static BoxCorner[] faceCorners(EnumFacing facing) {
        return facingCorners[facing.ordinal()];
    }

    static {
        facingCorners = new BoxCorner[][]{{EDN, EDS, WDN, WDS}, {EUN, EUS, WUN, WUS}, {EUN, EDN, WUN, WDN}, {EUS, EDS, WUS, WDS}, {WUN, WUS, WDN, WDS}, {EUN, EUS, EDN, EDS}};
        for (BoxCorner corner : BoxCorner.values()) {
            corner.init();
        }
    }
}

