/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.VectorUtils;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class RotationUtils {
    private static String[] facingNames;
    private static String[] horizontalFacingNames;
    static BooleanRotation[][] rotations;

    public static String[] getHorizontalFacingNames() {
        if (horizontalFacingNames == null) {
            horizontalFacingNames = new String[4];
            for (int i = 0; i < horizontalFacingNames.length; ++i) {
                RotationUtils.horizontalFacingNames[i] = EnumFacing.func_176731_b((int)i).func_176610_l();
            }
        }
        return horizontalFacingNames;
    }

    public static String[] getFacingNames() {
        if (facingNames == null) {
            facingNames = new String[6];
            for (int i = 0; i < facingNames.length; ++i) {
                RotationUtils.facingNames[i] = EnumFacing.func_82600_a((int)i).func_176610_l();
            }
        }
        return facingNames;
    }

    public static EnumFacing getFacing(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return EnumFacing.EAST;
            }
            case Y: {
                return EnumFacing.UP;
            }
            case Z: {
                return EnumFacing.NORTH;
            }
        }
        return null;
    }

    public static EnumFacing.Axis getThird(EnumFacing.Axis one, EnumFacing.Axis two) {
        switch (one) {
            case X: {
                if (two == EnumFacing.Axis.Y) {
                    return EnumFacing.Axis.Z;
                }
                return EnumFacing.Axis.Y;
            }
            case Y: {
                if (two == EnumFacing.Axis.X) {
                    return EnumFacing.Axis.Z;
                }
                return EnumFacing.Axis.X;
            }
            case Z: {
                if (two == EnumFacing.Axis.Y) {
                    return EnumFacing.Axis.X;
                }
                return EnumFacing.Axis.Y;
            }
        }
        return null;
    }

    public static EnumFacing.Axis getOne(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return EnumFacing.Axis.Y;
            }
            case Y: {
                return EnumFacing.Axis.Z;
            }
            case Z: {
                return EnumFacing.Axis.X;
            }
        }
        return axis;
    }

    public static EnumFacing.Axis getTwo(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return EnumFacing.Axis.Z;
            }
            case Y: {
                return EnumFacing.Axis.X;
            }
            case Z: {
                return EnumFacing.Axis.Y;
            }
        }
        return axis;
    }

    public static EnumFacing.Axis rotate(EnumFacing.Axis axis, Rotation rotation) {
        if (axis == rotation.axis) {
            return axis;
        }
        switch (axis) {
            case X: {
                if (rotation.axis == EnumFacing.Axis.Y) {
                    return EnumFacing.Axis.Z;
                }
                return EnumFacing.Axis.Y;
            }
            case Y: {
                if (rotation.axis == EnumFacing.Axis.Z) {
                    return EnumFacing.Axis.X;
                }
                return EnumFacing.Axis.Y;
            }
            case Z: {
                if (rotation.axis == EnumFacing.Axis.X) {
                    return EnumFacing.Axis.Y;
                }
                return EnumFacing.Axis.X;
            }
        }
        return axis;
    }

    public static Rotation rotate(Rotation rotation, Rotation by) {
        Vector3d vec = rotation.getVec();
        by.getMatrix().transform((Tuple3d)vec);
        return Rotation.getRotation(vec);
    }

    public static Rotation flip(Rotation rotation, EnumFacing.Axis axis) {
        return rotation.axis == axis ? rotation.getOpposite() : rotation;
    }

    public static EnumFacing rotate(EnumFacing facing, Rotation rotation) {
        Vec3i rotatedNormal = new Vec3i(rotation.getMatrix().getX(facing.func_176730_m()), rotation.getMatrix().getY(facing.func_176730_m()), rotation.getMatrix().getZ(facing.func_176730_m()));
        for (EnumFacing rotated : EnumFacing.field_82609_l) {
            if (!rotated.func_176730_m().equals((Object)rotatedNormal)) continue;
            return rotated;
        }
        return facing;
    }

    public static Vec3i rotate(Vec3i vec, Rotation rotation) {
        return rotation.getMatrix().transform(vec);
    }

    public static BlockPos rotate(BlockPos vec, Rotation rotation) {
        return rotation.getMatrix().transform(vec);
    }

    public static void rotate(Vector3f vector, Rotation rotation) {
        rotation.getMatrix().transform((Tuple3f)vector);
    }

    public static void rotate(Vector3d vector, Rotation rotation) {
        rotation.getMatrix().transform((Tuple3d)vector);
    }

    public static Vec3i flip(Vec3i vec, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return new Vec3i(-vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
            }
            case Y: {
                return new Vec3i(vec.func_177958_n(), -vec.func_177956_o(), vec.func_177952_p());
            }
            case Z: {
                return new Vec3i(vec.func_177958_n(), vec.func_177956_o(), -vec.func_177952_p());
            }
        }
        return vec;
    }

    public static BlockPos flip(BlockPos vec, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return new BlockPos(-vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
            }
            case Y: {
                return new BlockPos(vec.func_177958_n(), -vec.func_177956_o(), vec.func_177952_p());
            }
            case Z: {
                return new BlockPos(vec.func_177958_n(), vec.func_177956_o(), -vec.func_177952_p());
            }
        }
        return vec;
    }

    public static void flip(Vector3f vec, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                vec.x = -vec.x;
                break;
            }
            case Y: {
                vec.y = -vec.y;
                break;
            }
            case Z: {
                vec.z = -vec.z;
            }
        }
    }

    public static void flip(Vector3d vec, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                vec.x = -vec.x;
                break;
            }
            case Y: {
                vec.y = -vec.y;
                break;
            }
            case Z: {
                vec.z = -vec.z;
            }
        }
    }

    public static boolean isFacingPositive(int index) {
        return index == 1 || index == 3 || index == 5;
    }

    public static EnumFacing.Axis getUAxisFromFacing(EnumFacing facing) {
        switch (facing.func_176740_k()) {
            case X: {
                return EnumFacing.Axis.Z;
            }
            case Y: {
                return EnumFacing.Axis.X;
            }
            case Z: {
                return EnumFacing.Axis.X;
            }
        }
        return null;
    }

    public static EnumFacing.Axis getVAxisFromFacing(EnumFacing facing) {
        switch (facing.func_176740_k()) {
            case X: {
                return EnumFacing.Axis.Y;
            }
            case Y: {
                return EnumFacing.Axis.Z;
            }
            case Z: {
                return EnumFacing.Axis.Y;
            }
        }
        return null;
    }

    public static float getUFromFacing(EnumFacing facing, float x, float y, float z) {
        switch (facing.func_176740_k()) {
            case X: {
                return z;
            }
            case Y: {
                return x;
            }
            case Z: {
                return x;
            }
        }
        return 0.0f;
    }

    public static float getVFromFacing(EnumFacing facing, float x, float y, float z) {
        switch (facing.func_176740_k()) {
            case X: {
                return y;
            }
            case Y: {
                return z;
            }
            case Z: {
                return y;
            }
        }
        return 0.0f;
    }

    public static EnumFacing.Axis getMirrorAxis(Mirror mirrorIn) {
        switch (mirrorIn) {
            case FRONT_BACK: {
                return EnumFacing.Axis.X;
            }
            case LEFT_RIGHT: {
                return EnumFacing.Axis.Z;
            }
        }
        return null;
    }

    public static Rotation getRotation(net.minecraft.util.Rotation rotationIn) {
        switch (rotationIn) {
            case CLOCKWISE_90: {
                return Rotation.Y_CLOCKWISE;
            }
            case CLOCKWISE_180: {
                return Rotation.Y_CLOCKWISE;
            }
            case COUNTERCLOCKWISE_90: {
                return Rotation.Y_COUNTER_CLOCKWISE;
            }
        }
        return null;
    }

    public static int getRotationCount(net.minecraft.util.Rotation rotationIn) {
        if (rotationIn == net.minecraft.util.Rotation.CLOCKWISE_180) {
            return 2;
        }
        return 1;
    }

    public static EnumFacing.AxisDirection getOffset(double d) {
        if (d > 0.0) {
            return EnumFacing.AxisDirection.POSITIVE;
        }
        if (d < 0.0) {
            return EnumFacing.AxisDirection.NEGATIVE;
        }
        return null;
    }

    static {
        rotations = new BooleanRotation[3][4];
    }

    public static enum BooleanRotation {
        X_PP(EnumFacing.Axis.X, 0, true, true),
        X_NP(EnumFacing.Axis.X, 1, false, true),
        X_NN(EnumFacing.Axis.X, 2, false, false),
        X_PN(EnumFacing.Axis.X, 3, true, false),
        Y_PP(EnumFacing.Axis.Y, 0, true, true),
        Y_PN(EnumFacing.Axis.Y, 1, true, false),
        Y_NN(EnumFacing.Axis.Y, 2, false, false),
        Y_NP(EnumFacing.Axis.Y, 3, false, true),
        Z_PP(EnumFacing.Axis.Z, 0, true, true),
        Z_NP(EnumFacing.Axis.Z, 1, false, true),
        Z_NN(EnumFacing.Axis.Z, 2, false, false),
        Z_PN(EnumFacing.Axis.Z, 3, true, false);

        public final EnumFacing.Axis axis;
        private final int index;
        private final boolean positiveOne;
        private final boolean positiveTwo;

        private BooleanRotation(EnumFacing.Axis axis, int index, boolean positiveOne, boolean positiveTwo) {
            this.axis = axis;
            this.index = index;
            this.positiveOne = positiveOne;
            this.positiveTwo = positiveTwo;
            RotationUtils.rotations[axis.ordinal()][index] = this;
        }

        private static EnumFacing.Axis getOne(EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return EnumFacing.Axis.Y;
                }
                case Y: 
                case Z: {
                    return EnumFacing.Axis.X;
                }
            }
            return null;
        }

        private static EnumFacing.Axis getTwo(EnumFacing.Axis axis) {
            switch (axis) {
                case X: 
                case Y: {
                    return EnumFacing.Axis.Z;
                }
                case Z: {
                    return EnumFacing.Axis.Y;
                }
            }
            return null;
        }

        public BooleanRotation clockwise() {
            if (this.index == 3) {
                return rotations[this.axis.ordinal()][0];
            }
            return rotations[this.axis.ordinal()][this.index + 1];
        }

        public BooleanRotation counterClockwise() {
            if (this.index == 0) {
                return rotations[this.axis.ordinal()][3];
            }
            return rotations[this.axis.ordinal()][this.index - 1];
        }

        public EnumFacing clockwiseMaxFacing() {
            return this.getFacingInBetween(this.clockwise());
        }

        public EnumFacing counterMaxClockwiseFacing() {
            return this.getFacingInBetween(this.counterClockwise());
        }

        private EnumFacing getFacingInBetween(BooleanRotation other) {
            if (this.positiveOne != other.positiveOne) {
                return EnumFacing.func_181076_a((EnumFacing.AxisDirection)(this.positiveTwo ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)BooleanRotation.getTwo(this.axis));
            }
            if (this.positiveTwo != other.positiveTwo) {
                return EnumFacing.func_181076_a((EnumFacing.AxisDirection)(this.positiveOne ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)BooleanRotation.getOne(this.axis));
            }
            throw new RuntimeException("Impossible to happen!");
        }

        public boolean is(Vector3d vec) {
            return this.positiveOne == VectorUtils.get(BooleanRotation.getOne(this.axis), (Tuple3d)vec) >= 0.0 && this.positiveTwo == VectorUtils.get(BooleanRotation.getTwo(this.axis), (Tuple3d)vec) >= 0.0;
        }

        public static BooleanRotation getRotationState(EnumFacing.Axis axis, Vector3d vec) {
            boolean positiveOne = VectorUtils.get(BooleanRotation.getOne(axis), (Tuple3d)vec) >= 0.0;
            boolean positiveTwo = VectorUtils.get(BooleanRotation.getTwo(axis), (Tuple3d)vec) >= 0.0;
            for (int i = 0; i < rotations[axis.ordinal()].length; ++i) {
                BooleanRotation rotation = rotations[axis.ordinal()][i];
                if (rotation.positiveOne != positiveOne || rotation.positiveTwo != positiveTwo) continue;
                return rotation;
            }
            return null;
        }
    }
}

