/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls.gui;

import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.utils.math.SmoothValue;
import net.minecraft.init.SoundEvents;

public class GuiScrollBox
extends GuiParent {
    public int maxScroll = 0;
    public SmoothValue scrolled = new SmoothValue(200L);
    public float scaleFactor;
    public boolean dragged;
    public int scrollbarWidth = 6;

    public GuiScrollBox(String name, int x, int y, int width, int height) {
        this(name, x, y, width, height, 1.0f);
    }

    public GuiScrollBox(String name, int x, int y, int width, int height, float scaleFactor) {
        super(name, x, y, width, height);
        this.scaleFactor = scaleFactor;
        this.marginWidth = 0;
    }

    @Override
    public float getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public double getOffsetY() {
        return -this.scrolled.current();
    }

    public void onScrolled() {
        if (this.scrolled.aimed() < 0.0) {
            this.scrolled.set(0.0);
        }
        if (this.scrolled.aimed() > (double)this.maxScroll) {
            this.scrolled.set(this.maxScroll);
        }
    }

    @Override
    public boolean mouseScrolled(int x, int y, int scrolled) {
        if (super.mouseScrolled(x, y, scrolled)) {
            return true;
        }
        this.scrolled.set(this.scrolled.aimed() - (double)(scrolled * 20));
        this.onScrolled();
        return true;
    }

    @Override
    public boolean mousePressed(int x, int y, int button) {
        if (button == 0 && this.width - x + this.posX <= this.scrollbarWidth && this.needsScrollbar()) {
            GuiScrollBox.playSound(SoundEvents.field_187909_gi);
            this.dragged = true;
            return true;
        }
        return super.mousePressed(x, y, button);
    }

    @Override
    public void mouseMove(int x, int y, int button) {
        if (this.dragged) {
            double percent = (double)(y - this.posY) / (double)this.height;
            this.scrolled.set((int)(percent * (double)this.maxScroll));
            this.onScrolled();
        }
        super.mouseMove(x, y, button);
    }

    @Override
    public void mouseReleased(int x, int y, int button) {
        super.mouseReleased(x, y, button);
        this.dragged = false;
    }

    public boolean needsScrollbar() {
        return this.lastRenderedHeight > this.height - this.getContentOffset() * 2;
    }

    @Override
    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        super.renderContent(helper, style, width - this.scrollbarWidth, height);
        style.getBorder(this).renderStyle(width - this.scrollbarWidth, 0, helper, this.scrollbarWidth, height);
        style.getMouseOverBackground(this).renderStyle(width - this.scrollbarWidth + 1, 0, helper, this.scrollbarWidth - 1, height);
        this.scrolled.tick();
        int scrollThingHeight = Math.max(10, Math.min(height, this.lastRenderedHeight / height / height));
        if (this.lastRenderedHeight < height) {
            scrollThingHeight = height;
        }
        double percent = this.scrolled.current() / (double)this.maxScroll;
        style.getFace(this).renderStyle(width - this.scrollbarWidth + 1, (int)(percent * (double)(height - scrollThingHeight)), helper, this.scrollbarWidth - 1, scrollThingHeight);
        this.maxScroll = Math.max(0, this.lastRenderedHeight - height) + 5;
    }

    @Override
    public boolean hasMouseOverEffect() {
        return false;
    }
}

