/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls.gui;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import java.util.ArrayList;
import java.util.List;

public class GuiListBoxBase<T extends GuiControl>
extends GuiScrollBox {
    protected List<T> content;
    protected List<GuiButtonRemove> removeButtons;
    public final boolean modifiable;
    public int space = 2;

    public GuiListBoxBase(String name, int x, int y, int width, int height, boolean modifiable, List<T> entries) {
        super(name, x, y, width, height);
        this.content = entries;
        this.modifiable = modifiable;
        if (modifiable) {
            this.removeButtons = new ArrayList<GuiButtonRemove>();
        }
        for (int i = 0; i < entries.size(); ++i) {
            this.addControl((GuiControl)entries.get(i));
            if (!modifiable) continue;
            GuiButtonRemove button = new GuiButtonRemove(i);
            this.addControl(button);
            this.removeButtons.add(button);
        }
        this.reloadPositions();
    }

    public void reloadPositions() {
        int y = this.space / 2;
        for (int i = 0; i < this.content.size(); ++i) {
            GuiControl control = (GuiControl)this.content.get(i);
            if (this.modifiable) {
                GuiButtonRemove button = this.removeButtons.get(i);
                button.index = i;
                button.posY = y + 3;
            }
            control.posY = y;
            y += control.height + this.space;
        }
    }

    public void remove(int index) {
        this.removeControl((GuiControl)this.content.get(index));
        this.content.remove(index);
        if (this.modifiable) {
            this.removeControl(this.removeButtons.get(index));
            this.removeButtons.remove(index);
        }
        this.reloadPositions();
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    public void clear() {
        for (int i = 0; i < this.content.size(); ++i) {
            this.removeControl((GuiControl)this.content.get(i));
            if (!this.modifiable) continue;
            this.removeControl(this.removeButtons.get(i));
        }
        this.content.clear();
        if (this.modifiable) {
            this.removeButtons.clear();
        }
    }

    public void addAll(List<T> entries) {
        for (GuiControl entry : entries) {
            this.content.add(entry);
            this.addControl(entry);
            if (!this.modifiable) continue;
            GuiButtonRemove button = new GuiButtonRemove(this.content.size() - 1);
            this.addControl(button);
            this.removeButtons.add(button);
        }
        this.reloadPositions();
    }

    public void add(T entry) {
        this.content.add(entry);
        this.addControl((GuiControl)entry);
        if (this.modifiable) {
            GuiButtonRemove button = new GuiButtonRemove(this.content.size() - 1);
            this.addControl(button);
            this.removeButtons.add(button);
        }
        if (this.content.size() == 1) {
            this.reloadPositions();
        } else {
            GuiControl before = (GuiControl)this.content.get(this.content.size() - 2);
            ((GuiControl)entry).posY = before.posY + before.height + this.space;
            if (this.modifiable) {
                this.removeButtons.get((int)(this.removeButtons.size() - 1)).posY = before.posY + before.height + this.space + 3;
            }
        }
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public int size() {
        return this.content.size();
    }

    public T get(int index) {
        return (T)((GuiControl)this.content.get(index));
    }

    public class GuiButtonRemove
    extends GuiButton {
        public int index;

        public GuiButtonRemove(int index) {
            super("x", GuiListBoxBase.this.width - 25, 0, 8, 8);
            this.index = index;
        }

        @Override
        public void onClicked(int x, int y, int button) {
            GuiListBoxBase.this.remove(this.index);
        }
    }
}

