/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.client.rendering.model;

import com.creativemd.creativecore.client.mods.optifine.OptifineHelper;
import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.client.rendering.model.BufferBuilderUtils;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.creativecore.common.utils.type.SingletonList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.pipeline.BlockInfo;
import net.minecraftforge.client.model.pipeline.ForgeBlockModelRenderer;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.client.model.pipeline.VertexLighterSmoothAo;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.util.Color;

public class CreativeModelPipeline {
    public static BlockModelRenderer renderer;
    private static BlockColors blockColors;
    private static Class ambientOcclusionFaceClass;
    private static Constructor ambientOcclusionFaceClassConstructor;
    private static Method renderQuadsSmoothMethod;
    private static Method renderQuadsFlatMethod;
    private static Field vertexColorMultiplierField;
    private static Field lighterFlatField;
    private static Field lighterSmoothField;
    private static Field wrFlatField;
    private static Field wrSmoothField;
    private static Method setBufferMethod;
    private static Field blockInfoField;
    private static Field fullBlockInfoField;
    public static ThreadLocal<SingletonList<BakedQuad>> singletonList;

    public static Object createAmbientOcclusionFace() {
        try {
            return ambientOcclusionFaceClassConstructor.newInstance(renderer);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not create ambient occlusion face!");
        }
    }

    public static void renderBlockFaceSmooth(IBlockAccess world, IBlockState state, BlockPos pos, BufferBuilder buffer, BlockRenderLayer layer, List<BakedQuad> quads, float[] afloat, EnumFacing facing, BitSet set, Object ambientOcclusionFace, RenderBox cube) {
        try {
            SingletonList<BakedQuad> list = singletonList.get();
            if (ForgeModContainer.forgeLightPipelineEnabled) {
                ThreadLocal wrSmooth = (ThreadLocal)wrSmoothField.get(renderer);
                ThreadLocal lighterSmooth = (ThreadLocal)lighterSmoothField.get(renderer);
                VertexBufferConsumer newCons = (VertexBufferConsumer)wrSmooth.get();
                if (setBufferMethod == null) {
                    newCons = new VertexBufferConsumer(buffer);
                    wrSmooth.set(newCons);
                } else {
                    setBufferMethod.invoke((Object)newCons, buffer);
                }
                ((VertexLighterSmoothAo)lighterSmooth.get()).setParent((IVertexConsumer)newCons);
                ((VertexBufferConsumer)wrSmooth.get()).setOffset(pos);
                VertexLighterSmoothAo lighter = (VertexLighterSmoothAo)lighterSmooth.get();
                lighter.setWorld(world);
                lighter.setState(state);
                lighter.setBlockPos(pos);
                lighter.updateBlockInfo();
                fullBlockInfoField.setBoolean(blockInfoField.get(lighter), false);
                for (int i = 0; i < quads.size(); ++i) {
                    quads.get(i).pipe((IVertexConsumer)lighter);
                    CreativeModelPipeline.overwriteColor(world, state, pos, buffer, layer, quads.get(i), cube, null, (VertexLighterFlat)lighter);
                }
            } else {
                for (int i = 0; i < quads.size(); ++i) {
                    SingletonList<BakedQuad> singleQuad;
                    SingletonList<BakedQuad> singletonList = singleQuad = quads instanceof SingletonList ? (SingletonList<BakedQuad>)quads : list.setElement(quads.get(i));
                    if (FMLClientHandler.instance().hasOptifine()) {
                        renderQuadsSmoothMethod.invoke((Object)renderer, world, state, pos, buffer, singleQuad, ambientOcclusionFace);
                    } else {
                        renderQuadsSmoothMethod.invoke((Object)renderer, world, state, pos, buffer, singleQuad, afloat, set, ambientOcclusionFace);
                    }
                    CreativeModelPipeline.overwriteColor(world, state, pos, buffer, layer, singleQuad.get(0), cube, ambientOcclusionFace, null);
                }
            }
            list.setElement(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void renderBlockFaceFlat(IBlockAccess world, IBlockState state, BlockPos pos, BufferBuilder buffer, BlockRenderLayer layer, List<BakedQuad> quads, EnumFacing facing, BitSet set, RenderBox cube, Object renderEnv) {
        int light = state.func_185889_a(world, pos.func_177972_a(facing));
        try {
            if (ForgeModContainer.forgeLightPipelineEnabled) {
                ThreadLocal wrFlat = (ThreadLocal)wrFlatField.get(renderer);
                ThreadLocal lighterFlat = (ThreadLocal)lighterFlatField.get(renderer);
                VertexBufferConsumer newCons = (VertexBufferConsumer)wrFlat.get();
                if (setBufferMethod == null) {
                    newCons = new VertexBufferConsumer(buffer);
                    wrFlat.set(newCons);
                } else {
                    setBufferMethod.invoke((Object)newCons, buffer);
                }
                ((VertexLighterFlat)lighterFlat.get()).setParent((IVertexConsumer)newCons);
                ((VertexBufferConsumer)wrFlat.get()).setOffset(pos);
                VertexLighterFlat lighter = (VertexLighterFlat)lighterFlat.get();
                lighter.setWorld(world);
                lighter.setState(state);
                lighter.setBlockPos(pos);
                lighter.updateBlockInfo();
                fullBlockInfoField.setBoolean(blockInfoField.get(lighter), false);
                for (int i = 0; i < quads.size(); ++i) {
                    quads.get(i).pipe((IVertexConsumer)lighter);
                    CreativeModelPipeline.overwriteColor(world, state, pos, buffer, layer, quads.get(i), cube, null, null);
                }
            } else {
                for (int i = 0; i < quads.size(); ++i) {
                    List<BakedQuad> singleQuad;
                    SingletonList<BakedQuad> list = singletonList.get();
                    List<BakedQuad> list2 = singleQuad = quads instanceof SingletonList ? quads : list.setElement(quads.get(i));
                    if (FMLClientHandler.instance().hasOptifine()) {
                        renderQuadsFlatMethod.invoke((Object)renderer, world, state, pos, light, false, buffer, singleQuad, renderEnv);
                    } else {
                        renderQuadsFlatMethod.invoke((Object)renderer, world, state, pos, light, false, buffer, singleQuad, set);
                    }
                    CreativeModelPipeline.overwriteColor(world, state, pos, buffer, layer, singleQuad.get(0), cube, null, null);
                    list.setElement(null);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void overwriteColor(IBlockAccess world, IBlockState state, BlockPos pos, BufferBuilder buffer, BlockRenderLayer layer, BakedQuad quad, RenderBox cube, Object ambientOcclusionFace, VertexLighterFlat lighter) {
        if (FMLClientHandler.instance().hasOptifine() && ambientOcclusionFace != null) {
            ambientOcclusionFace = OptifineHelper.getAoFace(ambientOcclusionFace);
        }
        float[] vertexColorMultiplier = null;
        try {
            vertexColorMultiplier = ambientOcclusionFace != null ? (float[])vertexColorMultiplierField.get(ambientOcclusionFace) : null;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        VertexFormat format = buffer.func_178973_g();
        int tint = quad.func_178211_c();
        int multiplier = -1;
        if (OptifineHelper.isActive() && (multiplier = OptifineHelper.getColorMultiplier(quad, state, world, pos)) != -1) {
            tint = 0;
        }
        if (tint != -1 && (cube.color == -1 || ColorUtils.isWhite(cube.color))) {
            if (multiplier == -1) {
                multiplier = blockColors.func_186724_a(state, world, pos, tint);
            }
            Color tempColor = ColorUtils.IntToRGBA(multiplier);
            if (cube.color != -1) {
                tempColor.setAlpha(ColorUtils.getAlpha(cube.color));
            } else {
                tempColor.setAlpha(255);
            }
            multiplier = ColorUtils.RGBAToInt(tempColor);
        } else {
            if (layer == BlockRenderLayer.CUTOUT_MIPPED && state.func_177230_c().func_180664_k() != BlockRenderLayer.CUTOUT_MIPPED) {
                tint = 0;
            }
            if (layer != BlockRenderLayer.CUTOUT_MIPPED || state.func_177230_c().canRenderInLayer(state, BlockRenderLayer.CUTOUT)) {
                tint = 0;
            }
            multiplier = cube.color;
            if (EntityRenderer.field_78517_a) {
                multiplier = TextureUtil.func_177054_c((int)multiplier);
            }
        }
        if (tint != -1 && cube.color != -1) {
            float r = (float)(multiplier >> 16 & 0xFF) / 255.0f;
            float g = (float)(multiplier >> 8 & 0xFF) / 255.0f;
            float b = (float)(multiplier & 0xFF) / 255.0f;
            int a = ColorUtils.getAlpha(multiplier);
            if (vertexColorMultiplier != null || lighter != null) {
                if (ForgeModContainer.forgeLightPipelineEnabled) {
                    try {
                        BlockInfo info = (BlockInfo)blockInfoField.get(lighter);
                        int oldMultiplier = info.getColorMultiplier(quad.func_178211_c());
                        for (int i = 1; i <= 4; ++i) {
                            float ao;
                            int exisiting = BufferBuilderUtils.get(buffer, buffer.func_78909_a(i));
                            float f = ColorUtils.getRed(oldMultiplier) > 0 ? (float)ColorUtils.getRed(exisiting) / (float)ColorUtils.getRed(oldMultiplier) : (ao = ColorUtils.getGreen(oldMultiplier) > 0 ? (float)ColorUtils.getGreen(exisiting) / (float)ColorUtils.getGreen(oldMultiplier) : (float)ColorUtils.getBlue(exisiting) / (float)ColorUtils.getBlue(oldMultiplier));
                            if (!Float.isFinite(ao)) {
                                ao = 1.0f;
                            }
                            buffer.putColorRGBA(buffer.func_78909_a(i), (int)(r * ao * 255.0f), (int)(g * ao * 255.0f), (int)(b * ao * 255.0f), a);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                } else {
                    buffer.putColorRGBA(buffer.func_78909_a(4), (int)(vertexColorMultiplier[0] * r * 255.0f), (int)(vertexColorMultiplier[0] * g * 255.0f), (int)(vertexColorMultiplier[0] * b * 255.0f), a);
                    buffer.putColorRGBA(buffer.func_78909_a(3), (int)(vertexColorMultiplier[1] * r * 255.0f), (int)(vertexColorMultiplier[1] * g * 255.0f), (int)(vertexColorMultiplier[1] * b * 255.0f), a);
                    buffer.putColorRGBA(buffer.func_78909_a(2), (int)(vertexColorMultiplier[2] * r * 255.0f), (int)(vertexColorMultiplier[2] * g * 255.0f), (int)(vertexColorMultiplier[2] * b * 255.0f), a);
                    buffer.putColorRGBA(buffer.func_78909_a(1), (int)(vertexColorMultiplier[3] * r * 255.0f), (int)(vertexColorMultiplier[3] * g * 255.0f), (int)(vertexColorMultiplier[3] * b * 255.0f), a);
                }
            } else {
                if (quad.shouldApplyDiffuseLighting()) {
                    float diffuse = LightUtil.diffuseLight((EnumFacing)quad.func_178210_d());
                    r *= diffuse;
                    g *= diffuse;
                    b *= diffuse;
                }
                buffer.putColorRGBA(buffer.func_78909_a(4), (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), a);
                buffer.putColorRGBA(buffer.func_78909_a(3), (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), a);
                buffer.putColorRGBA(buffer.func_78909_a(2), (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), a);
                buffer.putColorRGBA(buffer.func_78909_a(1), (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), a);
            }
        }
    }

    static {
        try {
            renderer = Minecraft.func_71410_x().func_175602_ab().func_175019_b();
            blockColors = Minecraft.func_71410_x().func_184125_al();
            for (Class<?> clazz : BlockModelRenderer.class.getDeclaredClasses()) {
                if (!clazz.getName().equals("net.minecraft.client.renderer.BlockModelRenderer$AmbientOcclusionFace")) continue;
                ambientOcclusionFaceClass = clazz;
                break;
            }
            ambientOcclusionFaceClassConstructor = ReflectionHelper.findConstructor((Class)ambientOcclusionFaceClass, (Class[])new Class[]{BlockModelRenderer.class});
            vertexColorMultiplierField = ReflectionHelper.findField((Class)ambientOcclusionFaceClass, (String[])new String[]{"vertexColorMultiplier", "field_178206_b"});
            if (FMLClientHandler.instance().hasOptifine()) {
                renderQuadsSmoothMethod = ReflectionHelper.findMethod(BlockModelRenderer.class, (String)"renderQuadsSmooth", (String)"renderQuadsSmooth", (Class[])new Class[]{IBlockAccess.class, IBlockState.class, BlockPos.class, BufferBuilder.class, List.class, OptifineHelper.renderEnvClass});
                renderQuadsFlatMethod = ReflectionHelper.findMethod(BlockModelRenderer.class, (String)"renderQuadsFlat", (String)"renderQuadsFlat", (Class[])new Class[]{IBlockAccess.class, IBlockState.class, BlockPos.class, Integer.TYPE, Boolean.TYPE, BufferBuilder.class, List.class, OptifineHelper.renderEnvClass});
            } else {
                renderQuadsSmoothMethod = ReflectionHelper.findMethod(BlockModelRenderer.class, (String)"renderQuadsSmooth", (String)"func_187492_a", (Class[])new Class[]{IBlockAccess.class, IBlockState.class, BlockPos.class, BufferBuilder.class, List.class, float[].class, BitSet.class, ambientOcclusionFaceClass});
                renderQuadsFlatMethod = ReflectionHelper.findMethod(BlockModelRenderer.class, (String)"renderQuadsFlat", (String)"func_187496_a", (Class[])new Class[]{IBlockAccess.class, IBlockState.class, BlockPos.class, Integer.TYPE, Boolean.TYPE, BufferBuilder.class, List.class, BitSet.class});
            }
            lighterFlatField = ReflectionHelper.findField(ForgeBlockModelRenderer.class, (String[])new String[]{"lighterFlat"});
            lighterSmoothField = ReflectionHelper.findField(ForgeBlockModelRenderer.class, (String[])new String[]{"lighterSmooth"});
            wrFlatField = ReflectionHelper.findField(ForgeBlockModelRenderer.class, (String[])new String[]{"wrFlat", "consumerFlat"});
            wrSmoothField = ReflectionHelper.findField(ForgeBlockModelRenderer.class, (String[])new String[]{"wrSmooth", "consumerSmooth"});
            try {
                setBufferMethod = ReflectionHelper.findMethod(VertexBufferConsumer.class, (String)"setBuffer", (String)"setBuffer", (Class[])new Class[]{BufferBuilder.class});
            }
            catch (ReflectionHelper.UnableToFindMethodException e) {
                setBufferMethod = null;
            }
            blockInfoField = ReflectionHelper.findField(VertexLighterFlat.class, (String[])new String[]{"blockInfo"});
            fullBlockInfoField = ReflectionHelper.findField(BlockInfo.class, (String[])new String[]{"full"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        singletonList = ThreadLocal.withInitial(() -> new SingletonList<Object>(null));
    }
}

