/*
 * Decompiled with CFR 0.152.
 */
package portablejim.bbw.shims;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import portablejim.bbw.basics.Point3d;
import portablejim.bbw.shims.IWorldShim;

public class BasicWorldShim
implements IWorldShim {
    private World world;

    public BasicWorldShim(World world) {
        this.world = world;
    }

    @Override
    public Block getBlock(Point3d point) {
        if (this.world != null) {
            return this.world.func_180495_p(new BlockPos(point.x, point.y, point.z)).func_177230_c();
        }
        return null;
    }

    @Override
    public boolean blockIsAir(Point3d point) {
        return this.world.func_175623_d(new BlockPos(point.x, point.y, point.z));
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public boolean copyBlock(Point3d originalBlock, Point3d blockPos) {
        IBlockState blockState = this.world.func_180495_p(new BlockPos(originalBlock.x, originalBlock.y, originalBlock.z));
        boolean retval = this.world.func_180501_a(new BlockPos(blockPos.x, blockPos.y, blockPos.z), blockState, 3);
        this.world.func_180501_a(new BlockPos(blockPos.x, blockPos.y, blockPos.z), blockState, 3);
        return retval;
    }

    @Override
    public void setBlockToAir(Point3d blockPos) {
        this.world.func_175698_g(new BlockPos(blockPos.x, blockPos.y, blockPos.z));
    }

    @Override
    public int getMetadata(Point3d point) {
        if (this.world != null) {
            IBlockState state = this.world.func_180495_p(new BlockPos(point.x, point.y, point.z));
            return state.func_177230_c().func_176201_c(state);
        }
        return 0;
    }

    @Override
    public boolean entitiesInBox(AxisAlignedBB box) {
        if (box == null) {
            return false;
        }
        List entitiesWithinAABB = this.world.func_72872_a(EntityLivingBase.class, box);
        return entitiesWithinAABB.size() > 0;
    }

    @Override
    public void playPlaceAtBlock(Point3d position, Block blockType) {
        if (position != null && blockType != null) {
            this.world.func_184134_a((double)position.x + 0.5, (double)position.y + 0.5, (double)position.z + 0.5, blockType.func_185467_w().func_185841_e(), SoundCategory.BLOCKS, (blockType.func_185467_w().func_185843_a() + 1.0f) / 2.0f, blockType.func_185467_w().func_185847_b() * 0.8f, false);
        }
    }

    @Override
    public boolean setBlock(Point3d position, Block block, int meta) {
        return this.world.func_180501_a(position.toBlockPos(), block.func_176203_a(meta), 3);
    }

    @Override
    public boolean setBlock(Point3d blockPos, IBlockState targetBlock) {
        return this.world.func_180501_a(blockPos.toBlockPos(), targetBlock, 3);
    }

    @Override
    public Random rand() {
        return this.world.field_73012_v;
    }
}

