/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.materials.CraftingRecipe;
import com.endertech.minecraft.forge.regs.INeedToRegister;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitVariant;
import com.endertech.minecraft.forge.world.ForgeWorld;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IForgeUnit
extends INeedToRegister,
IHaveConfig {
    public static String getStatus(IForgeUnit unit) {
        if (unit != null) {
            if (unit.isEnabled()) {
                if (unit.isReadyToRegister()) {
                    return "OK";
                }
                return "NOT READY";
            }
            return "DISABLED";
        }
        return "unit is NULL!";
    }

    default public UnitId createId(String modId, String name) {
        return UnitId.from(modId, name, this.getClassRegName());
    }

    public static UnitConfig createConfig(ForgeMod mod, String folder, Class<?> clazz) {
        Path baseDir = mod.getConfig().getConfigDir().resolve(folder);
        String configName = IForgeUnit.getClassRegName(clazz);
        return new UnitConfig(baseDir, configName);
    }

    default public <E extends Enum<E>> Map<Object, UnitVariant> createUnitVariants(Class<E> clazz) {
        HashMap<Object, UnitVariant> map = new HashMap<Object, UnitVariant>();
        for (Enum en : (Enum[])clazz.getEnumConstants()) {
            UnitId id = this.getId().withMeta(en.ordinal());
            UnitVariant variant = UnitVariant.from(id, en);
            map.put(en, variant);
        }
        return map;
    }

    default public void addCraftingRecipe(String pattern, int amount, String ... components) {
        CraftingRecipe recipe = CraftingRecipe.CreateMain(this.getUnitCategory(), this.getConfig(), pattern, this.getStringId(), amount, components);
        this.addCraftingRecipe(recipe);
    }

    default public void addCraftingRecipe(CraftingRecipe recipe) {
        if (this.isEnabled()) {
            this.getMod().getRegistrator().addCrafting(recipe);
        }
    }

    public static String getClassRegName(Class<?> clazz) {
        return UnitId.dictToRegName(clazz.getSimpleName());
    }

    default public String getClassRegName() {
        return IForgeUnit.getClassRegName(this.getClass());
    }

    default public String getUnitCategory() {
        return this.getId().getDictName();
    }

    default public boolean isServerSide(World world) {
        return ForgeWorld.isServerSide(world);
    }

    default public boolean isClientSide(World world) {
        return ForgeWorld.isClientSide(world);
    }

    public UnitId getId();

    default public String getStringId() {
        return this.getId().toString();
    }

    public ForgeMod getMod();

    public boolean isEnabled();

    public boolean isRegistered();

    public void onInit();

    @SideOnly(value=Side.CLIENT)
    public void onInitClient();

    public Map<Object, UnitVariant> getUnitVariants();

    public UnitVariant getDefaultVariant();

    default public UnitVariant getVariant(Object key) {
        return this.getUnitVariants().getOrDefault(key, this.getDefaultVariant());
    }

    public <E extends Enum<E>> void setUnitVariants(Class<E> var1);

    default public void register() {
        this.getMod().getRegistrator().addUnit(this);
    }

    default public void unregister() {
        this.getMod().getRegistrator().removeUnit(this);
    }

    default public boolean displayOnCreativeTab() {
        return this.isEnabled();
    }

    public static enum Variants implements IForgeEnum
    {
        NORMAL,
        INVENTORY;


        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }
    }
}

