/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.materials.RepairMatcher;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public abstract class DamageableItem
extends ForgeItem {
    protected final List<UnitId> repairMaterials;
    private final boolean repairCostGrow;
    private final int durability;

    public DamageableItem(ForgeMod mod, UnitConfig config, String name, CreativeTabs tab, int durability, UnitId repair) {
        super(mod, config, name, tab);
        this.durability = ForgeConfig.getInt(this.getConfig(), this.getUnitCategory(), "durability", durability, ForgeBounds.DURABILITY.getIntBounds(), "Defines durability of the item.");
        this.repairMaterials = this.parseRepairMaterials(this.getConfig(), this.getUnitCategory(), repair.toString());
        this.repairCostGrow = UnitConfig.getBool(this.getConfig(), this.getUnitCategory(), "repairCostGrow", false, "If true, repair cost will grow for this item after each repair using an anvil.");
        this.func_77656_e(this.durability);
        this.func_77625_d(1);
    }

    public int getMaxDamage(ItemStack stack) {
        String key = "maxDamage";
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(key) ? stack.func_77978_p().func_74762_e(key) : this.durability;
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, damage);
    }

    public void updateDurability(ItemStack stack, EntityPlayerMP player) {
        ForgeItem.ensureHasNBT(stack);
        stack.func_77978_p().func_74768_a("maxDamage", this.durability);
    }

    public boolean func_77645_m() {
        return true;
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        for (ItemStack stack : new ItemStack[]{event.getLeft(), event.getRight()}) {
            Item item = stack.func_77973_b();
            if (!(item instanceof DamageableItem) || ((DamageableItem)item).isRepairCostGrow()) continue;
            DamageableItem.removeRepairPenaltyFor(stack);
        }
    }

    public static void removeRepairPenaltyFor(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o("RepairCost");
        }
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        RepairMatcher matcher = RepairMatcher.from(material);
        for (UnitId id : this.repairMaterials) {
            if (!matcher.matches(id)) continue;
            return true;
        }
        return false;
    }

    public boolean isRepairCostGrow() {
        return this.repairCostGrow;
    }

    public Percentage getWearoutPercentage(ItemStack stack) {
        return Percentage.from(stack.func_77952_i(), stack.func_77958_k());
    }

    protected List<UnitId> parseRepairMaterials(ForgeConfig config, String category, String defaultValue) {
        String stringValue = UnitConfig.getStr(this.getConfig(), this.getUnitCategory(), "repair", defaultValue, "Defines anvil repair materials.\nYou can define several materials by separating them with commas (e.g.: minecraft:leather, #wool)");
        ArrayList<UnitId> list = new ArrayList<UnitId>();
        for (String str : stringValue.split(",")) {
            UnitId id;
            if ((str = str.trim()).isEmpty() || !(id = UnitId.from(str)).notEmpty()) continue;
            list.add(id);
        }
        return list;
    }
}

