/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.common.Args;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeLocating;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.ForgeBlockItem;
import com.endertech.minecraft.forge.materials.ForgeMaterial;
import com.endertech.minecraft.forge.tools.ForgeTool;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.UnitEnabled;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitVariant;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeBlock
extends Block
implements IForgeUnit {
    private final UnitEnabled unitEnabled;
    private final ForgeConfig config;
    private final ForgeMod mod;
    private final UnitId id;
    private Map<Object, UnitVariant> variants = new HashMap<Object, UnitVariant>();
    private final UnitVariant defaultVariant;
    private ResourceLocation textureLocation;

    public ForgeBlock(ForgeMod mod, UnitConfig config, String name, Material material, CreativeTabs tab) {
        super(material);
        this.mod = mod;
        this.id = this.createId(mod.getId(), name);
        this.config = config;
        this.unitEnabled = new UnitEnabled(config, this.getUnitCategory(), true);
        this.defaultVariant = UnitVariant.from(this.id, IForgeUnit.Variants.NORMAL);
        this.textureLocation = ForgeLocating.blockTexture(this.getMod().getId(), this.getId().getRegName(), new String[0]);
        this.setRegistryName(this.getId().toResLoc());
        this.func_149663_c(this.getId().getRegName());
        this.func_149647_a(tab);
        this.register();
    }

    public ForgeBlock(ForgeMod mod, UnitConfig config, String name, Material material, float hardness, float resistance, CreativeTabs tab) {
        this(mod, config, name, material, tab);
        this.func_149711_c(hardness);
        this.setResistance(resistance);
    }

    public static boolean isUnderRain(World world, BlockPos pos) {
        return world.func_175727_C(pos.func_177984_a());
    }

    public static boolean isUnderOpenSky(World world, BlockPos pos) {
        return world.func_175678_i(pos.func_177984_a());
    }

    @Nullable
    public static Block getBlockOrNull(Item item) {
        return item instanceof ItemBlock ? ((ItemBlock)item).func_179223_d() : null;
    }

    public static Material getDefaultMaterialOr(Block block, Material material) {
        return block != null ? block.func_176223_P().func_185904_a() : material;
    }

    public static String getStringId(Block block) {
        return UnitId.from(block, 0).toString();
    }

    public static <T extends Enum<T>> PropertyEnum<T> createPropertyEnum(Class<T> clazz) {
        return PropertyEnum.func_177709_a((String)IForgeUnit.getClassRegName(clazz), clazz);
    }

    public static UnitConfig createDefaultConfig(ForgeMod mod, String blockName) {
        Path baseDir = mod.getConfig().getConfigDir().resolve("blocks");
        String configName = UnitId.dictToRegName(blockName);
        return new UnitConfig(baseDir, configName);
    }

    public float getHardness() {
        return this.field_149782_v;
    }

    public float getResistance() {
        return this.field_149781_w;
    }

    public ResourceLocation getTextureLocationFor(IBlockState state) {
        return this.textureLocation;
    }

    public ForgeBlock setResistance(float resistance) {
        this.field_149781_w = resistance;
        return this;
    }

    public ForgeBlock setLightValue(int value) {
        this.field_149784_t = value;
        return this;
    }

    public String toString() {
        return ForgeBlock.class.getSimpleName() + Args.group(Args.get("status", IForgeUnit.getStatus(this)), Args.get("regName", this.getId().getRegName()), Args.get("enabled", this.isEnabled()), Args.get("hardness", Float.valueOf(this.getHardness())), Args.get("resistance", Float.valueOf(this.getResistance())), Args.get("harvestLevel", this.getHarvestLevel(this.func_176223_P())));
    }

    @Override
    public boolean isEnabled() {
        return this.unitEnabled.isEnabled();
    }

    public static boolean isRegistered(Block block) {
        return ForgeRegistries.BLOCKS.containsValue((IForgeRegistryEntry)block);
    }

    @Override
    public boolean isRegistered() {
        return ForgeBlock.isRegistered(this);
    }

    public static float getHardnessFrom(ForgeConfig config, String category, float defaultValue) {
        return ForgeConfig.getFloat(config, category, "hardness", defaultValue, new FloatBounds(Float.valueOf(-1.0f), Float.valueOf(Float.MAX_VALUE)), "Defines how many hits it takes to break the block.\n -1 makes the block indestructible.");
    }

    public static float getResistanceFrom(ForgeConfig config, String category, float defaultValue) {
        return ForgeConfig.getFloat(config, category, "resistance", defaultValue, new FloatBounds(Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE)), "Defines the block resistance to explosions.");
    }

    @Override
    public void onInit() {
        this.field_149782_v = ForgeBlock.getHardnessFrom(this.getConfig(), this.getUnitCategory(), this.getHardness());
        this.field_149781_w = ForgeBlock.getResistanceFrom(this.getConfig(), this.getUnitCategory(), this.getResistance());
        this.saveConfig();
    }

    @Override
    public boolean isReadyToRegister() {
        return true;
    }

    @Override
    public UnitId getId() {
        return this.id;
    }

    @Override
    public ForgeConfig getConfig() {
        return this.config;
    }

    @Override
    public ForgeMod getMod() {
        return this.mod;
    }

    public boolean hasVariants() {
        return this.variants.size() > 1;
    }

    @Override
    public Map<Object, UnitVariant> getUnitVariants() {
        return this.variants;
    }

    public ItemBlock createBlockItem() {
        ForgeBlockItem blockItem = new ForgeBlockItem(this);
        return blockItem;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onInitClient() {
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void setHarvestLevel(Class<? extends ForgeTool> tool, ForgeMaterial material) {
        String toolClass = ForgeTool.getToolClass(tool);
        int harvestLevel = ForgeMaterial.calculateHarvestLevel(material);
        super.setHarvestLevel(toolClass, harvestLevel);
    }

    @Nullable
    public CreativeTabs func_149708_J() {
        return this.displayOnCreativeTab() ? super.func_149708_J() : null;
    }

    @Override
    public UnitVariant getDefaultVariant() {
        return this.defaultVariant;
    }

    @Override
    public <E extends Enum<E>> void setUnitVariants(Class<E> clazz) {
        this.variants = this.createUnitVariants(clazz);
    }
}

