/*
 * Decompiled with CFR 0.152.
 */
package com.viesis.viescraft.common.tileentity;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityAirshipWorkbench
extends TileEntity {
    public ItemStackHandler inventory = new ItemStackHandler(this.size);
    private int size = 64;
    private String airshipWorkbenchCustomName;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Slots", (NBTBase)this.inventory.serializeNBT());
        if (this.hasCustomName()) {
            compound.func_74778_a("CustomName", this.airshipWorkbenchCustomName);
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("Slots"));
        if (compound.func_150297_b("CustomName", 8)) {
            this.airshipWorkbenchCustomName = compound.func_74779_i("CustomName");
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public String getName() {
        return this.hasCustomName() ? this.airshipWorkbenchCustomName : "airship_workbench";
    }

    public boolean hasCustomName() {
        return this.airshipWorkbenchCustomName != null && !this.airshipWorkbenchCustomName.isEmpty();
    }
}

