/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.item;

import com.mrcrayfish.vehicle.VehicleMod;
import com.mrcrayfish.vehicle.item.IDyeable;
import com.mrcrayfish.vehicle.item.SubItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemSprayCan
extends Item
implements SubItems,
IDyeable {
    public static final int MAX_SPRAYS = 5;

    public ItemSprayCan() {
        this.func_77655_b("vehicle:spray_can".replace(":", "."));
        this.setRegistryName("vehicle:spray_can");
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(VehicleMod.CREATIVE_TAB);
    }

    @Override
    public NonNullList<ResourceLocation> getModels() {
        NonNullList modelLocations = NonNullList.func_191196_a();
        modelLocations.add((Object)new ResourceLocation(this.getRegistryName() + "_lid"));
        modelLocations.add((Object)new ResourceLocation(this.getRegistryName().toString()));
        return modelLocations;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (GuiScreen.func_146272_n()) {
            String info = I18n.func_135052_a((String)"item.vehicle.spray_can.info", (Object[])new Object[0]);
            tooltip.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(info, 150));
        } else {
            if (this.hasColor(stack)) {
                tooltip.add(I18n.func_135052_a((String)"item.color", (Object[])new Object[]{TextFormatting.DARK_GRAY.toString() + String.format("#%06X", ItemSprayCan.createTagCompound(stack).func_74762_e("color"))}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"item.vehicle.spray_can.empty", (Object[])new Object[0]));
            }
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.info_help", (Object[])new Object[0]));
        }
    }

    public static NBTTagCompound createTagCompound(ItemStack stack) {
        NBTTagCompound tagCompound;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((tagCompound = stack.func_77978_p()) != null && !tagCompound.func_150297_b("remainingSprays", 3)) {
            tagCompound.func_74768_a("remainingSprays", 5);
        }
        return tagCompound;
    }

    @Override
    public boolean hasColor(ItemStack stack) {
        NBTTagCompound tagCompound = ItemSprayCan.createTagCompound(stack);
        return tagCompound.func_150297_b("color", 3);
    }

    @Override
    public int getColor(ItemStack stack) {
        NBTTagCompound tagCompound = ItemSprayCan.createTagCompound(stack);
        return tagCompound.func_74762_e("color");
    }

    @Override
    public void setColor(ItemStack stack, int color) {
        NBTTagCompound tagCompound = ItemSprayCan.createTagCompound(stack);
        tagCompound.func_74768_a("color", color);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        NBTTagCompound tagCompound = ItemSprayCan.createTagCompound(stack);
        int remainingSprays = tagCompound.func_74762_e("remainingSprays");
        return tagCompound.func_150297_b("color", 3) && remainingSprays >= 0 && remainingSprays < 5;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound tagCompound = ItemSprayCan.createTagCompound(stack);
        return 1.0 - (double)tagCompound.func_74762_e("remainingSprays") / 5.0;
    }

    public static float getRemainingSprays(ItemStack stack) {
        NBTTagCompound tagCompound = ItemSprayCan.createTagCompound(stack);
        return (float)tagCompound.func_74762_e("remainingSprays") / 5.0f;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this, 1, 0);
            ItemSprayCan.createTagCompound(stack);
            items.add((Object)stack);
        }
    }
}

