/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.item;

import com.mrcrayfish.vehicle.VehicleMod;
import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.item.ItemPart;
import com.mrcrayfish.vehicle.item.SubItems;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEngine
extends ItemPart
implements SubItems {
    private EngineType engineType;

    public ItemEngine(String id, EngineType engineType) {
        super(id);
        this.engineType = engineType;
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(VehicleMod.CREATIVE_TAB);
    }

    public EngineType getEngineType() {
        return this.engineType;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        EngineTier tier = EngineTier.getType(stack.func_77960_j());
        String tierName = I18n.func_135052_a((String)("vehicle.engine_tier." + tier.getTierName() + ".name"), (Object[])new Object[0]);
        tooltip.add(tier.getTierColor() + TextFormatting.BOLD.toString() + tierName);
        if (GuiScreen.func_146272_n()) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.engine_info.acceleration", (Object[])new Object[0]) + ": " + TextFormatting.RESET + tier.getAccelerationMultiplier() + "x");
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.engine_info.additional_max_speed", (Object[])new Object[0]) + ": " + TextFormatting.RESET + (double)tier.getAdditionalMaxSpeed() * 3.6 + "kph");
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.engine_info.fuel_consumption", (Object[])new Object[0]) + ": " + TextFormatting.RESET + tier.getFuelConsumption() + "pt");
        } else {
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.info_help", (Object[])new Object[0]));
        }
    }

    @Override
    public NonNullList<ResourceLocation> getModels() {
        NonNullList modelLocations = NonNullList.func_191196_a();
        for (EngineTier tier : EngineTier.values()) {
            modelLocations.add((Object)new ResourceLocation(this.getRegistryName() + "/" + tier.toString().toLowerCase(Locale.ENGLISH)));
        }
        return modelLocations;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (EngineTier tier : EngineTier.values()) {
                items.add((Object)new ItemStack((Item)this, 1, tier.ordinal()));
            }
        }
    }
}

