/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.common;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.mrcrayfish.vehicle.VehicleConfig;
import com.mrcrayfish.vehicle.common.entity.HeldVehicleDataHandler;
import com.mrcrayfish.vehicle.common.entity.SyncedPlayerData;
import com.mrcrayfish.vehicle.entity.EntityJack;
import com.mrcrayfish.vehicle.entity.EntityTrailer;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageThrowVehicle;
import com.mrcrayfish.vehicle.tileentity.TileEntityGasPump;
import com.mrcrayfish.vehicle.tileentity.TileEntityJack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;

public class CommonEvents {
    private static final List<String> IGNORE_ITEMS;
    private static final List<String> IGNORE_SOUNDS;
    private static final List<String> IGNORE_ENTITIES;

    @SubscribeEvent
    public void onMissingItem(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping missing : event.getMappings()) {
            if (!missing.key.func_110624_b().equals("vehicle") || !IGNORE_ITEMS.contains(missing.key.func_110623_a())) continue;
            missing.ignore();
        }
    }

    @SubscribeEvent
    public void onMissingSound(RegistryEvent.MissingMappings<SoundEvent> event) {
        for (RegistryEvent.MissingMappings.Mapping missing : event.getMappings()) {
            if (!missing.key.func_110624_b().equals("vehicle") || !IGNORE_SOUNDS.contains(missing.key.func_110623_a())) continue;
            missing.ignore();
        }
    }

    @SubscribeEvent
    public void onMissingEntity(RegistryEvent.MissingMappings<EntityEntry> event) {
        for (RegistryEvent.MissingMappings.Mapping missing : event.getMappings()) {
            if (!missing.key.func_110624_b().equals("vehicle") || !IGNORE_ENTITIES.contains(missing.key.func_110623_a())) continue;
            missing.ignore();
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        if (CommonEvents.pickUpVehicle(event.getWorld(), event.getEntityPlayer(), event.getHand(), event.getTarget())) {
            event.setCanceled(true);
        }
    }

    public static boolean pickUpVehicle(World world, EntityPlayer player, EnumHand hand, Entity targetEntity) {
        if (hand == EnumHand.MAIN_HAND && !world.field_72995_K && player.func_70093_af() && !player.func_175149_v() && VehicleConfig.SERVER.pickUpVehicles) {
            if (!HeldVehicleDataHandler.isHoldingVehicle(player)) {
                if (targetEntity instanceof EntityVehicle && !targetEntity.func_184207_aI() && !targetEntity.field_70128_L) {
                    NBTTagCompound tagCompound = new NBTTagCompound();
                    String id = CommonEvents.getEntityString(targetEntity);
                    if (id != null) {
                        ((EntityVehicle)targetEntity).setTrailer(null);
                        tagCompound.func_74778_a("id", id);
                        targetEntity.func_189511_e(tagCompound);
                        HeldVehicleDataHandler.setHeldVehicle(player, tagCompound);
                        world.func_72900_e(targetEntity);
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.PICK_UP_VEHICLE, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        return true;
                    }
                }
            } else if (targetEntity instanceof EntityTrailer && !targetEntity.func_184207_aI() && !targetEntity.field_70128_L) {
                NBTTagCompound tagCompound = HeldVehicleDataHandler.getHeldVehicle(player);
                if (tagCompound.func_82582_d()) {
                    return false;
                }
                Entity vehicle = EntityList.func_75615_a((NBTTagCompound)tagCompound, (World)world);
                if (vehicle instanceof EntityVehicle && ((EntityVehicle)vehicle).canMountTrailer()) {
                    vehicle.func_70080_a(targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v, targetEntity.field_70177_z, targetEntity.field_70125_A);
                    HeldVehicleDataHandler.setHeldVehicle(player, new NBTTagCompound());
                    world.func_72838_d(vehicle);
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187727_dV, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    vehicle.func_184220_m(targetEntity);
                    return true;
                }
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() == EnumHand.OFF_HAND) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        if (!world.field_72995_K) {
            if (event.getFace() == EnumFacing.UP && HeldVehicleDataHandler.isHoldingVehicle(player)) {
                BlockPos pos = event.getPos();
                TileEntity tileEntity = event.getWorld().func_175625_s(pos);
                if (tileEntity instanceof TileEntityJack) {
                    NBTTagCompound tagCompound;
                    Entity entity;
                    TileEntityJack jack = (TileEntityJack)tileEntity;
                    if (jack.getJack() == null && (entity = EntityList.func_75615_a((NBTTagCompound)(tagCompound = HeldVehicleDataHandler.getHeldVehicle(player)), (World)world)) instanceof EntityVehicle) {
                        HeldVehicleDataHandler.setHeldVehicle(player, new NBTTagCompound());
                        entity.field_70143_R = 0.0f;
                        entity.field_70177_z = (player.func_70079_am() + 90.0f) % 360.0f;
                        jack.setVehicle((EntityVehicle)entity);
                        if (jack.getJack() != null) {
                            EntityJack entityJack = jack.getJack();
                            entityJack.func_70098_U();
                            entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                        }
                        world.func_72838_d(entity);
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187727_dV, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                    event.setCanceled(true);
                    return;
                }
            }
            if (player.func_70093_af() && HeldVehicleDataHandler.isHoldingVehicle(player)) {
                MinecraftServer server;
                Vec3d clickedVec = event.getHitVec();
                if (clickedVec == null || event.getFace() != EnumFacing.UP) {
                    event.setCanceled(true);
                    return;
                }
                NBTTagCompound tagCompound = HeldVehicleDataHandler.getHeldVehicle(player);
                Entity entity = EntityList.func_75615_a((NBTTagCompound)tagCompound, (World)world);
                if (entity instanceof EntityVehicle && (server = world.func_73046_m()) != null && server.func_175576_a(entity.func_110124_au()) == null) {
                    server.func_152344_a(() -> {
                        HeldVehicleDataHandler.setHeldVehicle(player, new NBTTagCompound());
                        float rotation = (player.func_70079_am() + 90.0f) % 360.0f;
                        Vec3d heldOffset = ((EntityVehicle)entity).getProperties().getHeldOffset().func_178785_b((float)Math.toRadians(-player.func_70079_am()));
                        entity.func_70080_a(clickedVec.field_72450_a + heldOffset.field_72450_a * 0.0625, clickedVec.field_72448_b, clickedVec.field_72449_c + heldOffset.field_72449_c * 0.0625, rotation, 0.0f);
                        entity.field_70143_R = 0.0f;
                        world.func_72838_d(entity);
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187727_dV, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    });
                    event.setCanceled(true);
                }
            }
        } else if (HeldVehicleDataHandler.isHoldingVehicle(player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        EntityPlayer player;
        if (event.getHand() == EnumHand.OFF_HAND) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K && (event instanceof PlayerInteractEvent.RightClickEmpty || event instanceof PlayerInteractEvent.RightClickItem) && HeldVehicleDataHandler.isHoldingVehicle(player = event.getEntityPlayer())) {
            if (player.func_70093_af()) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageThrowVehicle());
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    @Nullable
    private static String getEntityString(Entity entity) {
        ResourceLocation resourcelocation = EntityList.func_191301_a((Entity)entity);
        return resourcelocation == null ? null : resourcelocation.toString();
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            this.dropVehicle(player);
        }
    }

    private void dropVehicle(EntityPlayer player) {
        if (HeldVehicleDataHandler.isHoldingVehicle(player)) {
            NBTTagCompound vehicleTag = HeldVehicleDataHandler.getHeldVehicle(player);
            HeldVehicleDataHandler.setHeldVehicle(player, new NBTTagCompound());
            Entity vehicle = EntityList.func_75615_a((NBTTagCompound)vehicleTag, (World)player.field_70170_p);
            if (vehicle instanceof EntityVehicle) {
                float rotation = (player.func_70079_am() + 90.0f) % 360.0f;
                Vec3d heldOffset = ((EntityVehicle)vehicle).getProperties().getHeldOffset().func_178785_b((float)Math.toRadians(-player.func_70079_am()));
                vehicle.func_70080_a(player.field_70165_t + heldOffset.field_72450_a * 0.0625, player.field_70163_u + (double)player.func_70047_e() + heldOffset.field_72448_b * 0.0625, player.field_70161_v + heldOffset.field_72449_c * 0.0625, rotation, 0.0f);
                player.field_70170_p.func_72838_d(vehicle);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TileEntity tileEntity;
            Optional<BlockPos> pos;
            int trailerId;
            EntityPlayer player = event.player;
            World world = player.field_70170_p;
            if (!world.field_72995_K && player.func_70093_af() && (trailerId = SyncedPlayerData.getTrailer(player)) != -1) {
                Entity entity = world.func_73045_a(trailerId);
                if (entity instanceof EntityTrailer) {
                    ((EntityTrailer)entity).setPullingEntity(null);
                }
                SyncedPlayerData.setTrailer(player, -1);
            }
            if (!world.field_72995_K && player.func_175149_v()) {
                this.dropVehicle(player);
            }
            if ((pos = SyncedPlayerData.getGasPumpPos(player)).isPresent() && !((tileEntity = world.func_175625_s((BlockPos)pos.get())) instanceof TileEntityGasPump)) {
                SyncedPlayerData.setGasPumpPos(player, (Optional<BlockPos>)Optional.absent());
            }
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickItem event) {
        if (SyncedPlayerData.getGasPumpPos(event.getEntityPlayer()).isPresent()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        if (state.func_177230_c() != ModBlocks.GAS_PUMP && SyncedPlayerData.getGasPumpPos(event.getEntityPlayer()).isPresent()) {
            event.setCanceled(true);
        }
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)"body");
        builder.add((Object)"atv");
        builder.add((Object)"go_kart");
        IGNORE_ITEMS = builder.build();
        builder = ImmutableList.builder();
        builder.add((Object)"idle");
        builder.add((Object)"driving");
        IGNORE_SOUNDS = builder.build();
        builder = ImmutableList.builder();
        builder.add((Object)"vehicle_atv");
        builder.add((Object)"couch");
        builder.add((Object)"bath");
        IGNORE_ENTITIES = builder.build();
    }
}

