/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.block;

import com.mrcrayfish.vehicle.block.BlockFluidPipe;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.tileentity.TileEntityFluidPipe;
import com.mrcrayfish.vehicle.tileentity.TileEntityFluidPump;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLever;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class BlockFluidPump
extends BlockFluidPipe {
    private final AxisAlignedBB[][] boxesHousing = new AxisAlignedBB[][]{{new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.1875, 0.8125), new AxisAlignedBB(0.28125, 0.1875, 0.28125, 0.71875, 0.25, 0.71875)}, {new AxisAlignedBB(0.1875, 1.0, 0.1875, 0.8125, 0.8125, 0.8125), new AxisAlignedBB(0.28125, 0.8125, 0.28125, 0.71875, 0.75, 0.71875)}, {new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 0.1875), new AxisAlignedBB(0.28125, 0.28125, 0.1875, 0.71875, 0.71875, 0.25)}, {new AxisAlignedBB(0.1875, 0.1875, 1.0, 0.8125, 0.8125, 0.8125), new AxisAlignedBB(0.28125, 0.28125, 0.8125, 0.71875, 0.71875, 0.75)}, {new AxisAlignedBB(0.0, 0.1875, 0.1875, 0.1875, 0.8125, 0.8125), new AxisAlignedBB(0.1875, 0.28125, 0.28125, 0.25, 0.71875, 0.71875)}, {new AxisAlignedBB(1.0, 0.1875, 0.1875, 0.8125, 0.8125, 0.8125), new AxisAlignedBB(0.8125, 0.28125, 0.28125, 0.75, 0.71875, 0.71875)}};

    public BlockFluidPump() {
        super("vehicle:fluid_pump");
        this.func_149711_c(0.5f);
    }

    @Override
    protected EnumFacing getCollisionFacing(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d();
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, isActualState);
        for (AxisAlignedBB box : this.boxesHousing[this.getCollisionFacing(isActualState ? state : state.func_185899_b((IBlockAccess)world, pos)).func_176745_a()]) {
            BlockFluidPump.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        double minX = 0.3125;
        double minY = 0.1875;
        double minZ = 0.3125;
        double maxX = 0.6875;
        double maxY = 0.8125;
        double maxZ = 0.6875;
        state = this.func_176221_a(state, source, pos);
        EnumFacing originalFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (originalFacing) {
            case DOWN: {
                minY = 0.3125;
                maxY = 1.0;
                break;
            }
            case UP: {
                minY = 0.0;
                maxY = 0.6875;
                break;
            }
            case NORTH: {
                maxZ = 1.0;
                break;
            }
            case SOUTH: {
                minZ = 0.0;
                break;
            }
            case WEST: {
                maxX = 1.0;
                break;
            }
            case EAST: {
                minX = 0.0;
            }
        }
        switch (originalFacing.func_176740_k()) {
            case Y: {
                maxZ = 0.8125;
                maxX = 0.8125;
                minZ = 0.1875;
                minX = 0.1875;
                break;
            }
            case Z: {
                minX = 0.1875;
                maxX = 0.8125;
                break;
            }
            case X: {
                minZ = 0.1875;
                maxZ = 0.8125;
            }
        }
        boolean[] disabledConnections = TileEntityFluidPipe.getDisabledConnections(BlockFluidPump.getTileEntity(source, pos));
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[EnumFacing.NORTH.func_176745_a()])).booleanValue() && !disabledConnections[EnumFacing.NORTH.func_176745_a()]) {
            minZ = 0.0;
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[EnumFacing.EAST.func_176745_a()])).booleanValue() && !disabledConnections[EnumFacing.EAST.func_176745_a()]) {
            maxX = 1.0;
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[EnumFacing.SOUTH.func_176745_a()])).booleanValue() && !disabledConnections[EnumFacing.SOUTH.func_176745_a()]) {
            maxZ = 1.0;
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[EnumFacing.WEST.func_176745_a()])).booleanValue() && !disabledConnections[EnumFacing.WEST.func_176745_a()]) {
            minX = 0.0;
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[EnumFacing.DOWN.func_176745_a()])).booleanValue() && !disabledConnections[EnumFacing.DOWN.func_176745_a()]) {
            minY = 0.0;
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[EnumFacing.UP.func_176745_a()])).booleanValue() && !disabledConnections[EnumFacing.UP.func_176745_a()]) {
            maxY = 1.0;
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ)) {
            return true;
        }
        TileEntityFluidPipe pipe = BlockFluidPump.getTileEntity((IBlockAccess)world, pos);
        AxisAlignedBB housingBox = this.getHousingBox(world, pos, state, player, hand, hitX, hitY, hitZ, pipe);
        if (pipe != null && housingBox != null) {
            if (!world.field_72995_K) {
                ((TileEntityFluidPump)pipe).cyclePowerMode(player);
                world.func_175684_a(pos, state.func_177230_c(), 0);
                world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 1.0f, 0.5f);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public AxisAlignedBB getHousingBox(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, double hitX, double hitY, double hitZ, @Nullable TileEntityFluidPipe pipe) {
        AxisAlignedBB[] boxesHousing;
        if (!(pipe instanceof TileEntityFluidPump) || player.func_184586_b(hand).func_77973_b() != ModItems.WRENCH) {
            return null;
        }
        state = state.func_185899_b((IBlockAccess)world, pos);
        Vec3d hit = new Vec3d(hitX, hitY, hitZ);
        for (AxisAlignedBB box : boxesHousing = this.boxesHousing[this.getCollisionFacing(state).func_176745_a()]) {
            if (!box.func_186662_g(0.001).func_72318_a(hit)) continue;
            for (AxisAlignedBB box2 : boxesHousing) {
                box = box.func_111270_a(box2);
            }
            return box.func_186670_a(pos);
        }
        return null;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing originalFacing = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d();
        TileEntityFluidPipe pipe = BlockFluidPump.getTileEntity(world, pos);
        boolean[] disabledConnections = TileEntityFluidPipe.getDisabledConnections(pipe);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            boolean enabled;
            if (facing == originalFacing) continue;
            BlockPos adjacentPos = pos.func_177972_a(facing);
            IBlockState adjacentState = world.func_180495_p(adjacentPos);
            boolean bl = enabled = !disabledConnections[facing.func_176745_a()];
            if (adjacentState.func_177230_c() == ModBlocks.FLUID_PIPE) {
                state = state.func_177226_a((IProperty)CONNECTED_PIPES[facing.func_176745_a()], (Comparable)Boolean.valueOf(enabled));
                continue;
            }
            if (adjacentState.func_177230_c() == Blocks.field_150442_at) {
                EnumFacing leverFacing = ((BlockLever.EnumOrientation)adjacentState.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c().func_176734_d();
                if (!adjacentPos.func_177972_a(leverFacing).equals((Object)pos)) continue;
                state = state.func_177226_a((IProperty)CONNECTED_PIPES[facing.func_176745_a()], (Comparable)Boolean.valueOf(true));
                if (pipe == null) continue;
                pipe.setConnectionDisabled(facing, false);
                continue;
            }
            if (adjacentState.func_177230_c() == this) continue;
            TileEntity tileEntity = world.func_175625_s(adjacentPos);
            state = state.func_177226_a((IProperty)CONNECTED_PIPES[facing.func_176745_a()], (Comparable)Boolean.valueOf(enabled && tileEntity != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())));
        }
        return state;
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        return state.func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityFluidPump();
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }
}

