/*
 * Decompiled with CFR 0.152.
 */
package lumien.perfectspawn.handler;

import com.google.common.base.Predicate;
import java.util.List;
import lumien.perfectspawn.PerfectSpawn;
import lumien.perfectspawn.config.PSConfig;
import lumien.perfectspawn.config.internal.Bool;
import lumien.perfectspawn.handler.ReflectionHandler;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PSEventHandler {
    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
    }

    @SubscribeEvent
    public void sleepInBed(PlayerSleepInBedEvent event) {
        PSConfig config = PerfectSpawn.INSTANCE.getConfigHandler().getActiveConfig();
        if (config != null) {
            Bool value = config.canSleepHere(event.getEntity().field_70170_p.field_73011_w);
            if (value == Bool.TRUE) {
                event.setResult(this.forceBed(event));
            } else if (value == Bool.FALSE) {
                event.setResult(EntityPlayer.SleepResult.NOT_POSSIBLE_HERE);
            }
        }
    }

    private EntityPlayer.SleepResult forceBed(PlayerSleepInBedEvent event) {
        EnumFacing enumfacing;
        final EntityPlayer player = event.getEntityPlayer();
        IBlockState state = player.field_70170_p.func_175667_e(event.getPos()) ? player.field_70170_p.func_180495_p(event.getPos()) : null;
        boolean isBed = state != null && state.func_177230_c().isBed(state, (IBlockAccess)player.field_70170_p, event.getPos(), (Entity)player);
        EnumFacing enumFacing = enumfacing = isBed && state.func_177230_c() instanceof BlockHorizontal ? (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) : null;
        if (!player.field_70170_p.field_72995_K) {
            if (player.func_70608_bn() || !player.func_70089_S()) {
                return EntityPlayer.SleepResult.OTHER_PROBLEM;
            }
            if (player.field_70170_p.field_73011_w.func_76569_d() && player.field_70170_p.func_72935_r()) {
                return EntityPlayer.SleepResult.NOT_POSSIBLE_NOW;
            }
            if (!PSEventHandler.bedInRange(player, event.getPos(), enumfacing)) {
                return EntityPlayer.SleepResult.TOO_FAR_AWAY;
            }
            double d0 = 8.0;
            double d1 = 5.0;
            List list = player.field_70170_p.func_175647_a(EntityMob.class, new AxisAlignedBB((double)event.getPos().func_177958_n() - 8.0, (double)event.getPos().func_177956_o() - 5.0, (double)event.getPos().func_177952_p() - 8.0, (double)event.getPos().func_177958_n() + 8.0, (double)event.getPos().func_177956_o() + 5.0, (double)event.getPos().func_177952_p() + 8.0), (Predicate)new Predicate<EntityMob>(){

                public boolean apply(EntityMob input) {
                    return input.func_191990_c(player);
                }
            });
            if (!list.isEmpty()) {
                return EntityPlayer.SleepResult.NOT_SAFE;
            }
        }
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        ReflectionHandler.spawnShoulderEntities(player);
        ReflectionHandler.setSize((Entity)player, 0.2f, 0.2f);
        if (enumfacing != null) {
            float f1 = 0.5f + (float)enumfacing.func_82601_c() * 0.4f;
            float f = 0.5f + (float)enumfacing.func_82599_e() * 0.4f;
            ReflectionHandler.setRenderOffsetForSleep(player, enumfacing);
            player.func_70107_b((double)((float)event.getPos().func_177958_n() + f1), (double)((float)event.getPos().func_177956_o() + 0.6875f), (double)((float)event.getPos().func_177952_p() + f));
        } else {
            player.func_70107_b((double)((float)event.getPos().func_177958_n() + 0.5f), (double)((float)event.getPos().func_177956_o() + 0.6875f), (double)((float)event.getPos().func_177952_p() + 0.5f));
        }
        ReflectionHandler.setSleeping(player, true);
        ReflectionHandler.setSleepTimer(player, 0);
        player.field_71081_bT = event.getPos();
        player.field_70159_w = 0.0;
        player.field_70181_x = 0.0;
        player.field_70179_y = 0.0;
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72854_c();
        }
        return EntityPlayer.SleepResult.OK;
    }

    private EntityPlayer getPlayerInBed(World worldIn, BlockPos pos) {
        for (EntityPlayer entityplayer : worldIn.field_73010_i) {
            if (!entityplayer.func_70608_bn() || !entityplayer.field_71081_bT.equals((Object)pos)) continue;
            return entityplayer;
        }
        return null;
    }

    private static boolean bedInRange(EntityPlayer player, BlockPos bedPos, EnumFacing bedFacing) {
        if (Math.abs(player.field_70165_t - (double)bedPos.func_177958_n()) <= 3.0 && Math.abs(player.field_70163_u - (double)bedPos.func_177956_o()) <= 2.0 && Math.abs(player.field_70161_v - (double)bedPos.func_177952_p()) <= 3.0) {
            return true;
        }
        if (bedFacing == null) {
            return false;
        }
        BlockPos blockpos = bedPos.func_177972_a(bedFacing.func_176734_d());
        return Math.abs(player.field_70165_t - (double)blockpos.func_177958_n()) <= 3.0 && Math.abs(player.field_70163_u - (double)blockpos.func_177956_o()) <= 2.0 && Math.abs(player.field_70161_v - (double)blockpos.func_177952_p()) <= 3.0;
    }
}

