/*
 * Decompiled with CFR 0.152.
 */
package lumien.perfectspawn.handler;

import lumien.perfectspawn.PerfectSpawn;
import lumien.perfectspawn.config.PSConfig;
import lumien.perfectspawn.config.internal.Bool;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;

public class AsmHandler {
    public static int overrideInitialDimension(int original) {
        PSConfig config = PerfectSpawn.INSTANCE.getConfigHandler().getActiveConfig();
        if (config != null) {
            return config.getInitialSpawnDimension();
        }
        return 0;
    }

    public static boolean overrideCanRespawn(WorldProvider provider, boolean original) {
        Bool value;
        PSConfig config = PerfectSpawn.INSTANCE.getConfigHandler().getActiveConfig();
        if (config != null && (value = config.canRespawnHere(provider)) != Bool.NOTSET) {
            return value == Bool.TRUE;
        }
        return original;
    }

    public static int overrideGetRespawnDimension(WorldProvider provider, int original) {
        Integer value;
        PSConfig config = PerfectSpawn.INSTANCE.getConfigHandler().getActiveConfig();
        if (config != null && (value = config.getRespawnDimension(provider)) != null) {
            return value;
        }
        return original;
    }

    public static BlockPos overrideGetSpawnPoint(WorldProvider provider, BlockPos original) {
        BlockPos value;
        PSConfig config = PerfectSpawn.INSTANCE.getConfigHandler().getActiveConfig();
        if (config != null && (value = config.getSpawnPoint(provider)) != null) {
            return value;
        }
        return original;
    }

    public static BlockPos overrideGetRandomizedSpawnPoint(WorldProvider provider, BlockPos original) {
        return provider.getSpawnPoint();
    }

    public static int overrideDefaultPlayerSpawnDimension(EntityPlayer player, int original) {
        PSConfig config = PerfectSpawn.INSTANCE.getConfigHandler().getActiveConfig();
        if (config != null) {
            return config.getInitialSpawnDimension();
        }
        return original;
    }

    public static Biome changeHellComparison(World world) {
        Bool value;
        PSConfig config = PerfectSpawn.INSTANCE.getConfigHandler().getActiveConfig();
        if (config != null && (value = config.canSleepHere(world.field_73011_w)) == Bool.TRUE) {
            return null;
        }
        return Biomes.field_76778_j;
    }

    public static boolean unloadWorld(int dimension) {
        PSConfig config = PerfectSpawn.INSTANCE.getConfigHandler().getActiveConfig();
        if (config != null) {
            return config.canUnload(dimension);
        }
        return true;
    }

    public static boolean keepInBedFix(EntityPlayer player, boolean isDayTime) {
        Bool value;
        PSConfig config = PerfectSpawn.INSTANCE.getConfigHandler().getActiveConfig();
        if (config != null && (value = config.canSleepHere(player.field_70170_p.field_73011_w)) == Bool.TRUE) {
            return isDayTime && player.field_70170_p.field_73011_w.func_76569_d();
        }
        return isDayTime;
    }
}

