/*
 * Decompiled with CFR 0.152.
 */
package lumien.perfectspawn.config;

import lumien.perfectspawn.config.internal.Bool;
import lumien.perfectspawn.config.internal.Rule;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldProvider;

public class PSConfig {
    Rule[] rules = new Rule[0];
    int initialSpawnDimension = 0;

    public void setRules(Rule[] rules) {
        this.rules = rules;
    }

    public void setInitialSpawnDimension(int initialSpawnDimension) {
        this.initialSpawnDimension = initialSpawnDimension;
    }

    public Bool canRespawnHere(WorldProvider provider) {
        Bool result = Bool.NOTSET;
        for (Rule r : this.rules) {
            Bool ruleValue;
            if (!r.appliesTo(provider) || (ruleValue = r.getCanRespawnHere()) == Bool.NOTSET) continue;
            result = ruleValue;
        }
        return result;
    }

    public Bool canSleepHere(WorldProvider provider) {
        Bool result = Bool.NOTSET;
        for (Rule r : this.rules) {
            Bool ruleValue;
            if (!r.appliesTo(provider) || (ruleValue = r.getForceBed()) == Bool.NOTSET) continue;
            result = ruleValue;
        }
        return result;
    }

    public Integer getRespawnDimension(WorldProvider provider) {
        Integer result = null;
        for (Rule r : this.rules) {
            Integer ruleValue;
            if (!r.appliesTo(provider) || (ruleValue = r.getRespawnDimension()) == null) continue;
            result = ruleValue;
        }
        return result;
    }

    public BlockPos getSpawnPoint(WorldProvider provider) {
        BlockPos result = null;
        for (Rule r : this.rules) {
            BlockPos ruleValue;
            if (!r.appliesTo(provider) || (ruleValue = r.getSpawnPoint()) == null) continue;
            result = ruleValue;
        }
        return result;
    }

    public int getInitialSpawnDimension() {
        return this.initialSpawnDimension;
    }

    public boolean canUnload(int dimension) {
        if (dimension == this.initialSpawnDimension) {
            return false;
        }
        for (Rule r : this.rules) {
            Integer respawn = r.getRespawnDimension();
            if (respawn == null || respawn != dimension) continue;
            return false;
        }
        return true;
    }
}

