/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.items;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import wile.engineerstools.items.ItemTools;

public class ItemSleepingBag
extends ItemTools {
    public ItemSleepingBag(String registryName) {
        super(registryName);
        this.func_77625_d(1);
        this.func_77656_e(4096);
        this.setNoRepair();
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        this.onUse(player, world, pos, facing);
        return EnumActionResult.SUCCESS;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    private void onUse(EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        if (world.field_72995_K || side != EnumFacing.UP) {
            return;
        }
        BlockPos bed_pos = player.field_71081_bT;
        switch (world.field_73011_w.canSleepAt(player, pos.func_177984_a())) {
            case ALLOW: {
                break;
            }
            default: {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.noSleep", new Object[0]), true);
                return;
            }
        }
        EntityPlayer.SleepResult sr = player.func_180469_a(pos.func_177984_a());
        switch (sr) {
            case OK: 
            case TOO_FAR_AWAY: {
                break;
            }
            case NOT_SAFE: {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]), true);
                break;
            }
            default: {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.noSleep", new Object[0]), true);
            }
        }
    }

    public static void onBedCheck(SleepingLocationCheckEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        if (event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemSleepingBag) {
            event.setResult(Event.Result.ALLOW);
        }
    }
}

