/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.items;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import wile.engineerstools.ModEngineersTools;
import wile.engineerstools.detail.BlockCategories;
import wile.engineerstools.detail.ModAuxiliaries;
import wile.engineerstools.detail.TreeCutting;

public class ItemRediaTool
extends ItemAxe {
    private static int enchantability = 15;
    private static int max_damage_ = 2200;
    private static boolean with_torch_placing = true;
    private static boolean with_hoeing = true;
    private static boolean with_tree_felling = true;
    private static boolean with_shearing = true;
    private static double[] efficiency_decay = new double[]{0.1, 0.8, 0.9, 1.0, 1.0, 1.3, 1.6, 1.8, 2.0, 2.0};
    private static int[] fortune_decay = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 2, 3};
    private static final int max_block_tracking_hitcount = 5;
    private static final int max_attack_cooldown_ms = 2500;
    private World a_world = null;

    public static void on_config(boolean without_redia_torchplacing, boolean without_redia_hoeing, boolean without_redia_tree_chopping, int durability, String efficiency_curve, String fortune_curve) {
        int i;
        ArrayList<Number> dc;
        with_torch_placing = !without_redia_torchplacing;
        with_hoeing = !without_redia_hoeing;
        with_tree_felling = !without_redia_tree_chopping;
        max_damage_ = MathHelper.func_76125_a((int)durability, (int)800, (int)3000);
        ModEngineersTools.logger.info("REDIA tool config: " + (with_torch_placing ? "" : "no-") + "torch-placing, " + (with_hoeing ? "" : "no-") + "hoeing, " + (with_tree_felling ? "" : "no-") + "tree-felling.");
        String[] sc = efficiency_curve.replaceAll("^[,0-9]", "").split(",");
        if (sc.length > 0) {
            dc = new ArrayList<Number>();
            for (i = 0; i < sc.length && i < efficiency_decay.length; ++i) {
                dc.add(MathHelper.func_151237_a((double)Double.parseDouble(sc[i]), (double)20.0, (double)250.0));
            }
            for (i = 1; i < dc.size(); ++i) {
                if (!((Double)dc.get(i) < (Double)dc.get(i - 1))) continue;
                dc.set(i, (Number)dc.get(i - 1));
            }
            while (dc.size() < efficiency_decay.length) {
                dc.add((Number)dc.get(dc.size() - 1));
            }
            for (i = 0; i < dc.size(); ++i) {
                ItemRediaTool.efficiency_decay[i] = (Double)dc.get(i) / 100.0;
            }
        }
        StringBuilder confout = new StringBuilder();
        confout.append("REDIA tool efficiency curve: [");
        for (i = 0; i < efficiency_decay.length; ++i) {
            confout.append(Math.round(efficiency_decay[i] * 100.0)).append(",");
        }
        confout.deleteCharAt(confout.length() - 1).append("]");
        ModEngineersTools.logger.info(confout.toString());
        sc = efficiency_curve.replaceAll("^[,0-9]", "").split(",");
        if (sc.length > 0) {
            dc = new ArrayList();
            for (i = 0; i < sc.length && i < fortune_decay.length; ++i) {
                dc.add(MathHelper.func_76125_a((int)Integer.parseInt(sc[i]), (int)0, (int)3));
            }
            for (i = 1; i < dc.size(); ++i) {
                if ((Integer)dc.get(i) >= (Integer)dc.get(i - 1)) continue;
                dc.set(i, (Number)dc.get(i - 1));
            }
            while (dc.size() < fortune_decay.length) {
                dc.add((Number)dc.get(dc.size() - 1));
            }
        }
        confout = new StringBuilder();
        confout.append("REDIA tool fortune curve: [");
        for (i = 0; i < fortune_decay.length; ++i) {
            confout.append(Math.round(fortune_decay[i])).append(",");
        }
        confout.deleteCharAt(confout.length() - 1).append("]");
        ModEngineersTools.logger.info(confout.toString());
    }

    public ItemRediaTool(String registryName) {
        super(Item.ToolMaterial.DIAMOND);
        this.setRegistryName("engineerstools", registryName);
        this.func_77655_b("engineerstools." + registryName);
        this.func_77637_a(ModEngineersTools.CREATIVE_TAB_ENGINEERSTOOLS);
        this.func_77625_d(1);
        this.func_77627_a(false);
        this.setHarvestLevel("pickaxe", 3);
        this.setHarvestLevel("axe", 3);
        this.setHarvestLevel("shovel", 3);
        this.func_77656_e(max_damage_);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        ModAuxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public int func_77619_b() {
        return enchantability;
    }

    public String func_77861_e() {
        return this.field_77862_b.toString();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.field_77862_b.getRepairItemStack();
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState state) {
        return 3;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"axe", (Object)"pickaxe", (Object)"shovel");
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean func_150897_b(IBlockState block) {
        return true;
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return 0;
    }

    public float getSmeltingExperience(ItemStack item) {
        return 0.0f;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, EntityLivingBase entity, EntityLivingBase attacker) {
        return true;
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return false;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot slot) {
        Multimap multimap = super.func_111205_h(slot);
        if (slot != EntityEquipmentSlot.MAINHAND) {
            return multimap;
        }
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.field_77865_bY, 0));
        multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.field_185065_c, 0));
        return multimap;
    }

    public boolean isBookEnchantable(ItemStack tool, ItemStack book) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack tool, Enchantment enchantment) {
        if (enchantment == Enchantments.field_185308_t) {
            return false;
        }
        if (enchantment == Enchantments.field_185305_q) {
            return false;
        }
        if (enchantment == Enchantments.field_180313_o) {
            return true;
        }
        if (enchantment == Enchantments.field_185304_p) {
            return true;
        }
        if (enchantment == Enchantments.field_185302_k) {
            return true;
        }
        if (enchantment == Enchantments.field_77334_n) {
            return true;
        }
        return enchantment.field_77351_y.func_77557_a(tool.func_77973_b());
    }

    public boolean func_77644_a(ItemStack tool, EntityLivingBase target, EntityLivingBase attacker) {
        tool.func_77972_a(2, attacker);
        return true;
    }

    public boolean onLeftClickEntity(ItemStack tool, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityVillager) {
            return true;
        }
        if (entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n() && ((EntityTameable)entity).func_70902_q() == player) {
            return true;
        }
        if (entity instanceof EntityPigZombie && ((EntityPigZombie)entity).func_70638_az() == null) {
            return true;
        }
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.isAttackingEnabled(tool)) {
            return false;
        }
        if (entity instanceof EntityCreature) {
            return ((EntityCreature)entity).func_70638_az() == null;
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && this.tryPlantSnipping(player, world, pos, hand, facing, hitX, hitY, hitZ)) {
            return EnumActionResult.SUCCESS;
        }
        if (player.func_70093_af() && facing == EnumFacing.UP && this.tryDigOver(player, world, pos, hand, facing, hitX, hitY, hitZ)) {
            return EnumActionResult.SUCCESS;
        }
        if ((!player.func_70093_af() || facing.func_176740_k().func_176722_c()) && this.tryTorchPlacing(player, world, pos, hand, facing, hitX, hitY, hitZ)) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean onBlockStartBreak(ItemStack tool, BlockPos pos, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            this.setFortune(tool);
        }
        return false;
    }

    public boolean func_179218_a(ItemStack tool, World world, IBlockState state, BlockPos pos, EntityLivingBase player) {
        this.a_world = world;
        this.resetFortune(tool);
        if (world.field_72995_K) {
            return true;
        }
        this.blockAttacking(tool);
        if (state.func_185887_b(world, pos) != 0.0f) {
            tool.func_77972_a(1, player);
        }
        if (with_tree_felling && player instanceof EntityPlayer && player.func_70093_af() && this.tryTreeFelling(world, state, pos, player)) {
            return true;
        }
        return true;
    }

    public float func_150893_a(ItemStack tool, IBlockState state) {
        float hardness = 0.9f;
        if (this.a_world != null) {
            try {
                hardness = MathHelper.func_76131_a((float)state.func_185887_b(this.a_world, BlockPos.field_177992_a), (float)0.0f, (float)2.0f);
            }
            catch (Throwable e) {
                this.a_world = null;
            }
        }
        if (hardness >= 1.0f) {
            return (float)((double)this.field_77864_a * efficiency_decay[(int)MathHelper.func_151237_a((double)(this.relativeDurability(tool) * (double)efficiency_decay.length), (double)0.0, (double)(efficiency_decay.length - 1))]);
        }
        return this.field_77864_a;
    }

    public boolean func_111207_a(ItemStack tool, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        this.setFortune(player.func_184586_b(hand));
        boolean handled = this.tryEntityShearing(tool, player, entity, hand);
        this.resetFortune(player.func_184586_b(hand));
        return handled;
    }

    private boolean isAttackingEnabled(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("atdisat")) {
            return true;
        }
        if (Math.abs(System.currentTimeMillis() - nbt.func_74763_f("atdisat")) < 2500L) {
            return false;
        }
        nbt.func_82580_o("atdisat");
        stack.func_77982_d(nbt);
        return true;
    }

    private void blockAttacking(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74772_a("atdisat", System.currentTimeMillis());
        stack.func_77982_d(nbt);
    }

    private void setFortune(ItemStack stack) {
        int fortune = this.durabilityDependentFortune(stack);
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (fortune > 0) {
            enchantments.put(Enchantments.field_185308_t, fortune);
        } else if (enchantments.containsKey(Enchantments.field_185308_t)) {
            enchantments.remove(Enchantments.field_185308_t);
        }
        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
    }

    private void resetFortune(ItemStack stack) {
        int fortune = this.durabilityDependentFortune(stack);
        if (fortune == 0) {
            return;
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        enchantments.remove(Enchantments.field_185308_t);
        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
    }

    private double relativeDurability(ItemStack stack) {
        return MathHelper.func_151237_a((double)((double)(this.getMaxDamage(stack) - this.getDamage(stack)) / (double)this.getMaxDamage(stack)), (double)0.0, (double)1.0);
    }

    private int durabilityDependentFortune(ItemStack stack) {
        return fortune_decay[MathHelper.func_76125_a((int)((int)(this.relativeDurability(stack) * (double)fortune_decay.length)), (int)0, (int)(fortune_decay.length - 1))];
    }

    private boolean tryEntityShearing(ItemStack tool, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (!(entity instanceof IShearable)) {
            return false;
        }
        IShearable target = (IShearable)entity;
        BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (!target.isShearable(tool, (IBlockAccess)entity.field_70170_p, pos)) {
            return false;
        }
        List drops = target.onSheared(tool, (IBlockAccess)entity.field_70170_p, pos, this.durabilityDependentFortune(tool));
        Random rand = new Random();
        for (ItemStack stack : drops) {
            EntityItem e = entity.func_70099_a(stack, 1.0f);
            e.field_70181_x += (double)(rand.nextFloat() * 0.05f);
            e.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
            e.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
        }
        tool.func_77972_a(1, entity);
        return true;
    }

    private boolean tryPlantSnipping(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack tool;
        if (!with_shearing) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IShearable && ((IShearable)state.func_177230_c()).isShearable(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, pos) && (tool = player.func_184586_b(hand)).func_77973_b() == this) {
            world.func_184133_a(player, pos, SoundEvents.field_187784_dt, SoundCategory.BLOCKS, 0.8f, 1.1f);
            List stacks = ((IShearable)state.func_177230_c()).onSheared(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, pos, this.durabilityDependentFortune(tool));
            if (!world.field_72995_K) {
                for (ItemStack stack : stacks) {
                    EntityItem ie = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                    ie.func_174869_p();
                    world.func_72838_d((Entity)ie);
                }
            }
            state.func_177230_c().func_176208_a(world, pos, state, player);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
            tool.func_77972_a(1, (EntityLivingBase)player);
            return true;
        }
        return false;
    }

    private boolean tryTorchPlacing(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!with_torch_placing) {
            return false;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150478_aa)) continue;
            ItemStack tool = player.func_184586_b(hand);
            player.func_184611_a(hand, stack);
            EnumActionResult r = stack.func_77973_b().func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
            player.func_184611_a(hand, tool);
            return r != EnumActionResult.PASS;
        }
        return false;
    }

    private boolean tryDigOver(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state;
        if (!with_hoeing) {
            return false;
        }
        if (world.func_175625_s(pos) != null) {
            return false;
        }
        IBlockState replaced = state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockGrass || block == Blocks.field_150346_d && state.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.COARSE_DIRT) {
            replaced = Blocks.field_150458_ak.func_176223_P();
        } else if (block instanceof BlockFarmland) {
            replaced = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT);
        } else if (block == Blocks.field_150346_d && block.func_176201_c(state) == 1) {
            replaced = Blocks.field_185774_da.func_176223_P();
        } else if (block instanceof BlockGrassPath) {
            replaced = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT);
        }
        if (replaced != state) {
            world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 0.8f, 1.1f);
            if (!world.field_72995_K) {
                world.func_180501_a(pos, replaced, 3);
                ItemStack stack = player.func_184586_b(hand);
                if (stack.func_77973_b() == this) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
            }
            return true;
        }
        return false;
    }

    private boolean tryTreeFelling(World world, IBlockState state, BlockPos pos, EntityLivingBase player) {
        if (!state.func_185913_b() || state.func_185904_a() != Material.field_151575_d) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        if (BlockCategories.isLog(state)) {
            ItemStack tool = player.func_184614_ca();
            if (tool.func_77973_b() != this) {
                tool = player.func_184592_cb();
            }
            if (tool.func_77973_b() != this) {
                return false;
            }
            int max_broken_blocks = (tool.func_77958_k() - tool.func_77952_i()) * 2 / 3;
            int dmg = TreeCutting.chopTree(world, state, pos, player, max_broken_blocks);
            tool.func_77972_a(dmg, player);
            if (player instanceof EntityPlayer) {
                float exhaustion = MathHelper.func_76131_a((float)((float)dmg / 8.0f), (float)0.5f, (float)20.0f);
                ((EntityPlayer)player).func_71020_j(exhaustion);
            }
            return true;
        }
        return false;
    }
}

