/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.items;

import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import wile.engineerstools.ModContent;
import wile.engineerstools.ModEngineersTools;
import wile.engineerstools.items.ItemTools;

public class ItemCrushingHammer
extends ItemTools {
    private static String grit_preference_order = "immersiveengineering";
    private static int hammer_wear_off = 2;
    private static int num_output_stacks = 2;

    public static void on_config(String grit_preference, int hammer_durability_loss, int output_count) {
        num_output_stacks = MathHelper.func_76125_a((int)output_count, (int)2, (int)3);
        hammer_wear_off = MathHelper.func_76125_a((int)hammer_durability_loss, (int)(num_output_stacks > 2 ? 3 : 1), (int)32);
        grit_preference_order = grit_preference.toLowerCase().replaceAll(";;", ";").replaceFirst("^;+", "").replaceAll(";+$", "").trim();
        if (grit_preference_order.isEmpty()) {
            grit_preference_order = "immersiveengineering";
        }
    }

    public ItemCrushingHammer(String registryName) {
        super(registryName);
        this.func_77625_d(1);
        this.func_77656_e(128);
        this.setNoRepair();
    }

    public static class CrushingHammerRecipe
    extends ShapelessOreRecipe {
        public CrushingHammerRecipe(String recipe_name, ItemStack grit_stack, String ore_name) {
            super(new ResourceLocation("engineerstools", "hammer_crushing"), grit_stack, new Object[]{ore_name, new ItemStack((Item)ModContent.CRUSHING_HAMMER, 1, Short.MAX_VALUE)});
            this.setRegistryName(new ResourceLocation("engineerstools", recipe_name.toLowerCase().replace(" ", "")));
        }

        public CrushingHammerRecipe(String recipe_name, ItemStack grit_stack, Item ore_item) {
            super(new ResourceLocation("engineerstools", "hammer_crushing"), grit_stack, new Object[]{ore_item, new ItemStack((Item)ModContent.CRUSHING_HAMMER, 1, Short.MAX_VALUE)});
            this.setRegistryName(new ResourceLocation("engineerstools", recipe_name.toLowerCase().replace(" ", "")));
        }

        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
            int i;
            NonNullList remaining = ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
            ItemStack reference_hammer = new ItemStack((Item)ModContent.CRUSHING_HAMMER, 1);
            int hammer_position = -1;
            for (i = 0; i < inv.func_70302_i_(); ++i) {
                if (!inv.func_70301_a(i).func_185136_b(reference_hammer)) continue;
                hammer_position = i;
                break;
            }
            if (hammer_position >= 0 && hammer_position < remaining.size()) {
                ItemStack used_hammer = inv.func_70301_a(hammer_position);
                int durability = used_hammer.func_77952_i() + hammer_wear_off;
                if (durability >= used_hammer.func_77958_k()) {
                    return remaining;
                }
                used_hammer.func_77964_b(durability);
                remaining.set(hammer_position, (Object)used_hammer.func_77946_l());
            }
            if (num_output_stacks > 1) {
                for (i = 0; i < remaining.size(); ++i) {
                    if (!((ItemStack)remaining.get(i)).func_190926_b()) continue;
                    ItemStack stack = this.func_77572_b(inv);
                    stack.func_190920_e(num_output_stacks - 1);
                    remaining.set(i, (Object)stack);
                    break;
                }
            }
            return remaining;
        }

        public static void registerAll(RegistryEvent.Register<IRecipe> event) {
            CrushingHammerRecipe.registerGritRecipes((IForgeRegistry<IRecipe>)event.getRegistry());
            CrushingHammerRecipe.registerGritFurnaceRecipes((IForgeRegistry<IRecipe>)event.getRegistry());
        }

        private static void registerGritRecipe(IForgeRegistry<IRecipe> registry, ItemStack grit_stack, String ore_name) {
            if (grit_stack.func_77960_j() == Short.MAX_VALUE) {
                grit_stack.func_77964_b(0);
            }
            grit_stack.func_190920_e(1);
            if (ore_name.contains(":")) {
                Item ore_item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(ore_name));
                if (ore_item == null) {
                    ModEngineersTools.logger.error("Item for recipe registration not found: '" + ore_name + "'");
                    return;
                }
                ore_name = ore_name.replaceAll(":", "").toLowerCase();
                registry.register((IForgeRegistryEntry)new CrushingHammerRecipe("crushinghammer_" + ore_name.toLowerCase() + "_to_" + grit_stack.func_77973_b().getRegistryName().func_110624_b() + grit_stack.func_77973_b().getRegistryName().func_110623_a() + (grit_stack.func_77981_g() ? "_m" + (grit_stack.func_77960_j() != Short.MAX_VALUE ? grit_stack.func_77960_j() : 0) : "") + "_n" + grit_stack.func_190916_E(), grit_stack, ore_item));
            } else {
                registry.register((IForgeRegistryEntry)new CrushingHammerRecipe("crushinghammer_" + ore_name.toLowerCase() + "_to_" + grit_stack.func_77973_b().getRegistryName().func_110624_b() + grit_stack.func_77973_b().getRegistryName().func_110623_a() + (grit_stack.func_77981_g() ? "_m" + (grit_stack.func_77960_j() != Short.MAX_VALUE ? grit_stack.func_77960_j() : 0) : "") + "_n" + grit_stack.func_190916_E(), grit_stack, ore_name));
            }
        }

        public static void registerGritRecipes(IForgeRegistry<IRecipe> registry) {
            boolean gold_grit_registered = false;
            boolean iron_grit_registered = false;
            int num_crushing_hammer_recipes_registered = 0;
            String[] grit_preference = grit_preference_order.toLowerCase().trim().split(";");
            for (int i = 0; i < grit_preference.length; ++i) {
                grit_preference[i] = grit_preference[i].trim();
            }
            ArrayList ingredient_result_pairs = new ArrayList();
            for (String ore_name : OreDictionary.getOreNames()) {
                if (!ore_name.startsWith("ore") || ore_name.length() <= 5) continue;
                String grit_name = "dust" + ore_name.substring(3);
                if (!OreDictionary.doesOreNameExist((String)ore_name) || OreDictionary.getOres((String)ore_name).isEmpty() || !OreDictionary.doesOreNameExist((String)grit_name) || OreDictionary.getOres((String)grit_name).isEmpty()) continue;
                ItemStack preferred_stack = ItemStack.field_190927_a;
                for (ItemStack ore : OreDictionary.getOres((String)grit_name)) {
                    if (grit_preference.length == 0) {
                        preferred_stack = ore;
                        continue;
                    }
                    for (int i = grit_preference.length - 1; i >= 0; --i) {
                        if (grit_preference[i].isEmpty() || !ore.func_77973_b().getRegistryName().func_110624_b().equals(grit_preference[i])) continue;
                        preferred_stack = ore;
                    }
                }
                if (ore_name == "oreIron") {
                    iron_grit_registered = true;
                }
                if (ore_name == "oreGold") {
                    gold_grit_registered = true;
                }
                if (preferred_stack.func_190926_b()) continue;
                CrushingHammerRecipe.registerGritRecipe(registry, preferred_stack, ore_name);
                ++num_crushing_hammer_recipes_registered;
            }
            if (!iron_grit_registered) {
                CrushingHammerRecipe.registerGritRecipe(registry, new ItemStack((Item)ModContent.IRON_GRIT), "minecraft:iron_ore");
            }
            if (!gold_grit_registered) {
                CrushingHammerRecipe.registerGritRecipe(registry, new ItemStack((Item)ModContent.GOLD_GRIT), "minecraft:gold_ore");
            }
            ModEngineersTools.logger.info("Registered " + num_crushing_hammer_recipes_registered + " ore crashing hammer recipes, priority order: '" + grit_preference_order + "'");
        }

        public static void registerGritFurnaceRecipes(IForgeRegistry<IRecipe> registry) {
            GameRegistry.addSmelting((Item)ModContent.IRON_GRIT, (ItemStack)new ItemStack(Items.field_151042_j), (float)0.8f);
            GameRegistry.addSmelting((Item)ModContent.GOLD_GRIT, (ItemStack)new ItemStack(Items.field_151043_k), (float)1.0f);
        }
    }
}

