/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.detail;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import wile.engineerstools.detail.BlockCategories;

public class TreeCutting {
    private static final List<Vec3i> hoffsets = ImmutableList.of((Object)new Vec3i(1, 0, 0), (Object)new Vec3i(1, 0, 1), (Object)new Vec3i(0, 0, 1), (Object)new Vec3i(-1, 0, 1), (Object)new Vec3i(-1, 0, 0), (Object)new Vec3i(-1, 0, -1), (Object)new Vec3i(0, 0, -1), (Object)new Vec3i(1, 0, -1));

    private static List<BlockPos> findBlocksAround(World world, BlockPos centerPos, IBlockState leaf_type_state, Set<BlockPos> checked, int recursion_left) {
        ArrayList<BlockPos> to_decay = new ArrayList<BlockPos>();
        for (int y = -1; y <= 1; ++y) {
            BlockPos layer = centerPos.func_177982_a(0, y, 0);
            for (Vec3i v : hoffsets) {
                BlockPos pos = layer.func_177971_a(v);
                if (checked.contains(pos) || !BlockCategories.isSameLeaves(leaf_type_state, world.func_180495_p(pos))) continue;
                checked.add(pos);
                to_decay.add(pos);
                if (recursion_left <= 0) continue;
                to_decay.addAll(TreeCutting.findBlocksAround(world, pos, leaf_type_state, checked, recursion_left - 1));
            }
        }
        return to_decay;
    }

    public static int chopTree(World world, IBlockState broken_state, BlockPos startPos, EntityLivingBase player, int max_blocks_to_break) {
        if (!BlockCategories.isLog(broken_state)) {
            return 0;
        }
        long ymin = startPos.func_177956_o();
        long max_leaf_distance = 6L;
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        ArrayList<BlockPos> to_break = new ArrayList<BlockPos>();
        ArrayList<BlockPos> to_decay = new ArrayList<BlockPos>();
        checked.add(startPos);
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        LinkedList<BlockPos> upqueue = new LinkedList<BlockPos>();
        queue.add(startPos);
        int cutlevel = 0;
        int steps_left = 64;
        while (!queue.isEmpty() && --steps_left >= 0) {
            BlockPos pos = (BlockPos)queue.removeFirst();
            BlockPos uppos = pos.func_177984_a();
            IBlockState upstate = world.func_180495_p(uppos);
            if (!checked.contains(uppos)) {
                checked.add(uppos);
                if (BlockCategories.isSameLog(upstate, broken_state)) {
                    upqueue.add(uppos);
                    to_break.add(uppos);
                    steps_left = 64;
                } else {
                    boolean isleaf = BlockCategories.isLeaves(upstate);
                    if (isleaf || world.func_175623_d(uppos) || upstate.func_177230_c() instanceof BlockVine) {
                        if (isleaf) {
                            to_decay.add(uppos);
                        }
                        for (Vec3i v : hoffsets) {
                            BlockPos p = uppos.func_177971_a(v);
                            if (checked.contains(p)) continue;
                            checked.add(p);
                            IBlockState st = world.func_180495_p(p);
                            Block bl = st.func_177230_c();
                            if (BlockCategories.isSameLog(st, broken_state)) {
                                queue.add(p);
                                to_break.add(p);
                                continue;
                            }
                            if (!BlockCategories.isLeaves(st)) continue;
                            to_decay.add(p);
                        }
                    }
                }
            }
            for (Vec3i v : hoffsets) {
                BlockPos p = pos.func_177971_a(v);
                if (checked.contains(p)) continue;
                checked.add(p);
                if (p.func_177951_i((Vec3i)new BlockPos(startPos.func_177958_n(), p.func_177956_o(), startPos.func_177952_p())) > (double)(3 + cutlevel * cutlevel)) continue;
                IBlockState st = world.func_180495_p(p);
                Block bl = st.func_177230_c();
                if (BlockCategories.isSameLog(st, broken_state)) {
                    queue.add(p);
                    to_break.add(p);
                    continue;
                }
                if (!BlockCategories.isLeaves(st)) continue;
                to_decay.add(p);
            }
            if (!queue.isEmpty() || upqueue.isEmpty()) continue;
            queue = upqueue;
            upqueue = new LinkedList();
            ++cutlevel;
        }
        for (BlockPos pos : to_decay) {
            int dist = 1;
            to_break.addAll(TreeCutting.findBlocksAround(world, pos, broken_state, checked, dist));
        }
        if (!to_decay.isEmpty()) {
            IBlockState leaf_type_state = world.func_180495_p((BlockPos)to_decay.get(0));
            ArrayList<BlockPos> leafs = to_decay;
            to_decay = new ArrayList();
            for (BlockPos pos : leafs) {
                int dist = 2;
                to_decay.add(pos);
                to_decay.addAll(TreeCutting.findBlocksAround(world, pos, leaf_type_state, checked, dist));
            }
        }
        checked.remove(startPos);
        int num_broken = 0;
        Collections.reverse(to_break);
        for (BlockPos pos : to_break) {
            if (++num_broken > max_blocks_to_break) break;
            IBlockState state = world.func_180495_p(pos);
            world.func_175698_g(pos);
            state.func_177230_c().func_176226_b(world, pos, state, 0);
        }
        for (BlockPos pos : to_decay) {
            if (++num_broken > max_blocks_to_break) break;
            IBlockState state = world.func_180495_p(pos);
            world.func_175698_g(pos);
            state.func_177230_c().func_176226_b(world, pos, state, 0);
        }
        return MathHelper.func_76125_a((int)(to_break.size() * 6 / 5 + to_decay.size() / 10 - 1), (int)1, (int)65535);
    }
}

