/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.detail;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.function.BooleanSupplier;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import wile.engineerstools.ModEngineersTools;
import wile.engineerstools.detail.ModConfig;

public class RecipeCondModSpecific
implements IConditionFactory {
    public static final BooleanSupplier RECIPE_INCLUDE = () -> true;
    public static final BooleanSupplier RECIPE_EXCLUDE = () -> false;
    public static int num_skipped = 0;

    private static BooleanSupplier exclude() {
        ++num_skipped;
        return RECIPE_EXCLUDE;
    }

    public BooleanSupplier parse(JsonContext context, JsonObject json) {
        if (ModConfig.isWithoutRecipes()) {
            return RecipeCondModSpecific.exclude();
        }
        try {
            JsonArray missing;
            JsonPrimitive result;
            IForgeRegistry block_registry = ForgeRegistries.BLOCKS;
            IForgeRegistry item_registry = ForgeRegistries.ITEMS;
            JsonArray items = json.getAsJsonArray("required");
            if (items != null) {
                for (JsonElement e : items) {
                    ResourceLocation rl;
                    if (!e.isJsonPrimitive() || block_registry.containsKey(rl = new ResourceLocation(((JsonPrimitive)e).getAsString())) || item_registry.containsKey(rl)) continue;
                    return RecipeCondModSpecific.exclude();
                }
            }
            if ((result = json.getAsJsonPrimitive("result")) != null) {
                ResourceLocation rl = new ResourceLocation(result.getAsString());
                if (!block_registry.containsKey(rl) && !item_registry.containsKey(rl)) {
                    return RecipeCondModSpecific.exclude();
                }
                if (ModConfig.isOptedOut((Item)item_registry.getValue(rl))) {
                    return RecipeCondModSpecific.exclude();
                }
            }
            if ((missing = json.getAsJsonArray("missing")) != null && missing.size() > 0) {
                int num_missing = 0;
                for (JsonElement e : missing) {
                    ResourceLocation rl;
                    if (!e.isJsonPrimitive() || block_registry.containsKey(rl = new ResourceLocation(((JsonPrimitive)e).getAsString())) || item_registry.containsKey(rl)) continue;
                    ++num_missing;
                }
                return num_missing == 0 ? RecipeCondModSpecific.exclude() : RECIPE_INCLUDE;
            }
            return RECIPE_INCLUDE;
        }
        catch (Throwable ex) {
            ModEngineersTools.logger.error("engineerstools::ResultRegisteredCondition failed: " + ex.toString());
            return RecipeCondModSpecific.exclude();
        }
    }
}

