/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.detail;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ModAuxiliaries {
    public static TextComponentTranslation localizable(String modtrkey, @Nullable TextFormatting color, Object ... args) {
        TextComponentTranslation tr = new TextComponentTranslation("engineerstools." + modtrkey, args);
        if (color != null) {
            tr.func_150256_b().func_150238_a(color);
        }
        return tr;
    }

    @SideOnly(value=Side.CLIENT)
    public static String localize(String translationKey, Object ... args) {
        TextComponentTranslation tr = new TextComponentTranslation(translationKey, args);
        tr.func_150256_b().func_150238_a(TextFormatting.RESET);
        String ft = tr.func_150254_d();
        if (ft.contains("${")) {
            Pattern pt = Pattern.compile("\\$\\{([\\w\\.]+)\\}");
            Matcher mt = pt.matcher(ft);
            StringBuffer sb = new StringBuffer();
            while (mt.find()) {
                mt.appendReplacement(sb, new TextComponentTranslation(mt.group(1), new Object[0]).func_150254_d().trim());
            }
            mt.appendTail(sb);
            return sb.toString();
        }
        return ft;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean hasTranslation(String key) {
        return I18n.func_188566_a((String)key);
    }

    public static final AxisAlignedBB getPixeledAABB(double x0, double y0, double z0, double x1, double y1, double z1) {
        return new AxisAlignedBB(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0);
    }

    public static final class Tooltip {
        @SideOnly(value=Side.CLIENT)
        public static boolean extendedTipCondition() {
            return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        }

        @SideOnly(value=Side.CLIENT)
        public static boolean helpCondition() {
            return Tooltip.extendedTipCondition() && (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157));
        }

        @SideOnly(value=Side.CLIENT)
        public static boolean addInformation(@Nullable String advancedTooltipTranslationKey, @Nullable String helpTranslationKey, List<String> tooltip, ITooltipFlag flag, boolean addAdvancedTooltipHints) {
            boolean tip_available;
            boolean help_available = helpTranslationKey != null && ModAuxiliaries.hasTranslation(helpTranslationKey + ".help");
            boolean bl = tip_available = advancedTooltipTranslationKey != null && ModAuxiliaries.hasTranslation(helpTranslationKey + ".tip");
            if (!help_available && !tip_available) {
                return false;
            }
            if (Tooltip.helpCondition()) {
                if (!help_available) {
                    return false;
                }
                String s = ModAuxiliaries.localize(helpTranslationKey + ".help", new Object[0]);
                if (s.isEmpty()) {
                    return false;
                }
                tooltip.add(s);
                return true;
            }
            if (Tooltip.extendedTipCondition()) {
                if (!tip_available) {
                    return false;
                }
                String s = ModAuxiliaries.localize(advancedTooltipTranslationKey + ".tip", new Object[0]);
                if (s.isEmpty()) {
                    return false;
                }
                tooltip.add(s);
                return true;
            }
            if (addAdvancedTooltipHints) {
                String s = "";
                if (tip_available) {
                    s = s + ModAuxiliaries.localize("engineerstools.tooltip.hint.extended", new Object[0]) + (help_available ? " " : "");
                }
                if (help_available) {
                    s = s + ModAuxiliaries.localize("engineerstools.tooltip.hint.help", new Object[0]);
                }
                tooltip.add(s);
            }
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public static boolean addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag, boolean addAdvancedTooltipHints) {
            return Tooltip.addInformation(stack.func_77977_a(), stack.func_77977_a(), tooltip, flag, addAdvancedTooltipHints);
        }
    }
}

