/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import wile.rsgauges.blocks.BlockSwitch;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModResources;

public class BlockDimmerSwitch
extends BlockSwitch {
    public static final PropertyInteger POWER = PropertyInteger.func_177719_a((String)"power", (int)0, (int)15);

    public BlockDimmerSwitch(String registryName, AxisAlignedBB unrotatedBB, long config, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound, @Nullable Material material) {
        super(registryName, unrotatedBB, null, config | 0xFFL, powerOnSound, powerOffSound, material);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED, POWER});
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        BlockSwitch.TileEntitySwitch te = this.getTe(world, pos);
        return te == null ? state : state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(te.on_power()));
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean was_powered;
        if (world.field_72995_K || !(state.func_177230_c() instanceof BlockDimmerSwitch)) {
            return true;
        }
        BlockSwitch.TileEntitySwitch te = this.getTe((IBlockAccess)world, pos);
        if (te == null || state == null) {
            return true;
        }
        te.click_config(null, false);
        BlockSwitch.ClickInteraction ck = BlockSwitch.ClickInteraction.get(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
        boolean bl = was_powered = te.on_power() != 0;
        if (ck.touch_configured) {
            int p = (int)ck.y;
            if (p != te.on_power()) {
                te.on_power(p);
                p = te.on_power();
                ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.dimmerswitch.output_power", TextFormatting.RED, p));
                int state_p = (Integer)state.func_177229_b((IProperty)POWER);
                if (state_p != p) {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(p)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(p > 0)), 3);
                    this.notifyNeighbours(world, pos, state, te, false);
                    te.func_70296_d();
                }
                if (was_powered && p == 0) {
                    this.power_off_sound.play(world, pos);
                } else {
                    this.power_on_sound.play(world, pos);
                }
                if (was_powered == (p == 0) && (this.config & 0x100000000000000L) != 0L && !was_powered && !te.activate_links(1)) {
                    ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
                }
            }
            return true;
        }
        if (ck.wrenched && te.click_config(this, false)) {
            ModAuxiliaries.playerStatusMessage(player, te.configStatusTextComponentTranslation((BlockSwitch)state.func_177230_c()));
        }
        return true;
    }
}

