/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wile.rsgauges.blocks.BlockAutoSwitch;
import wile.rsgauges.blocks.BlockSwitch;
import wile.rsgauges.blocks.RsBlock;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModConfig;
import wile.rsgauges.detail.ModResources;

public class BlockComparatorSwitch
extends BlockAutoSwitch {
    public BlockComparatorSwitch(String registryName, AxisAlignedBB unrotatedBB, long config, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound, @Nullable Material material) {
        super(registryName, unrotatedBB, config, powerOnSound, powerOffSound, material);
    }

    public BlockComparatorSwitch(String registryName, AxisAlignedBB unrotatedBB, long config, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(registryName, unrotatedBB, config, powerOnSound, powerOffSound, null);
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityComparatorSwitch();
    }

    public static class TileEntityComparatorSwitch
    extends BlockAutoSwitch.TileEntityEnvironmentalSensorSwitch
    implements ITickable {
        private static final Acquisition[] acquisitions = new Acquisition[]{(world, pos, state, side) -> !state.func_185912_n() ? -1 : state.func_185888_a(world, pos), (world, pos, state, side) -> {
            TileEntity te = world.func_175625_s(pos);
            if (te == null) {
                return -1;
            }
            if (te instanceof IInventory) {
                IInventory inventory = (IInventory)te;
                int size = inventory.func_70302_i_();
                int n = 0;
                for (int i = 0; i < size; ++i) {
                    n += inventory.func_70301_a(i).func_190926_b() ? 0 : 1;
                }
                return (int)Math.round((double)n * 15.0 / (double)size);
            }
            if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                if (handler == null) {
                    return -1;
                }
                int size = handler.getSlots();
                if (size == 0) {
                    return 0;
                }
                int n = 0;
                for (int i = 0; i < size; ++i) {
                    n += handler.getStackInSlot(i).func_190926_b() ? 0 : 1;
                }
                return (int)Math.round((double)n * 15.0 / (double)size);
            }
            return -1;
        }, (world, pos, state, side) -> {
            TileEntity te = world.func_175625_s(pos);
            if (te == null) {
                return -1;
            }
            if (te instanceof IInventory) {
                IInventory inventory = (IInventory)te;
                int size = inventory.func_70302_i_();
                int n = 0;
                for (int i = 0; i < size; ++i) {
                    n += inventory.func_70301_a(i).func_190926_b() ? 1 : 0;
                }
                return (int)Math.round((double)n * 15.0 / (double)size);
            }
            if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                if (handler == null) {
                    return -1;
                }
                int size = handler.getSlots();
                if (size == 0) {
                    return 0;
                }
                int n = 0;
                for (int i = 0; i < size; ++i) {
                    n += handler.getStackInSlot(i).func_190926_b() ? 1 : 0;
                }
                return (int)Math.round((double)n * 15.0 / (double)size);
            }
            return -1;
        }};

        public TileEntityComparatorSwitch() {
            this.reset();
        }

        @Override
        public void reset(IBlockAccess world) {
            super.reset(world);
            this.on_power(15);
            this.threshold0_on(1.0);
            this.threshold0_off(0.0);
            this.debounce(0);
        }

        private int acquisition_mode() {
            return this.debounce();
        }

        private void acquisition_mode(int mode) {
            this.debounce(MathHelper.func_76125_a((int)mode, (int)0, (int)(acquisitions.length - 1)));
        }

        @Override
        public boolean activation_config(IBlockState state, @Nullable EntityPlayer player, double x, double y) {
            int field;
            int direction;
            if (state == null) {
                return false;
            }
            int n = y >= 9.0 ? 1 : (direction = y <= 6.0 ? -1 : 0);
            int n2 = x >= 2.0 && x <= 3.95 ? 1 : (x >= 4.25 && x <= 7.0 ? 2 : (x >= 8.0 && x <= 10.0 ? 3 : (field = x >= 11.0 && x <= 13.0 ? 4 : 0)));
            if (direction == 0 || field == 0) {
                return false;
            }
            switch (field) {
                case 1: {
                    double v = this.threshold0_on() + (double)direction;
                    if (v < 1.0) {
                        v = 1.0;
                    } else if (v > 15.0) {
                        v = 15.0;
                    }
                    this.threshold0_on(v);
                    if (!(this.threshold0_on() < this.threshold0_off())) break;
                    this.threshold0_off(this.threshold0_on());
                    break;
                }
                case 2: {
                    double v = this.threshold0_off() + (double)direction;
                    if (v < 0.0) {
                        v = 0.0;
                    } else if (v > 14.0) {
                        v = 14.0;
                    }
                    this.threshold0_off(v);
                    if (!(this.threshold0_off() > this.threshold0_on())) break;
                    this.threshold0_on(this.threshold0_off());
                    break;
                }
                case 3: {
                    this.acquisition_mode(this.acquisition_mode() + direction);
                    break;
                }
                case 4: {
                    this.on_power(this.on_power() + direction);
                }
            }
            if (this.on_power() < 1) {
                this.on_power(1);
            }
            TextComponentString separator = new TextComponentString(" | ");
            separator.func_150256_b().func_150238_a(TextFormatting.GRAY);
            ArrayList<Object> tr = new ArrayList<Object>();
            tr.add(ModAuxiliaries.localizable("switchconfig.comparator_switch.threshold_on", TextFormatting.BLUE, (int)this.threshold0_on()));
            tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.comparator_switch.threshold_off", TextFormatting.YELLOW, (int)this.threshold0_off())));
            tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.comparator_switch.output_power", TextFormatting.RED, this.on_power())));
            tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.comparator_switch.mode" + this.acquisition_mode(), TextFormatting.DARK_GREEN, new Object[0])));
            tr.add(separator.func_150259_f().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.comparator_switch.output_power", TextFormatting.RED, this.on_power())));
            ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.comparator_switch", TextFormatting.RESET, tr.toArray()));
            this.func_70296_d();
            return true;
        }

        @Override
        public void func_73660_a() {
            if (ModConfig.zmisc.without_environmental_switch_update) {
                return;
            }
            if (!this.func_145830_o() || this.func_145831_w().field_72995_K || --this.update_timer_ > 0) {
                return;
            }
            if (this.update_interval_ < 4) {
                this.update_interval_ = 4;
            }
            this.update_timer_ = this.update_interval_ + (int)(Math.random() * 2.0);
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof BlockComparatorSwitch)) {
                return;
            }
            boolean active = (Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED);
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)RsBlock.FACING);
            BlockPos adjacent_pos = this.func_174877_v().func_177972_a(facing.func_176734_d());
            IBlockState adjacent_state = this.func_145831_w().func_180495_p(adjacent_pos);
            this.acquisition_mode(this.acquisition_mode());
            int value = MathHelper.func_76125_a((int)acquisitions[this.acquisition_mode()].sample(this.field_145850_b, adjacent_pos, adjacent_state, facing), (int)-1, (int)15);
            if (value < 0) {
                active = false;
                this.update_timer_ = 20;
            } else {
                int measurement = 0;
                if (this.threshold0_off() >= this.threshold0_on()) {
                    measurement += (double)value == this.threshold0_on() ? 1 : -1;
                } else {
                    if ((double)value >= this.threshold0_on()) {
                        measurement = 1;
                    }
                    if ((double)value <= this.threshold0_off()) {
                        measurement = -1;
                    }
                }
                if (measurement != 0) {
                    active = measurement > 0;
                }
            }
            this.updateSwitchState(state, (BlockComparatorSwitch)state.func_177230_c(), active, 0);
        }

        private static interface Acquisition {
            public int sample(World var1, BlockPos var2, IBlockState var3, EnumFacing var4);
        }
    }
}

