/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.CapabilitySkyhookData;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.entities.EntitySkylineHook;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SkylineHelper {
    private static final double LN_0_98 = Math.log(0.98);

    public static void spawnHook(EntityLivingBase player, TileEntity start, ImmersiveNetHandler.Connection connection, EnumHand hand, boolean limitSpeed) {
        if (!player.field_70170_p.field_72995_K) {
            BlockPos cc0 = connection.end == Utils.toCC(start) ? connection.start : connection.end;
            BlockPos cc1 = connection.end == Utils.toCC(start) ? connection.end : connection.start;
            IImmersiveConnectable iicStart = ApiUtils.toIIC(cc1, player.field_70170_p);
            IImmersiveConnectable iicEnd = ApiUtils.toIIC(cc0, player.field_70170_p);
            Vec3d vStart = new Vec3d((Vec3i)cc1);
            Vec3d vEnd = new Vec3d((Vec3i)cc0);
            if (iicStart != null) {
                vStart = Utils.addVectors(vStart, iicStart.getConnectionOffset(connection));
            }
            if (iicEnd != null) {
                vEnd = Utils.addVectors(vEnd, iicEnd.getConnectionOffset(connection));
            }
            Vec3d pos = player.func_174824_e(0.0f);
            Vec3d across = new Vec3d(vEnd.field_72450_a - vStart.field_72450_a, vEnd.field_72448_b - vStart.field_72448_b, vEnd.field_72449_c - vStart.field_72449_c);
            double linePos = Utils.getCoeffForMinDistance(pos, vStart, across);
            connection.getSubVertices(player.field_70170_p);
            Vec3d playerMovement = new Vec3d(player.field_70159_w, player.field_70181_x, player.field_70179_y);
            double slopeAtPos = connection.getSlopeAt(linePos);
            Vec3d extendedWire = connection.vertical ? new Vec3d(0.0, connection.horizontalLength, 0.0) : new Vec3d(connection.across.field_72450_a, slopeAtPos * connection.horizontalLength, connection.across.field_72449_c);
            extendedWire = extendedWire.func_72432_b();
            double totalSpeed = playerMovement.func_72430_b(extendedWire);
            double horSpeed = totalSpeed / Math.sqrt(1.0 + slopeAtPos * slopeAtPos);
            EntitySkylineHook hook = new EntitySkylineHook(player.field_70170_p, connection, linePos, hand, horSpeed, limitSpeed);
            IELogger.logger.info("Speed keeping: Player {}, wire {}, Pos: {}", (Object)playerMovement, (Object)extendedWire, (Object)hook.func_174791_d());
            if (hook.isValidPosition(hook.field_70165_t, hook.field_70163_u, hook.field_70161_v, player)) {
                double vertSpeed = Math.sqrt(totalSpeed * totalSpeed - horSpeed * horSpeed);
                double speedDiff = player.field_70181_x - vertSpeed;
                if (speedDiff < 0.0) {
                    player.func_180430_e(SkylineHelper.fallDistanceFromSpeed(speedDiff), 1.2f);
                    player.field_70143_R = 0.0f;
                }
                player.field_70170_p.func_72838_d((Entity)hook);
                CapabilitySkyhookData.SkyhookUserData data = (CapabilitySkyhookData.SkyhookUserData)Objects.requireNonNull(player.getCapability(CapabilitySkyhookData.SKYHOOK_USER_DATA, EnumFacing.UP));
                data.startRiding();
                data.hook = hook;
                player.func_184220_m((Entity)hook);
            }
        }
    }

    public static float fallDistanceFromSpeed(double v) {
        double fallTime = Math.log(v / 3.92 + 1.0) / LN_0_98;
        return -((float)(196.0 - 3.92 * fallTime - 194.04 * Math.pow(0.98, fallTime - 0.5)));
    }

    public static List<AxisAlignedBB> getCollisionBoxes(@Nullable Entity entityIn, AxisAlignedBB aabb, World w, Collection<BlockPos> ignored) {
        ArrayList list = Lists.newArrayList();
        SkylineHelper.getBlockCollisionBoxes(entityIn, aabb, list, w, ignored);
        if (entityIn != null) {
            List entities = w.func_72839_b(entityIn, aabb.func_186662_g(0.25));
            for (Entity entity : entities) {
                if (entityIn.func_184223_x(entity)) continue;
                AxisAlignedBB entityBB = entity.func_70046_E();
                if (entityBB != null && entityBB.func_72326_a(aabb)) {
                    list.add(entityBB);
                }
                if ((entityBB = entityIn.func_70114_g(entity)) == null || !entityBB.func_72326_a(aabb)) continue;
                list.add(entityBB);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new GetCollisionBoxesEvent(w, entityIn, aabb, (List)list));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getBlockCollisionBoxes(@Nullable Entity entityIn, AxisAlignedBB aabb, @Nonnull List<AxisAlignedBB> outList, World w, Collection<BlockPos> ignored) {
        int minX = MathHelper.func_76128_c((double)aabb.field_72340_a) - 1;
        int maxX = MathHelper.func_76143_f((double)aabb.field_72336_d) + 1;
        int minY = MathHelper.func_76128_c((double)aabb.field_72338_b) - 1;
        int maxY = MathHelper.func_76143_f((double)aabb.field_72337_e) + 1;
        int minZ = MathHelper.func_76128_c((double)aabb.field_72339_c) - 1;
        int maxZ = MathHelper.func_76143_f((double)aabb.field_72334_f) + 1;
        WorldBorder worldborder = w.func_175723_af();
        boolean outsideWorld = entityIn != null && entityIn.func_174832_aS();
        boolean insideWorld = entityIn != null && w.func_191503_g(entityIn);
        IBlockState outsideState = Blocks.field_150348_b.func_176223_P();
        BlockPos.PooledMutableBlockPos mutPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    boolean zBorder;
                    boolean xBorder = x == minX || x == maxX - 1;
                    boolean bl = zBorder = z == minZ || z == maxZ - 1;
                    if (xBorder && zBorder || !w.func_175667_e((BlockPos)mutPos.func_181079_c(x, 64, z))) continue;
                    for (int y = minY; y < maxY; ++y) {
                        if ((xBorder || zBorder) && y == maxY - 1) continue;
                        if (entityIn != null && outsideWorld == insideWorld) {
                            entityIn.func_174821_h(!insideWorld);
                        }
                        mutPos.func_181079_c(x, y, z);
                        if (ignored.contains(mutPos)) continue;
                        IBlockState currState = !worldborder.func_177746_a((BlockPos)mutPos) && insideWorld ? outsideState : w.func_180495_p((BlockPos)mutPos);
                        currState.func_185908_a(w, (BlockPos)mutPos, aabb, outList, entityIn, false);
                    }
                }
            }
        }
        finally {
            mutPos.func_185344_t();
        }
    }
}

