/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.entities.EntityRailgunShot;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Triple;

public class ItemRailgun
extends ItemUpgradeableTool
implements EnergyHelper.IIEEnergyItem,
ZoomHandler.IZoomTool,
ITool,
IOBJModelCallback<ItemStack> {
    float[] zoomSteps = new float[]{0.1f, 0.15625f, 0.2f, 0.25f, 0.3125f, 0.4f, 0.5f, 0.625f};

    public ItemRailgun() {
        super("railgun", 1, "RAILGUN", new String[0]);
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 3;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return new Slot[]{new IESlot.Upgrades(container, inv, 0, 80, 32, "RAILGUN", stack, true), new IESlot.Upgrades(container, inv, 1, 100, 32, "RAILGUN", stack, true)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public void recalculateUpgrades(ItemStack stack) {
        super.recalculateUpgrades(stack);
        if (this.getEnergyStored(stack) > this.getMaxEnergyStored(stack)) {
            ItemNBTHelper.setInt(stack, "energy", this.getMaxEnergyStored(stack));
        }
    }

    @Override
    public void clearUpgrades(ItemStack stack) {
        super.clearUpgrades(stack);
        if (this.getEnergyStored(stack) > this.getMaxEnergyStored(stack)) {
            ItemNBTHelper.setInt(stack, "energy", this.getMaxEnergyStored(stack));
        }
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        if (oldStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null) && newStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null)) {
            CapabilityShader.ShaderWrapper wrapperOld = (CapabilityShader.ShaderWrapper)oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            CapabilityShader.ShaderWrapper wrapperNew = (CapabilityShader.ShaderWrapper)newStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            if (!ItemStack.func_77989_b((ItemStack)wrapperOld.getShaderItem(), (ItemStack)wrapperNew.getShaderItem())) {
                return true;
            }
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_190926_b()) {
            return new IEItemStackHandler(stack){
                final EnergyHelper.ItemEnergyStorage energyStorage;
                final CapabilityShader.ShaderWrapper_Item shaders;
                {
                    super(stack2);
                    this.energyStorage = new EnergyHelper.ItemEnergyStorage(stack);
                    this.shaders = new CapabilityShader.ShaderWrapper_Item("immersiveengineering:railgun", stack);
                }

                @Override
                public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                    return capability == CapabilityEnergy.ENERGY || capability == CapabilityShader.SHADER_CAPABILITY || super.hasCapability(capability, facing);
                }

                @Override
                public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    if (capability == CapabilityEnergy.ENERGY) {
                        return (T)this.energyStorage;
                    }
                    if (capability == CapabilityShader.SHADER_CAPABILITY) {
                        return (T)this.shaders;
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        String stored = this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack);
        list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}));
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack);
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.NONE;
    }

    private EnumHandSide getActiveSide(EntityLivingBase user) {
        EnumHandSide ret = user.func_184591_cq();
        if (user.func_184600_cs() != EnumHand.MAIN_HAND) {
            ret = ret == EnumHandSide.LEFT ? EnumHandSide.RIGHT : EnumHandSide.LEFT;
        }
        return ret;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int energy = Config.IEConfig.Tools.railgun_consumption;
        float energyMod = 1.0f + this.getUpgrades(stack).func_74760_g("consumption");
        if (this.extractEnergy(stack, energy = (int)((float)energy * energyMod), true) == energy && !ItemRailgun.findAmmo(player).func_190926_b()) {
            player.func_184598_c(hand);
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.getChargeTime(stack) <= 20 ? IESounds.chargeFast : IESounds.chargeSlow, SoundCategory.PLAYERS, 1.5f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase user, int count) {
        int inUse = this.func_77626_a(stack) - count;
        if (inUse > this.getChargeTime(stack) && inUse % 20 == user.func_70681_au().nextInt(20)) {
            user.field_70170_p.func_184148_a(null, user.field_70165_t, user.field_70163_u, user.field_70161_v, IESounds.spark, SoundCategory.PLAYERS, 0.8f + 0.2f * user.func_70681_au().nextFloat(), 0.5f + 0.5f * user.func_70681_au().nextFloat());
            Triple<ItemStack, ShaderRegistry.ShaderRegistryEntry, ShaderCase> shader = ShaderRegistry.getStoredShaderAndCase(stack);
            if (shader != null) {
                Vec3d pos = Utils.getLivingFrontPos(user, 0.4375, (double)user.field_70131_O * 0.75, this.getActiveSide(user), false, 1.0f);
                ((ShaderRegistry.ShaderRegistryEntry)shader.getMiddle()).getEffectFunction().execute(user.field_70170_p, (ItemStack)shader.getLeft(), stack, ((ShaderCase)shader.getRight()).getShaderType(), pos, null, 0.0625f);
            }
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase user, int timeLeft) {
        if (user instanceof EntityPlayer) {
            ItemStack ammo;
            int inUse = this.func_77626_a(stack) - timeLeft;
            ItemNBTHelper.remove(stack, "inUse");
            if (inUse < this.getChargeTime(stack)) {
                return;
            }
            int energy = Config.IEConfig.Tools.railgun_consumption;
            float energyMod = 1.0f + this.getUpgrades(stack).func_74760_g("consumption");
            if (this.extractEnergy(stack, energy = (int)((float)energy * energyMod), true) == energy && !(ammo = ItemRailgun.findAmmo((EntityPlayer)user)).func_190926_b()) {
                Triple<ItemStack, ShaderRegistry.ShaderRegistryEntry, ShaderCase> shader;
                Vec3d vec = user.func_70040_Z();
                float speed = 20.0f;
                EntityRailgunShot shot = new EntityRailgunShot(user.field_70170_p, user, vec.field_72450_a * (double)speed, vec.field_72448_b * (double)speed, vec.field_72449_c * (double)speed, Utils.copyStackWithAmount(ammo, 1));
                ammo.func_190918_g(1);
                if (ammo.func_190916_E() <= 0) {
                    ((EntityPlayer)user).field_71071_by.func_184437_d(ammo);
                }
                user.field_70170_p.func_184148_a(null, user.field_70165_t, user.field_70163_u, user.field_70161_v, IESounds.railgunFire, SoundCategory.PLAYERS, 1.0f, 0.5f + 0.5f * user.func_70681_au().nextFloat());
                this.extractEnergy(stack, energy, false);
                if (!world.field_72995_K) {
                    user.field_70170_p.func_72838_d((Entity)shot);
                }
                if ((shader = ShaderRegistry.getStoredShaderAndCase(stack)) != null) {
                    Vec3d pos = Utils.getLivingFrontPos(user, 0.75, (double)user.field_70131_O * 0.75, this.getActiveSide(user), false, 1.0f);
                    ((ShaderRegistry.ShaderRegistryEntry)shader.getMiddle()).getEffectFunction().execute(world, (ItemStack)shader.getLeft(), stack, ((ShaderCase)shader.getRight()).getShaderType(), pos, user.func_70040_Z(), 0.125f);
                }
            }
        }
    }

    public static ItemStack findAmmo(EntityPlayer player) {
        if (ItemRailgun.isAmmo(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (ItemRailgun.isAmmo(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!ItemRailgun.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isAmmo(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        RailgunHandler.RailgunProjectileProperties prop = RailgunHandler.getProjectileProperties(stack);
        return prop != null;
    }

    public int getChargeTime(ItemStack railgun) {
        return (int)(40.0f / (1.0f + this.getUpgrades(railgun).func_74760_g("speed")));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Override
    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return 1600;
    }

    public String[] compileRender(ItemStack stack) {
        HashSet<String> render = new HashSet<String>();
        render.add("frame");
        render.add("barrel");
        render.add("grip");
        render.add("capacitors");
        render.add("sled");
        render.add("wires");
        NBTTagCompound upgrades = this.getUpgrades(stack);
        if (upgrades.func_74769_h("speed") > 0.0) {
            render.add("upgrade_speed");
        }
        if (upgrades.func_74767_n("scope")) {
            render.add("upgrade_scope");
        }
        return render.toArray(new String[render.size()]);
    }

    @Override
    public boolean canZoom(ItemStack stack, EntityPlayer player) {
        return this.getUpgrades(stack).func_74767_n("scope");
    }

    @Override
    public float[] getZoomSteps(ItemStack stack, EntityPlayer player) {
        return this.zoomSteps;
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(ItemStack stack, String group) {
        if (group.equals("upgrade_scope")) {
            return this.getUpgrades(stack).func_74767_n("scope");
        }
        if (group.equals("upgrade_speed")) {
            return this.getUpgrades(stack).func_74769_h("speed") > 0.0;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Optional<TRSRTransformation> applyTransformations(ItemStack stack, String group, Optional<TRSRTransformation> transform) {
        return transform;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Matrix4 handlePerspective(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType, Matrix4 perspective, EntityLivingBase entity) {
        return perspective;
    }
}

