/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.IEApi;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class ComparableItemStack {
    public ItemStack stack;
    public boolean useNBT;
    public int oreID = -1;

    public ComparableItemStack(ItemStack stack) {
        this(stack, true);
    }

    public ComparableItemStack(ItemStack stack, boolean matchOre) {
        this(stack, matchOre, true);
    }

    public ComparableItemStack(ItemStack stack, boolean matchOre, boolean copy) {
        int[] oids;
        if (stack == null) {
            throw new RuntimeException("You cannot instantiate a ComparableItemStack with null for an Item!");
        }
        this.stack = stack;
        if (copy) {
            this.copy();
        }
        if (matchOre && (oids = OreDictionary.getOreIDs((ItemStack)stack)) != null && oids.length > 0) {
            this.oreID = oids[0];
        }
    }

    public void copy() {
        this.stack = this.stack.func_77946_l();
    }

    public ComparableItemStack(String oreName) {
        this(IEApi.getPreferredOreStack(oreName), true, false);
        this.oreID = OreDictionary.getOreID((String)oreName);
    }

    public ComparableItemStack setUseNBT(boolean useNBT) {
        this.useNBT = useNBT;
        return this;
    }

    public ComparableItemStack setOreID(int oid) {
        this.oreID = oid;
        return this;
    }

    public String toString() {
        return "ComparableStack: {" + this.stack.toString() + "}; oreID: " + this.oreID + "; checkNBT: " + this.useNBT;
    }

    public int hashCode() {
        if (this.oreID != -1) {
            return this.oreID;
        }
        int hash = (this.stack.func_77952_i() & 0xFFFF) * 31 + this.stack.func_77973_b().hashCode() * 31;
        if (this.useNBT && this.stack.func_77942_o()) {
            hash += this.stack.func_77978_p().hashCode() * 31;
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComparableItemStack)) {
            return false;
        }
        if (this.oreID != -1 && ((ComparableItemStack)object).oreID != -1) {
            return this.oreID == ((ComparableItemStack)object).oreID;
        }
        ItemStack otherStack = ((ComparableItemStack)object).stack;
        if (!OreDictionary.itemMatches((ItemStack)this.stack, (ItemStack)otherStack, (boolean)false)) {
            return false;
        }
        if (this.useNBT) {
            return ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)otherStack);
        }
        return true;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.oreID != -1) {
            nbt.func_74778_a("oreID", OreDictionary.getOreName((int)this.oreID));
        } else {
            nbt.func_74782_a("stack", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
            nbt.func_74757_a("useNBT", this.useNBT);
        }
        return nbt;
    }

    public static ComparableItemStack readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("oreID")) {
            return new ComparableItemStack(nbt.func_74779_i("oreID"));
        }
        if (nbt.func_74764_b("stack")) {
            ComparableItemStack comp = new ComparableItemStack(new ItemStack(nbt.func_74775_l("stack")), true, false);
            comp.useNBT = nbt.func_74767_n("useNBT");
            return comp;
        }
        return null;
    }
}

