/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.gui;

import betteradvancements.api.event.AdvancementMovedEvent;
import betteradvancements.gui.GuiBetterAdvancement;
import betteradvancements.gui.GuiBetterAdvancementTab;
import betteradvancements.reference.Resources;
import betteradvancements.util.RenderUtil;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketSeenAdvancements;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiScreenBetterAdvancements
extends GuiScreen
implements ClientAdvancementManager.IListener {
    private static final int WIDTH = 252;
    private static final int HEIGHT = 140;
    private static final int CORNER_SIZE = 30;
    private static final int SIDE = 30;
    private static final int TOP = 40;
    private static final int BOTTOM = 30;
    private static final int PADDING = 9;
    private static final float MIN_ZOOM = 1.0f;
    private static final float MAX_ZOOM = 2.0f;
    private static final float ZOOM_STEP = 0.2f;
    private final ClientAdvancementManager clientAdvancementManager;
    private final Map<Advancement, GuiBetterAdvancementTab> tabs = Maps.newLinkedHashMap();
    private GuiBetterAdvancementTab selectedTab;
    private int scrollMouseX;
    private int scrollMouseY;
    private float zoom = 1.0f;
    private boolean isScrolling;
    protected int internalWidth;
    protected int internalHeight;
    public static int uiScaling;
    public static boolean showDebugCoordinates;
    public static boolean orderTabsAlphabetically;
    private GuiBetterAdvancement advConnectedToMouse = null;

    public GuiScreenBetterAdvancements(ClientAdvancementManager clientAdvancementManager) {
        this.clientAdvancementManager = clientAdvancementManager;
    }

    public void func_73866_w_() {
        this.internalHeight = this.field_146295_m * uiScaling / 100;
        this.internalWidth = this.field_146294_l * uiScaling / 100;
        this.tabs.clear();
        this.selectedTab = null;
        this.clientAdvancementManager.func_192798_a((ClientAdvancementManager.IListener)this);
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            this.clientAdvancementManager.func_194230_a(this.tabs.values().iterator().next().getAdvancement(), true);
        } else {
            this.clientAdvancementManager.func_194230_a(this.selectedTab == null ? null : this.selectedTab.getAdvancement(), true);
        }
    }

    public void func_146281_b() {
        this.clientAdvancementManager.func_192798_a(null);
        NetHandlerPlayClient nethandlerplayclient = this.field_146297_k.func_147114_u();
        if (nethandlerplayclient != null) {
            nethandlerplayclient.func_147297_a((Packet)CPacketSeenAdvancements.func_194164_a());
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            int left = 30 + (this.field_146294_l - this.internalWidth) / 2;
            int top = 40 + (this.field_146295_m - this.internalHeight) / 2;
            for (GuiBetterAdvancementTab guiBetterAdvancementTab : this.tabs.values()) {
                if (!guiBetterAdvancementTab.isMouseOver(left, top, this.internalWidth - 60, this.internalHeight - top - 30, mouseX, mouseY)) continue;
                this.clientAdvancementManager.func_194230_a(guiBetterAdvancementTab.getAdvancement(), true);
                break;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheel = Mouse.getDWheel();
        if (wheel < 0 && this.zoom > 1.0f) {
            this.zoom -= 0.2f;
        } else if (wheel > 0 && this.zoom < 2.0f) {
            this.zoom += 0.2f;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == this.field_146297_k.field_71474_y.field_194146_ao.func_151463_i()) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int left = 30 + (this.field_146294_l - this.internalWidth) / 2;
        int top = 40 + (this.field_146295_m - this.internalHeight) / 2;
        if (Mouse.isButtonDown((int)0) && !this.isScrolling) {
            if (this.advConnectedToMouse == null) {
                boolean inGui;
                boolean bl = inGui = mouseX < left + this.internalWidth - 60 - 9 && mouseX > left + 9 && mouseY < top + this.internalHeight - 40 + 1 && mouseY > top + 18;
                if (this.selectedTab != null && inGui) {
                    for (Object guiBetterAdvancement : this.selectedTab.guis.values()) {
                        if (!guiBetterAdvancement.isMouseOver(this.selectedTab.scrollX, this.selectedTab.scrollY, mouseX - left - 9, mouseY - top - 18) || !guiBetterAdvancement.betterDisplayInfo.allowDragging()) continue;
                        this.advConnectedToMouse = guiBetterAdvancement;
                        break;
                    }
                }
            } else {
                int moveX = mouseX - this.scrollMouseX;
                int moveY = mouseY - this.scrollMouseY;
                this.advConnectedToMouse.x += moveX;
                this.advConnectedToMouse.y += moveY;
            }
        } else {
            if (this.advConnectedToMouse != null) {
                AdvancementMovedEvent event = new AdvancementMovedEvent(this.advConnectedToMouse);
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
            this.advConnectedToMouse = null;
        }
        if (Mouse.isButtonDown((int)0)) {
            if (this.advConnectedToMouse == null) {
                if (!this.isScrolling) {
                    this.isScrolling = true;
                } else if (this.selectedTab != null) {
                    this.selectedTab.scroll(mouseX - this.scrollMouseX, mouseY - this.scrollMouseY, this.internalWidth - 60 - 27, this.internalHeight - 40 - 30 - 27);
                }
            }
            this.scrollMouseX = mouseX;
            this.scrollMouseY = mouseY;
        } else {
            this.isScrolling = false;
        }
        int right = this.internalWidth - 30 + (this.field_146294_l - this.internalWidth) / 2;
        int bottom = this.internalHeight - 30 + (this.field_146295_m - this.internalHeight) / 2;
        this.func_146276_q_();
        this.renderInside(mouseX, mouseY, left, top, right, bottom);
        this.renderWindow(left, top, right, bottom);
        if (this.advConnectedToMouse == null) {
            this.renderToolTips(mouseX, mouseY, left, top, right, bottom);
        }
        if (this.advConnectedToMouse != null) {
            for (GuiBetterAdvancement guiBetterAdvancement : this.selectedTab.guis.values()) {
                if (guiBetterAdvancement == this.advConnectedToMouse) continue;
                int x1 = guiBetterAdvancement.x + left + 9 + this.selectedTab.scrollX + 3;
                int x2 = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3;
                int y1 = guiBetterAdvancement.y + top + 18 + this.selectedTab.scrollY;
                int y2 = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY;
                int centerX1 = guiBetterAdvancement.x + left + 9 + this.selectedTab.scrollX + 3 + 13;
                int centerX2 = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3 + 13;
                int centerY1 = guiBetterAdvancement.y + top + 18 + this.selectedTab.scrollY + 13;
                int centerY2 = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY + 13;
                double degrees = Math.toDegrees(Math.atan2(centerX1 - centerX2, centerY1 - centerY2));
                if (degrees < 0.0) {
                    degrees += 360.0;
                }
                if (guiBetterAdvancement.x == this.advConnectedToMouse.x) {
                    if (y1 > y2) {
                        RenderUtil.drawRect(x1, y1 + 26 - 1, x2, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2, y1 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x2, y1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2 + 26 - 1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2, x2, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2 + 26 - 1, y2, 1.0, 65280);
                    } else {
                        RenderUtil.drawRect(x1, y2 + 26 - 1, x2, y1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2 + 26 - 1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2, x2, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2, y1 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x2, y1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2 + 26 - 1, x2 + 26 - 1, y1, 1.0, 65280);
                    }
                }
                if (guiBetterAdvancement.y == this.advConnectedToMouse.y) {
                    if (x1 > x2) {
                        RenderUtil.drawRect(x2, y1, x1 + 26 - 1, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1, y1, x1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x1 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2, y1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2 + 26 - 1, y1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2, y1 + 26 - 1, x1 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                    } else {
                        RenderUtil.drawRect(x2 + 26 - 1, y1, x1, y2, 1.0, 65280);
                        RenderUtil.drawRect(x2, y1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2 + 26 - 1, y1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1, y1, x1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x1 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2 + 26 - 1, y1 + 26 - 1, x1, y2 + 26 - 1, 1.0, 65280);
                    }
                }
                if (degrees != 45.0 && degrees != 135.0 && degrees != 225.0 && degrees != 315.0) continue;
                RenderUtil.drawRect(x1, y1, x1 + 26 - 1, y1, 1.0, 65280);
                RenderUtil.drawRect(x1, y1 + 26 - 1, x1 + 26 - 1, y1 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x1, y1, x1, y1 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x1 + 26 - 1, y1, x1 + 26 - 1, y1 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x2, y2, x2 + 26 - 1, y2, 1.0, 65280);
                RenderUtil.drawRect(x2, y2 + 26 - 1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x2, y2, x2, y2 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x2 + 26 - 1, y2, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                if (degrees == 45.0 || degrees == 225.0) {
                    RenderUtil.drawRect(x1, y1 + 26 - 1, x2, y2 + 26 - 1, 1.0, 65280);
                    RenderUtil.drawRect(x1 + 26 - 1, y1, x2 + 26 - 1, y2, 1.0, 65280);
                    continue;
                }
                if (degrees != 135.0 && degrees != 315.0) continue;
                RenderUtil.drawRect(x1, y1, x2, y2, 1.0, 65280);
                RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
            }
        }
        if (showDebugCoordinates && this.selectedTab != null && mouseX < this.internalWidth - 30 - 9 && mouseX > 39 && mouseY < this.internalHeight - top + 1 && mouseY > top + 18) {
            if (this.advConnectedToMouse != null) {
                int currentX = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3 + 1;
                int currentY = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY - this.field_146289_q.field_78288_b + 1;
                this.field_146289_q.func_175065_a(this.advConnectedToMouse.x + "," + this.advConnectedToMouse.y, (float)currentX, (float)currentY, 0, false);
            } else {
                int xMouse = mouseX - left - 9;
                int yMouse = mouseY - top - 18;
                int currentX = xMouse - this.selectedTab.scrollX - 3 - 1;
                int currentY = yMouse - this.selectedTab.scrollY - 1;
                this.field_146289_q.func_175065_a(currentX + "," + currentY, (float)mouseX, (float)(mouseY - this.field_146289_q.field_78288_b), 0, false);
            }
        }
    }

    private void renderInside(int mouseX, int mouseY, int left, int top, int right, int bottom) {
        GuiBetterAdvancementTab guiBetterAdvancementTab = this.selectedTab;
        int boxLeft = left + 9;
        int boxTop = top + 18;
        int boxRight = right - 9;
        int boxBottom = bottom - 9;
        int width = boxRight - boxLeft;
        int height = boxBottom - boxTop;
        if (guiBetterAdvancementTab == null) {
            GuiScreenBetterAdvancements.func_73734_a((int)boxLeft, (int)boxTop, (int)boxRight, (int)boxBottom, (int)-16777216);
            String s = I18n.func_135052_a((String)"advancements.empty", (Object[])new Object[0]);
            int i = this.field_146289_q.func_78256_a(s);
            this.field_146289_q.func_78276_b(s, boxLeft + (width - i) / 2, boxTop + height / 2 - this.field_146289_q.field_78288_b, -1);
            this.field_146289_q.func_78276_b(":(", boxLeft + (width - this.field_146289_q.func_78256_a(":(")) / 2, boxTop + height / 2 + this.field_146289_q.field_78288_b, -1);
        } else {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)boxLeft, (float)boxTop, (float)-400.0f);
            GlStateManager.func_179126_j();
            guiBetterAdvancementTab.drawContents(width, height);
            GlStateManager.func_179121_F();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179097_i();
        }
    }

    public void renderWindow(int left, int top, int right, int bottom) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        RenderHelper.func_74518_a();
        this.field_146297_k.func_110434_K().func_110577_a(Resources.Gui.WINDOW);
        this.func_73729_b(left, top, 0, 0, 30, 30);
        RenderUtil.renderRepeating((Gui)this, left + 30, top, this.internalWidth - 30 - 60 - 30, 30, 30, 0, 192, 30);
        this.func_73729_b(right - 30, top, 222, 0, 30, 30);
        RenderUtil.renderRepeating((Gui)this, left, top + 30, 30, bottom - top - 60, 0, 30, 30, 80);
        RenderUtil.renderRepeating((Gui)this, right - 30, top + 30, 30, bottom - top - 60, 222, 30, 30, 80);
        this.func_73729_b(left, bottom - 30, 0, 110, 30, 30);
        RenderUtil.renderRepeating((Gui)this, left + 30, bottom - 30, this.internalWidth - 30 - 60 - 30, 30, 30, 110, 192, 30);
        this.func_73729_b(right - 30, bottom - 30, 222, 110, 30, 30);
        if (this.tabs.size() > 1) {
            this.field_146297_k.func_110434_K().func_110577_a(Resources.Gui.TABS);
            int width = right - left;
            int height = bottom - top;
            for (GuiBetterAdvancementTab tab : this.tabs.values()) {
                tab.drawTab(left, top, width, height, tab == this.selectedTab);
            }
            GlStateManager.func_179091_B();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderHelper.func_74520_c();
            for (GuiBetterAdvancementTab tab : this.tabs.values()) {
                tab.drawIcon(left, top, width, height, this.field_146296_j);
            }
            GlStateManager.func_179084_k();
        }
        String windowTitle = I18n.func_135052_a((String)"gui.advancements", (Object[])new Object[0]);
        if (this.selectedTab != null) {
            windowTitle = windowTitle + " - " + this.selectedTab.getTitle();
        }
        this.field_146289_q.func_78276_b(windowTitle, left + 8, top + 6, 0x404040);
    }

    private void renderToolTips(int mouseX, int mouseY, int left, int top, int right, int bottom) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedTab != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179126_j();
            GlStateManager.func_179109_b((float)(left + 9), (float)(top + 18), (float)400.0f);
            this.selectedTab.drawToolTips(mouseX - left - 9, mouseY - top - 18, left, top, right - left - 18, bottom - top - 27);
            GlStateManager.func_179097_i();
            GlStateManager.func_179121_F();
        }
        int width = right - left;
        int height = bottom - top;
        if (this.tabs.size() > 1) {
            for (GuiBetterAdvancementTab tab : this.tabs.values()) {
                if (!tab.isMouseOver(left, top, width, height, mouseX, mouseY)) continue;
                this.func_146279_a(tab.getTitle(), mouseX, mouseY);
            }
        }
    }

    public void func_191931_a(@Nonnull Advancement advancement) {
        GuiBetterAdvancementTab guiBetterAdvancementTab = GuiBetterAdvancementTab.create(this.field_146297_k, this, this.tabs.size(), advancement, this.internalWidth - 60, this.internalHeight - 40 - 30);
        if (guiBetterAdvancementTab != null) {
            this.tabs.put(advancement, guiBetterAdvancementTab);
        }
    }

    public void func_191928_b(@Nonnull Advancement advancementIn) {
    }

    public void func_191932_c(@Nonnull Advancement advancementIn) {
        GuiBetterAdvancementTab guiBetterAdvancementTab = this.getTab(advancementIn);
        if (guiBetterAdvancementTab != null) {
            guiBetterAdvancementTab.addAdvancement(advancementIn);
        }
    }

    public void func_191929_d(@Nonnull Advancement advancementIn) {
    }

    public void func_191933_a(@Nonnull Advancement advancement, @Nonnull AdvancementProgress advancementProgress) {
        GuiBetterAdvancement guiBetterAdvancement = this.getAdvancementGui(advancement);
        if (guiBetterAdvancement != null) {
            guiBetterAdvancement.getAdvancementProgress(advancementProgress);
        }
    }

    public void func_193982_e(@Nullable Advancement advancement) {
        this.selectedTab = this.tabs.get(advancement);
    }

    public void func_191930_a() {
        this.tabs.clear();
        this.selectedTab = null;
    }

    @Nullable
    public GuiBetterAdvancement getAdvancementGui(Advancement advancement) {
        GuiBetterAdvancementTab guiBetterAdvancementTab = this.getTab(advancement);
        return guiBetterAdvancementTab == null ? null : guiBetterAdvancementTab.getAdvancementGui(advancement);
    }

    @Nullable
    private GuiBetterAdvancementTab getTab(@Nonnull Advancement advancement) {
        while (advancement.func_192070_b() != null) {
            advancement = advancement.func_192070_b();
        }
        return this.tabs.get(advancement);
    }

    static {
        showDebugCoordinates = false;
        orderTabsAlphabetically = false;
    }
}

