/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecturecraft.repackage.com.elytradev.concrete.resgen;

import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.common.ConcreteLog;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.resgen.BlockStateResourceProvider;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.resgen.ConcreteResourcePack;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.resgen.EnumResourceType;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.resgen.IResourceHolder;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.resgen.ResourceProvider;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class BlockModelResourceProvider
extends ResourceProvider {
    private static String SIMPLE_BLOCK_MODEL;

    public BlockModelResourceProvider(ConcreteResourcePack resourcePack) {
        super(resourcePack);
    }

    @Override
    public boolean canProvide(String name) {
        return name.startsWith("assets/" + this.modID + "/models/block/") && name.endsWith(".json");
    }

    @Override
    public InputStream provide(String name) {
        ResourceLocation resource;
        String blockID = name.substring(name.lastIndexOf("/") + 1, name.lastIndexOf("."));
        Block blockFromLocation = Block.func_149684_b((String)(this.modID + ":" + blockID));
        String textureLocation = this.modID + ":blocks/" + blockID;
        Integer meta = this.resourcePack.getMetaFromName(name);
        if (blockFromLocation instanceof IResourceHolder && (resource = ((IResourceHolder)blockFromLocation).getResource(EnumResourceType.TEXTURE, meta)) != null) {
            textureLocation = resource.toString();
        }
        String simpleBlockJSON = SIMPLE_BLOCK_MODEL;
        simpleBlockJSON = simpleBlockJSON.replaceAll("%ALL%", textureLocation);
        return IOUtils.toInputStream((String)simpleBlockJSON);
    }

    static {
        try {
            SIMPLE_BLOCK_MODEL = Resources.toString((URL)BlockStateResourceProvider.class.getResource("concreteblockmodel.json"), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            ConcreteLog.error("Caught IOException loading concrete block model, things will definitely not work.", (Throwable)e);
        }
    }
}

