/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common.tile;

import com.elytradev.architecture.common.shape.Shape;
import com.elytradev.architecture.common.shape.ShapePage;
import com.elytradev.architecture.common.tile.TileArchitectureInventory;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class TileSawbench
extends TileArchitectureInventory {
    public static final int materialSlot = 0;
    public static final int resultSlot = 1;
    public static final int[] materialSideSlots = new int[]{0};
    public static final int[] resultSideSlots = new int[]{1};
    public static boolean allowAutomation = false;
    public static ShapePage[] pages = new ShapePage[]{new ShapePage("Roofing", Shape.ROOF_TILE, Shape.ROOF_OUTER_CORNER, Shape.ROOF_INNER_CORNER, Shape.ROOF_RIDGE, Shape.ROOF_SMART_RIDGE, Shape.ROOF_VALLEY, Shape.ROOF_SMART_VALLEY, Shape.ROOF_OVERHANG, Shape.ROOF_OVERHANG_OUTER_CORNER, Shape.ROOF_OVERHANG_INNER_CORNER, Shape.ROOF_OVERHANG_GABLE_LH, Shape.ROOF_OVERHANG_GABLE_RH, Shape.ROOF_OVERHANG_GABLE_END_LH, Shape.ROOF_OVERHANG_GABLE_END_RH, Shape.ROOF_OVERHANG_RIDGE, Shape.ROOF_OVERHANG_VALLEY, Shape.BEVELLED_OUTER_CORNER, Shape.BEVELLED_INNER_CORNER), new ShapePage("Rounded", Shape.CYLINDER, Shape.CYLINDER_HALF, Shape.CYLINDER_QUARTER, Shape.CYLINDER_LARGE_QUARTER, Shape.ANTICYLINDER_LARGE_QUARTER, Shape.PILLAR, Shape.POST, Shape.POLE, Shape.SPHERE_FULL, Shape.SPHERE_HALF, Shape.SPHERE_QUARTER, Shape.SPHERE_EIGHTH, Shape.SPHERE_EIGHTH_LARGE, Shape.SPHERE_EIGHTH_LARGE_REV), new ShapePage("Classical", Shape.PILLAR_BASE, Shape.PILLAR, Shape.DORIC_CAPITAL, Shape.DORIC_TRIGLYPH, Shape.DORIC_TRIGLYPH_CORNER, Shape.DORIC_METOPE, Shape.IONIC_CAPITAL, Shape.CORINTHIAN_CAPITAL, Shape.ARCHITRAVE, Shape.ARCHITRAVE_CORNER, Shape.CORNICE_LH, Shape.CORNICE_RH, Shape.CORNICE_END_LH, Shape.CORNICE_END_RH, Shape.CORNICE_RIDGE, Shape.CORNICE_VALLEY, Shape.CORNICE_BOTTOM), new ShapePage("Window", Shape.WINDOW_FRAME, Shape.WINDOW_CORNER, Shape.WINDOW_MULLION), new ShapePage("Arches", Shape.ARCH_D_1, Shape.ARCH_D_2, Shape.ARCH_D_3_A, Shape.ARCH_D_3_B, Shape.ARCH_D_3_C, Shape.ARCH_D_4_A, Shape.ARCH_D_4_B, Shape.ARCH_D_4_C), new ShapePage("Railings", Shape.BALUSTRADE_PLAIN, Shape.BALUSTRADE_PLAIN_OUTER_CORNER, Shape.BALUSTRADE_PLAIN_INNER_CORNER, Shape.BALUSTRADE_PLAIN_WITH_NEWEL, Shape.BALUSTRADE_PLAIN_END, Shape.BANISTER_PLAIN_TOP, Shape.BANISTER_PLAIN, Shape.BANISTER_PLAIN_BOTTOM, Shape.BANISTER_PLAIN_END, Shape.BANISTER_PLAIN_INNER_CORNER, Shape.BALUSTRADE_FANCY, Shape.BALUSTRADE_FANCY_CORNER, Shape.BALUSTRADE_FANCY_WITH_NEWEL, Shape.BALUSTRADE_FANCY_NEWEL, Shape.BANISTER_FANCY_TOP, Shape.BANISTER_FANCY, Shape.BANISTER_FANCY_BOTTOM, Shape.BANISTER_FANCY_END, Shape.BANISTER_FANCY_NEWEL_TALL), new ShapePage("Other", Shape.CLADDING_SHEET, Shape.SLAB, Shape.STAIRS, Shape.STAIRS_OUTER_CORNER, Shape.STAIRS_INNER_CORNER)};
    public IInventory inventory = new InventoryBasic("Items", false, 2);
    public int selectedPage = 0;
    public int[] selectedSlots = new int[pages.length];
    public boolean pendingMaterialUsage = false;

    public Shape getSelectedShape() {
        int slot;
        if (this.selectedPage >= 0 && this.selectedPage < pages.length && (slot = this.selectedSlots[this.selectedPage]) >= 0 && slot < pages[this.selectedPage].size()) {
            return pages[this.selectedPage].get(slot);
        }
        return null;
    }

    @Override
    protected IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        this.updateResultSlot();
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        if (slot == 1) {
            this.usePendingMaterial();
        }
        ItemStack result = super.func_70298_a(slot, amount);
        this.updateResultSlot();
        return result;
    }

    public ItemStack usePendingMaterial() {
        ItemStack origMaterialStack = this.func_70301_a(0).func_77946_l();
        if (this.pendingMaterialUsage) {
            this.pendingMaterialUsage = false;
            this.inventory.func_70298_a(0, this.materialMultiple());
        }
        return origMaterialStack;
    }

    public void returnUnusedMaterial(ItemStack origMaterialStack) {
        if (!this.pendingMaterialUsage) {
            ItemStack materialStack = this.func_70301_a(0);
            ItemStack resultStack = this.func_70301_a(1);
            int m = this.materialMultiple();
            int n = this.resultMultiple();
            if (!resultStack.func_190926_b() && resultStack.func_190916_E() == n) {
                if (!materialStack.func_190926_b()) {
                    materialStack.func_190917_f(m);
                } else {
                    materialStack = origMaterialStack;
                    materialStack.func_190920_e(m);
                }
                this.inventory.func_70299_a(0, materialStack);
                this.pendingMaterialUsage = true;
            }
        }
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        if (side == 1) {
            return materialSideSlots;
        }
        return resultSideSlots;
    }

    @Override
    public void onAddedToWorld() {
    }

    @Override
    public void func_145839_a(NBTTagCompound tc) {
        super.func_145839_a(tc);
        this.selectedPage = tc.func_74762_e("Page");
        int[] ss = tc.func_74759_k("Slots");
        if (ss != null) {
            for (int page = 0; page < pages.length; ++page) {
                int slot = page < ss.length ? ss[page] : 0;
                this.selectedSlots[page] = slot >= 0 && slot < pages[page].size() ? slot : 0;
            }
        }
        this.pendingMaterialUsage = tc.func_74767_n("PMU");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tc) {
        super.func_189515_b(tc);
        tc.func_74768_a("Page", this.selectedPage);
        tc.func_74783_a("Slots", this.selectedSlots);
        tc.func_74757_a("PMU", this.pendingMaterialUsage);
        return tc;
    }

    public void setSelectedShape(int page, int slot) {
        if (page >= 0 && page < pages.length) {
            this.selectedPage = page;
            if (slot >= 0 && slot < pages[this.selectedPage].size()) {
                this.selectedSlots[this.selectedPage] = slot;
                this.func_70296_d();
                this.updateResultSlot();
                this.sendTileEntityUpdate();
            }
        }
    }

    void updateResultSlot() {
        ItemStack oldResult = this.func_70301_a(1).func_77946_l();
        if (oldResult.func_190926_b() || this.pendingMaterialUsage) {
            ItemStack resultStack = this.makeResultStack();
            if (!ItemStack.func_77989_b((ItemStack)resultStack, (ItemStack)oldResult)) {
                this.inventory.func_70299_a(1, resultStack);
            }
            this.pendingMaterialUsage = !resultStack.func_190926_b();
        }
    }

    protected ItemStack makeResultStack() {
        Block materialBlock;
        Item materialItem;
        ItemStack materialStack;
        Shape resultShape = this.getSelectedShape();
        if (resultShape != null && !(materialStack = this.func_70301_a(0)).func_190926_b() && materialStack.func_190916_E() >= resultShape.materialUsed && (materialItem = materialStack.func_77973_b()) instanceof ItemBlock && this.isAcceptableMaterial(materialBlock = Block.func_149634_a((Item)materialItem))) {
            return resultShape.kind.newStack(resultShape, materialBlock, materialStack.func_77952_i(), resultShape.itemsProduced);
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isAcceptableMaterial(Block block) {
        String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
        if (block == Blocks.field_150359_w || block == Blocks.field_150399_cn || block instanceof BlockSlab || name.startsWith("chisel:glass")) {
            return true;
        }
        return block.func_176223_P().func_185917_h() && !block.func_149716_u();
    }

    public int materialMultiple() {
        Shape shape;
        Block materialBlock;
        int factor = 1;
        ItemStack materialStack = this.func_70301_a(0);
        if (!materialStack.func_190926_b() && (materialBlock = Block.func_149634_a((Item)materialStack.func_77973_b())) instanceof BlockSlab) {
            factor = 2;
        }
        if ((shape = this.getSelectedShape()) != null) {
            return factor * shape.materialUsed;
        }
        return 0;
    }

    public int resultMultiple() {
        Shape shape = this.getSelectedShape();
        if (shape != null) {
            return shape.itemsProduced;
        }
        return 0;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return slot == 0;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return allowAutomation && slot == 1;
        }
        return slot == 0;
    }
}

