/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common.shape;

import com.elytradev.architecture.common.ArchitectureLog;
import com.elytradev.architecture.common.helpers.Profile;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecture.common.helpers.Vector3;
import com.elytradev.architecture.common.shape.ShapeKind;
import com.elytradev.architecture.common.shape.ShapeSymmetry;
import com.elytradev.architecture.common.shape.WindowShapeKinds;
import com.elytradev.architecture.common.tile.TileShape;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public enum Shape {
    ROOF_TILE(0, "Roof Tile", ShapeKind.Roof, ShapeSymmetry.BILATERAL, 1, 2, 207),
    ROOF_OUTER_CORNER(1, "Roof Outer Corner", ShapeKind.Roof, ShapeSymmetry.UNILATERAL, 1, 3, 79),
    ROOF_INNER_CORNER(2, "Roof Inner Corner", ShapeKind.Roof, ShapeSymmetry.UNILATERAL, 2, 3, 223),
    ROOF_RIDGE(3, "Gabled Roof Ridge", ShapeKind.Roof, ShapeSymmetry.BILATERAL, 1, 4, 15),
    ROOF_SMART_RIDGE(4, "Hip Roof Ridge", ShapeKind.Roof, ShapeSymmetry.QUADRILATERAL, 1, 2, 15),
    ROOF_VALLEY(5, "Gabled Roof Valley", ShapeKind.Roof, ShapeSymmetry.BILATERAL, 1, 2, 255),
    ROOF_SMART_VALLEY(6, "Hip Roof Valley", ShapeKind.Roof, ShapeSymmetry.QUADRILATERAL, 1, 1, 255),
    ROOF_OVERHANG(7, "Roof Overhang", ShapeKind.Model("roof_overhang"), ShapeSymmetry.BILATERAL, 1, 2, 207),
    ROOF_OVERHANG_OUTER_CORNER(8, "Roof Overhang Outer Corner", ShapeKind.Model("roof_overhang_outer_corner"), ShapeSymmetry.UNILATERAL, 1, 3, 79),
    ROOF_OVERHANG_INNER_CORNER(9, "Roof Overhang Inner Corner", ShapeKind.Model("roof_overhang_inner_corner"), ShapeSymmetry.UNILATERAL, 2, 3, 223),
    CYLINDER(10, "Cylinder", ShapeKind.Model("cylinder_full_r8h16"), ShapeSymmetry.QUADRILATERAL, 1, 1, 255),
    CYLINDER_HALF(11, "Half Cylinder", ShapeKind.Model("cylinder_half_r8h16"), ShapeSymmetry.BILATERAL, 1, 1, 204),
    CYLINDER_QUARTER(12, "Quarter Cylinder", ShapeKind.Model("cylinder_quarter_r8h16"), ShapeSymmetry.UNILATERAL, 1, 1, 68),
    CYLINDER_LARGE_QUARTER(13, "Round Outer Corner", ShapeKind.Model("cylinder_quarter_r16h16"), ShapeSymmetry.UNILATERAL, 1, 1, 255),
    ANTICYLINDER_LARGE_QUARTER(14, "Round Inner Corner", ShapeKind.Model("round_inner_corner"), ShapeSymmetry.UNILATERAL, 1, 2, 221),
    PILLAR(15, "Round Pillar", ShapeKind.Model("cylinder_r6h16"), ShapeSymmetry.QUADRILATERAL, 1, 1, 262),
    POST(16, "Round Post", ShapeKind.Model("cylinder_r4h16"), ShapeSymmetry.QUADRILATERAL, 1, 4, 260),
    POLE(17, "Round Pole", ShapeKind.Model("cylinder_r2h16"), ShapeSymmetry.QUADRILATERAL, 1, 16, 258),
    BEVELLED_OUTER_CORNER(18, "Bevelled Outer Corner", ShapeKind.Model("bevelled_outer_corner"), ShapeSymmetry.UNILATERAL, 1, 3, 79),
    BEVELLED_INNER_CORNER(19, "Bevelled Inner Corner", ShapeKind.Model("bevelled_inner_corner"), ShapeSymmetry.UNILATERAL, 1, 1, 223),
    PILLAR_BASE(20, "Round Pillar Base", ShapeKind.Model("pillar_base"), ShapeSymmetry.QUADRILATERAL, 1, 1, 255),
    DORIC_CAPITAL(21, "Doric Capital", ShapeKind.Model("doric_capital"), ShapeSymmetry.QUADRILATERAL, 1, 1, 255),
    IONIC_CAPITAL(22, "Ionic capital", ShapeKind.Model("ionic_capital"), ShapeSymmetry.BILATERAL, 1, 1, 255),
    CORINTHIAN_CAPITAL(23, "Corinthian capital", ShapeKind.Model("corinthian_capital"), ShapeSymmetry.QUADRILATERAL, 1, 1, 255),
    DORIC_TRIGLYPH(24, "Triglyph", ShapeKind.Model("doric_triglyph", (Object[])Profile.Generic.lrStraight), ShapeSymmetry.BILATERAL, 1, 1, 255),
    DORIC_TRIGLYPH_CORNER(25, "Triglyph Corner", ShapeKind.Model("doric_triglyph_corner", (Object[])Profile.Generic.lrCorner), ShapeSymmetry.BILATERAL, 1, 1, 255),
    DORIC_METOPE(26, "Metope", ShapeKind.Model("doric_metope", (Object[])Profile.Generic.lrStraight), ShapeSymmetry.BILATERAL, 1, 1, 255),
    ARCHITRAVE(27, "Architrave", ShapeKind.Model("architrave", (Object[])Profile.Generic.lrStraight), ShapeSymmetry.BILATERAL, 1, 1, 255),
    ARCHITRAVE_CORNER(28, "Architrave Corner", ShapeKind.Model("architrave_corner", (Object[])Profile.Generic.lrCorner), ShapeSymmetry.UNILATERAL, 1, 1, 255),
    WINDOW_FRAME(30, "Window Frame", WindowShapeKinds.PlainWindow, ShapeSymmetry.BILATERAL, 1, 4, 514),
    WINDOW_CORNER(31, "Window Corner", WindowShapeKinds.CornerWindow, ShapeSymmetry.UNILATERAL, 1, 2, 514),
    WINDOW_MULLION(32, "Window Mullion", WindowShapeKinds.MullionWindow, ShapeSymmetry.BILATERAL, 1, 2, 514),
    SPHERE_FULL(33, "Sphere", ShapeKind.Model("sphere_full_r8"), ShapeSymmetry.QUADRILATERAL, 1, 1, 255),
    SPHERE_HALF(34, "Hemisphere", ShapeKind.Model("sphere_half_r8"), ShapeSymmetry.QUADRILATERAL, 1, 2, 15),
    SPHERE_QUARTER(35, "Quarter Sphere", ShapeKind.Model("sphere_quarter_r8"), ShapeSymmetry.BILATERAL, 1, 4, 12),
    SPHERE_EIGHTH(36, "Quarter Hemisphere", ShapeKind.Model("sphere_eighth_r8"), ShapeSymmetry.UNILATERAL, 1, 8, 4),
    SPHERE_EIGHTH_LARGE(37, "Round Outer Corner Cap", ShapeKind.Model("sphere_eighth_r16"), ShapeSymmetry.UNILATERAL, 1, 1, 255),
    SPHERE_EIGHTH_LARGE_REV(38, "Round Inner Corner Cap", ShapeKind.Model("sphere_eighth_r16_rev"), ShapeSymmetry.UNILATERAL, 1, 1, 223),
    ROOF_OVERHANG_GABLE_LH(40, "Gable Overhang LH", ShapeKind.Model("roof_overhang_gable_lh"), ShapeSymmetry.BILATERAL, 1, 4, 72),
    ROOF_OVERHANG_GABLE_RH(41, "Gable Overhang RH", ShapeKind.Model("roof_overhang_gable_rh"), ShapeSymmetry.BILATERAL, 1, 4, 132),
    ROOF_OVERHANG_GABLE_END_LH(42, "Gable Overhang LH End", ShapeKind.Model("roof_overhang_gable_end_lh"), ShapeSymmetry.BILATERAL, 1, 4, 72),
    ROOF_OVERHANG_GABLE_END_RH(43, "Gable Overhang RH End", ShapeKind.Model("roof_overhang_gable_end_rh"), ShapeSymmetry.BILATERAL, 1, 4, 72),
    ROOF_OVERHANG_RIDGE(44, "Ridge Overhang", ShapeKind.Model("roof_overhang_gable_ridge"), ShapeSymmetry.BILATERAL, 1, 4, 12),
    ROOF_OVERHANG_VALLEY(45, "Valley Overhang", ShapeKind.Model("roof_overhang_gable_valley"), ShapeSymmetry.BILATERAL, 1, 4, 204),
    CORNICE_LH(50, "Cornice LH", ShapeKind.Model("cornice_lh"), ShapeSymmetry.BILATERAL, 1, 4, 72),
    CORNICE_RH(51, "Cornice RH", ShapeKind.Model("cornice_rh"), ShapeSymmetry.BILATERAL, 1, 4, 132),
    CORNICE_END_LH(52, "Cornice LH End", ShapeKind.Model("cornice_end_lh"), ShapeSymmetry.BILATERAL, 1, 4, 72),
    CORNICE_END_RH(53, "Cornice RH End", ShapeKind.Model("cornice_end_rh"), ShapeSymmetry.BILATERAL, 1, 4, 72),
    CORNICE_RIDGE(54, "Cornice Ridge", ShapeKind.Model("cornice_ridge"), ShapeSymmetry.BILATERAL, 1, 4, 12),
    CORNICE_VALLEY(55, "Cornice Valley", ShapeKind.Model("cornice_valley"), ShapeSymmetry.BILATERAL, 1, 4, 204),
    CORNICE_BOTTOM(56, "Cornice Bottom", ShapeKind.Model("cornice_bottom"), ShapeSymmetry.BILATERAL, 1, 4, 12),
    CLADDING_SHEET(60, "Cladding", ShapeKind.Cladding, null, 1, 16, 0),
    ARCH_D_1(61, "Arch Diameter 1", ShapeKind.Model("arch_d1"), ShapeSymmetry.BILATERAL, 1, 1, 255, 1),
    ARCH_D_2(62, "Arch Diameter 2", ShapeKind.Model("arch_d2"), ShapeSymmetry.BILATERAL, 1, 2, 252, 1),
    ARCH_D_3_A(63, "Arch Diameter 3 Part A", ShapeKind.Model("arch_d3a"), ShapeSymmetry.BILATERAL, 1, 2, 204, 1),
    ARCH_D_3_B(64, "Arch Diameter 3 Part B", ShapeKind.Model("arch_d3b"), ShapeSymmetry.BILATERAL, 1, 1, 252, 1),
    ARCH_D_3_C(65, "Arch Diameter 3 Part C", ShapeKind.Model("arch_d3c"), ShapeSymmetry.BILATERAL, 1, 1, 255, 1),
    ARCH_D_4_A(66, "Arch Diameter 4 Part A", ShapeKind.Model("arch_d4a"), ShapeSymmetry.BILATERAL, 1, 2, 204, 1),
    ARCH_D_4_B(67, "Arch Diameter 4 Part B", ShapeKind.Model("arch_d4b"), ShapeSymmetry.BILATERAL, 1, 1, 252, 1),
    ARCH_D_4_C(68, "Arch Diameter 4 Part C", ShapeKind.Model("arch_d4c"), ShapeSymmetry.BILATERAL, 1, 2, 0, 1),
    BANISTER_PLAIN_BOTTOM(70, "Plain Banister Bottom Transition", ShapeKind.Banister("balustrade_stair_plain_bottom"), ShapeSymmetry.BILATERAL, 1, 10, 0, 2),
    BANISTER_PLAIN(71, "Plain Banister", ShapeKind.Banister("balustrade_stair_plain"), ShapeSymmetry.BILATERAL, 1, 10, 0, 2),
    BANISTER_PLAIN_TOP(72, "Plain Banister Top Transition", ShapeKind.Banister("balustrade_stair_plain_top"), ShapeSymmetry.BILATERAL, 1, 10, 0, 2),
    BALUSTRADE_FANCY(73, "Fancy Balustrade", ShapeKind.Model("balustrade_fancy"), ShapeSymmetry.BILATERAL, 1, 5, 0),
    BALUSTRADE_FANCY_CORNER(74, "Fancy Corner Balustrade", ShapeKind.Model("balustrade_fancy_corner"), ShapeSymmetry.UNILATERAL, 1, 2, 0),
    BALUSTRADE_FANCY_WITH_NEWEL(75, "Fancy Balustrade with Newel", ShapeKind.Model("balustrade_fancy_with_newel"), ShapeSymmetry.BILATERAL, 1, 3, 0),
    BALUSTRADE_FANCY_NEWEL(76, "Fancy Newel", ShapeKind.Model("balustrade_fancy_newel"), ShapeSymmetry.UNILATERAL, 1, 4, 0),
    BALUSTRADE_PLAIN(77, "Plain Balustrade", ShapeKind.Model("balustrade_plain"), ShapeSymmetry.BILATERAL, 1, 10, 0),
    BALUSTRADE_PLAIN_OUTER_CORNER(78, "Plain Outer Corner Balustrade", ShapeKind.Model("balustrade_plain_outer_corner"), ShapeSymmetry.UNILATERAL, 1, 4, 0),
    BALUSTRADE_PLAIN_WITH_NEWEL(79, "Plain Balustrade with Newel", ShapeKind.Model("balustrade_plain_with_newel"), ShapeSymmetry.BILATERAL, 1, 6, 0),
    BANISTER_PLAIN_END(80, "Plain Banister End", ShapeKind.Banister("balustrade_stair_plain_end"), ShapeSymmetry.BILATERAL, 1, 8, 0, 2),
    BANISTER_FANCY_NEWEL_TALL(81, "Tall Fancy Newel", ShapeKind.Model("balustrade_fancy_newel_tall"), ShapeSymmetry.UNILATERAL, 1, 2, 0),
    BALUSTRADE_PLAIN_INNER_CORNER(82, "Plain Inner Corner Balustrade", ShapeKind.Model("balustrade_plain_inner_corner"), ShapeSymmetry.UNILATERAL, 1, 8, 0),
    BALUSTRADE_PLAIN_END(83, "Plain Balustrade End", ShapeKind.Banister("balustrade_plain_end"), ShapeSymmetry.BILATERAL, 1, 8, 0, 2),
    BANISTER_FANCY_BOTTOM(84, "Fancy Banister Bottom Transition", ShapeKind.Banister("balustrade_stair_fancy_bottom"), ShapeSymmetry.BILATERAL, 1, 5, 0, 2),
    BANISTER_FANCY(85, "Fancy Banister", ShapeKind.Banister("balustrade_stair_fancy"), ShapeSymmetry.BILATERAL, 1, 5, 0, 2),
    BANISTER_FANCY_TOP(86, "Fancy Banister Top Transition", ShapeKind.Banister("balustrade_stair_fancy_top"), ShapeSymmetry.BILATERAL, 1, 5, 0, 2),
    BANISTER_FANCY_END(87, "Fancy Banister End", ShapeKind.Banister("balustrade_stair_fancy_end"), ShapeSymmetry.BILATERAL, 1, 2, 0, 2),
    BANISTER_PLAIN_INNER_CORNER(88, "Plain Banister Inner Corner", ShapeKind.Model("balustrade_stair_plain_inner_corner"), ShapeSymmetry.UNILATERAL, 1, 6, 0),
    SLAB(90, "Slab", ShapeKind.Model("slab"), ShapeSymmetry.QUADRILATERAL, 1, 2, 0),
    STAIRS(91, "Stairs", ShapeKind.Model("stairs", (Object[])Profile.Generic.lrStraight), ShapeSymmetry.BILATERAL, 3, 4, 0),
    STAIRS_OUTER_CORNER(92, "Stairs Outer Corner", ShapeKind.Model("stairs_outer_corner", (Object[])Profile.Generic.lrCorner), ShapeSymmetry.UNILATERAL, 2, 3, 0),
    STAIRS_INNER_CORNER(93, "Stairs Inner Corner", ShapeKind.Model("stairs_inner_corner", (Object[])Profile.Generic.rlCorner), ShapeSymmetry.UNILATERAL, 1, 1, 0);

    public static Shape[] values;
    public static boolean debugPlacement;
    protected static Map<Integer, Shape> idMap;
    public int id;
    public String title;
    public ShapeKind kind;
    public ShapeSymmetry symmetry;
    public int materialUsed;
    public int itemsProduced;
    public int occlusionMask;
    public int flags;

    private Shape(int id, String title, ShapeKind kind, ShapeSymmetry sym, int used, int made, int occ) {
        this(id, title, kind, sym, used, made, occ, 0);
    }

    private Shape(int id, String title, ShapeKind kind, ShapeSymmetry sym, int used, int made, int occ, int flags) {
        this.id = id;
        this.title = title;
        this.kind = kind;
        this.symmetry = sym;
        this.materialUsed = used;
        this.itemsProduced = made;
        this.occlusionMask = occ;
        this.flags = flags;
    }

    public static Shape forId(int id) {
        Shape shape = idMap.get(id);
        if (shape == null) {
            shape = ROOF_TILE;
        }
        return shape;
    }

    public static int turnForPlacementHit(int side, Vector3 hit, ShapeSymmetry symmetry) {
        Vector3 h = Trans3.sideTurn(side, 0).ip(hit);
        return Shape.turnForPlacementHit(symmetry, h.x, h.z);
    }

    private static int turnForPlacementHit(ShapeSymmetry symmetry, double x, double z) {
        switch (symmetry) {
            case QUADRILATERAL: {
                return 0;
            }
            case BILATERAL: {
                if (Math.abs(z) > Math.abs(x)) {
                    return z < 0.0 ? 2 : 0;
                }
                return x > 0.0 ? 1 : 3;
            }
            case UNILATERAL: {
                if (z > 0.0) {
                    return x < 0.0 ? 0 : 1;
                }
                return x > 0.0 ? 2 : 3;
            }
        }
        return 0;
    }

    public void orientOnPlacement(EntityPlayer player, TileShape shape, BlockPos neighbourPos, IBlockState neighbourState, TileEntity neighbourTile, EnumFacing face, Vector3 hit) {
        if (!shape.getShape().kind.orientOnPlacement(player, shape, neighbourPos, neighbourState, neighbourTile, face, hit)) {
            this.orientFromHitPosition(player, shape, face, hit);
        }
    }

    protected void orientFromHitPosition(EntityPlayer player, TileShape shape, EnumFacing face, Vector3 hit) {
        int side;
        switch (face) {
            case UP: {
                side = this.rightSideUpSide();
                break;
            }
            case DOWN: {
                if (shape.getShape().kind.canPlaceUpsideDown()) {
                    side = this.upsideDownSide();
                    break;
                }
                side = this.rightSideUpSide();
                break;
            }
            default: {
                side = player.func_70093_af() ? face.func_176734_d().ordinal() : (hit.y > 0.0 && shape.getShape().kind.canPlaceUpsideDown() ? this.upsideDownSide() : this.rightSideUpSide());
            }
        }
        int turn = Shape.turnForPlacementHit(side, hit, this.symmetry);
        if (debugPlacement && !shape.func_145831_w().field_72995_K) {
            ArchitectureLog.info("Shape.orientFromHitPosition: face {} global hit {}", face, hit);
            ArchitectureLog.info("Shape.orientFromHitPosition: side {} turn {} symmetry {}", new Object[]{side, turn, shape.getShape().symmetry});
        }
        shape.setSide(side);
        shape.setTurn(turn);
        if ((this.flags & 2) != 0) {
            shape.setOffsetX(this.offsetXForPlacementHit(side, turn, hit));
            if (debugPlacement && !shape.func_145831_w().field_72995_K) {
                ArchitectureLog.info("Shape.orientFromHitPosition: kind = %s offsetX = %.3f\n", this.kind, shape.getOffsetX());
            }
        }
    }

    public double offsetXForPlacementHit(int side, int turn, Vector3 hit) {
        Vector3 h = Trans3.sideTurn(side, turn).ip(hit);
        return this.signedPlacementOffsetX(h.x);
    }

    public double signedPlacementOffsetX(double sign) {
        double offx = this.kind.placementOffsetX();
        if (sign < 0.0) {
            offx = -offx;
        }
        return offx;
    }

    protected int rightSideUpSide() {
        if (this.isPlacedUnderneath()) {
            return 1;
        }
        return 0;
    }

    protected int upsideDownSide() {
        if (this.isPlacedUnderneath()) {
            return 0;
        }
        return 1;
    }

    protected boolean isPlacedUnderneath() {
        return (this.flags & 1) != 0;
    }

    public boolean isCladding() {
        return this == CLADDING_SHEET;
    }

    static {
        values = Shape.values();
        debugPlacement = false;
        idMap = new HashMap<Integer, Shape>();
        for (Shape s : values) {
            idMap.put(s.id, s);
        }
    }
}

