/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common.drop;

import com.elytradev.architecture.common.ArchitectureLog;
import com.elytradev.architecture.common.drop.IModDrop;
import com.elytradev.architecture.common.drop.RegisterDrop;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ModDrops {
    private List<IModDrop> registeredDrops = Lists.newArrayList();

    public void preInit(FMLPreInitializationEvent e) {
        this.loadDrops(e.getAsmData());
        this.registeredDrops.forEach(d -> d.preInit(e));
    }

    public void init(FMLInitializationEvent e) {
        this.registeredDrops.forEach(d -> d.init(e));
    }

    public void postInit(FMLPostInitializationEvent e) {
        this.registeredDrops.forEach(d -> d.postInit(e));
    }

    private void loadDrops(ASMDataTable dataTable) {
        String annotationName = RegisterDrop.class.getName();
        Set asmDataSet = dataTable.getAll(annotationName);
        for (ASMDataTable.ASMData asmData : asmDataSet) {
            try {
                Class<?> dropClass;
                Map annotationInfo = asmData.getAnnotationInfo();
                String requiredMod = (String)annotationInfo.get("requiredMod");
                if (!Loader.isModLoaded((String)requiredMod) || !IModDrop.class.isAssignableFrom(dropClass = Class.forName(asmData.getClassName()))) continue;
                IModDrop drop = (IModDrop)dropClass.newInstance();
                this.registeredDrops.add(drop);
            }
            catch (Exception exception) {
                ArchitectureLog.error("Failed to load drop, caused by {}", (Throwable)exception);
            }
        }
    }
}

