/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common;

import com.elytradev.architecture.common.ArchitectureLog;
import com.elytradev.architecture.common.ArchitectureMod;
import com.elytradev.architecture.common.block.BlockSawbench;
import com.elytradev.architecture.common.block.BlockShape;
import com.elytradev.architecture.common.item.ItemArchitecture;
import com.elytradev.architecture.common.item.ItemChisel;
import com.elytradev.architecture.common.item.ItemCladding;
import com.elytradev.architecture.common.item.ItemHammer;
import com.elytradev.architecture.common.shape.ItemShape;
import com.elytradev.architecture.common.shape.Shape;
import com.elytradev.architecture.common.tile.TileSawbench;
import com.elytradev.architecture.common.tile.TileShape;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ArchitectureContent {
    public static final CreativeTabs TOOL_TAB = new CreativeTabs("architecture.tool"){

        public ItemStack func_78016_d() {
            return new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("architecturecraft", "hammer")));
        }
    };
    public static final CreativeTabs SHAPE_TAB = new CreativeTabs("architecture.shape"){

        public ItemStack func_78016_d() {
            return Shape.ROOF_TILE.kind.newStack(Shape.ROOF_TILE, Blocks.field_150344_f.func_176223_P(), 1);
        }
    };
    private static final String REGISTRY_PREFIX = "architecturecraft".toLowerCase();
    public static HashMap<String, Block> registeredBlocks = Maps.newHashMap();
    public static HashMap<String, Item> registeredItems = Maps.newHashMap();
    private static List<Item> itemBlocksToRegister = Lists.newArrayList();
    public BlockSawbench blockSawbench;
    public BlockShape blockShape;
    public Item itemSawblade;
    public Item itemLargePulley;
    public Item itemChisel;
    public Item itemHammer;
    public ItemCladding itemCladding;
    private int recipeID = 0;
    private ModFixs dataFixer;

    public void preInit(FMLPreInitializationEvent e) {
        this.dataFixer = FMLCommonHandler.instance().getDataFixer().init("architecturecraft", 1);
        this.dataFixer.registerFix((IFixType)FixTypes.BLOCK_ENTITY, new IFixableData(){

            public int func_188216_a() {
                return 0;
            }

            public NBTTagCompound func_188217_a(NBTTagCompound compound) {
                NBTTagCompound tag = compound.func_74737_b();
                String id = compound.func_74779_i("id");
                if (id.equals("gcewing.shape") || id.equals(new ResourceLocation(TileShape.class.getName()).toString())) {
                    id = new ResourceLocation("architecturecraft", "shape").toString();
                } else if (id.equals("gcewing.sawbench") || id.equals(new ResourceLocation(TileSawbench.class.getName()).toString())) {
                    id = new ResourceLocation("architecturecraft", "sawbench").toString();
                }
                tag.func_74778_a("id", id);
                return tag;
            }
        });
    }

    public void init(FMLInitializationEvent e) {
        GameRegistry.registerTileEntity(TileShape.class, (String)"architecturecraft:shape");
        GameRegistry.registerTileEntity(TileSawbench.class, (String)"architecturecraft:sawbench");
    }

    public void postInit(FMLPostInitializationEvent e) {
    }

    @SubscribeEvent
    public void onBlockRegister(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        this.blockSawbench = this.registerBlock((IForgeRegistry<Block>)registry, "sawbench", new BlockSawbench());
        this.blockShape = this.registerBlock((IForgeRegistry<Block>)registry, "shape", new BlockShape(), ItemShape.class);
    }

    @SubscribeEvent
    public void onItemRegister(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        this.itemSawblade = this.registerItem((IForgeRegistry<Item>)registry, "sawblade");
        this.itemLargePulley = this.registerItem((IForgeRegistry<Item>)registry, "largePulley");
        this.itemChisel = this.registerItem((IForgeRegistry<Item>)registry, "chisel", new ItemChisel());
        this.itemHammer = this.registerItem((IForgeRegistry<Item>)registry, "hammer", new ItemHammer());
        this.itemCladding = this.registerItem((IForgeRegistry<Item>)registry, "cladding", new ItemCladding());
        itemBlocksToRegister.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        ArchitectureMod.PROXY.registerCustomRenderers();
    }

    @SubscribeEvent
    public void onRecipeRegister(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        this.registerShapedRecipe((IForgeRegistry<IRecipe>)registry, (Block)this.blockSawbench, "I*I", "/0/", "/_/", Character.valueOf('I'), "ingotIron", Character.valueOf('*'), this.itemSawblade, Character.valueOf('/'), "stickWood", Character.valueOf('_'), Blocks.field_150452_aw, Character.valueOf('0'), this.itemLargePulley);
        this.registerShapedRecipe((IForgeRegistry<IRecipe>)registry, this.itemSawblade, " I ", "I/I", " I ", Character.valueOf('I'), "ingotIron", Character.valueOf('/'), "stickWood");
        this.registerShapedRecipe((IForgeRegistry<IRecipe>)registry, this.itemLargePulley, " W ", "W/W", " W ", Character.valueOf('W'), "plankWood", Character.valueOf('/'), "stickWood");
        this.registerShapedRecipe((IForgeRegistry<IRecipe>)registry, this.itemChisel, "I ", "ds", Character.valueOf('I'), "ingotIron", Character.valueOf('s'), "stickWood", Character.valueOf('d'), "dyeOrange");
        this.registerShapedRecipe((IForgeRegistry<IRecipe>)registry, this.itemHammer, "II ", "dsI", "ds ", Character.valueOf('I'), "ingotIron", Character.valueOf('s'), "stickWood", Character.valueOf('d'), "dyeOrange");
    }

    private void registerShapedRecipe(IForgeRegistry<IRecipe> registry, Block out, Object ... input) {
        this.registerShapedRecipe(registry, new ItemStack(out, 1), input);
    }

    private void registerShapedRecipe(IForgeRegistry<IRecipe> registry, Item out, Object ... input) {
        this.registerShapedRecipe(registry, new ItemStack(out, 1), input);
    }

    private void registerShapedRecipe(IForgeRegistry<IRecipe> registry, ItemStack out, Object ... input) {
        ResourceLocation resourceLocation = new ResourceLocation("architecturecraft", out.func_77977_a() + this.recipeID++);
        registry.register(new ShapedOreRecipe(resourceLocation, out, input).setRegistryName(resourceLocation));
    }

    private void registerShapelessRecipe(IForgeRegistry<IRecipe> registry, ItemStack out, Object ... input) {
        ResourceLocation resourceLocation = new ResourceLocation("architecturecraft", out.func_77977_a() + this.recipeID++);
        registry.register(new ShapelessOreRecipe(resourceLocation, out, input).setRegistryName(resourceLocation));
    }

    private <T extends Block> T registerBlock(IForgeRegistry<Block> registry, String id, T block) {
        return this.registerBlock(registry, id, block, true);
    }

    private <T extends Block> T registerBlock(IForgeRegistry<Block> registry, String id, T block, boolean withItemBlock) {
        block.func_149663_c("architecturecraft." + id);
        block.setRegistryName(REGISTRY_PREFIX, id);
        block.func_149647_a(TOOL_TAB);
        registry.register(block);
        if (withItemBlock) {
            itemBlocksToRegister.add((Item)new ItemBlock(block).setRegistryName(block.getRegistryName()));
        }
        registeredBlocks.put(id, block);
        return (T)registeredBlocks.get(id);
    }

    private <T extends Block> T registerBlock(IForgeRegistry<Block> registry, String id, T block, Class<? extends ItemBlock> itemBlockClass) {
        try {
            block.func_149663_c("architecturecraft." + id);
            block.setRegistryName(REGISTRY_PREFIX, id);
            registry.register(block);
            ItemBlock itemBlock = itemBlockClass.getDeclaredConstructor(Block.class).newInstance(block);
            itemBlock.setRegistryName(REGISTRY_PREFIX, id);
            itemBlock.func_77637_a(TOOL_TAB);
            itemBlocksToRegister.add((Item)itemBlock);
            registeredBlocks.put(id, block);
        }
        catch (Exception e) {
            ArchitectureLog.error("Caught exception while registering " + block, (Throwable)e);
        }
        return (T)registeredBlocks.get(id);
    }

    private <T extends Item> T registerItem(IForgeRegistry<Item> registry, String id) {
        ItemArchitecture item = new ItemArchitecture();
        item.func_77655_b("architecturecraft." + id);
        item.setRegistryName(REGISTRY_PREFIX, id);
        item.func_77637_a(TOOL_TAB);
        registry.register((IForgeRegistryEntry)item);
        registeredItems.put(id, item);
        return (T)registeredItems.get(id);
    }

    private <T extends Item> T registerItem(IForgeRegistry<Item> registry, String id, T item) {
        item.func_77655_b("architecturecraft." + id);
        item.setRegistryName(REGISTRY_PREFIX, id);
        item.func_77637_a(TOOL_TAB);
        registry.register(item);
        registeredItems.put(id, item);
        return (T)registeredItems.get(id);
    }
}

