/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.client.render.model;

import com.elytradev.architecture.client.render.model.IArchitectureModel;
import com.elytradev.architecture.client.render.target.RenderTargetBase;
import com.elytradev.architecture.client.render.texture.ITexture;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecture.common.helpers.Vector3;
import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public class OBJSONModel
implements IArchitectureModel {
    private static final Gson GSON = new Gson();
    public double[] bounds;
    public Face[] faces;
    public double[][] boxes;

    public static OBJSONModel fromResource(ResourceLocation location) {
        String path = String.format("/assets/%s/%s", location.func_110624_b(), location.func_110623_a());
        InputStream in = OBJSONModel.class.getResourceAsStream(path);
        OBJSONModel model = (OBJSONModel)GSON.fromJson((Reader)new InputStreamReader(in), OBJSONModel.class);
        if (in == null) {
            throw new RuntimeException("Model file not found: " + path);
        }
        model.setNormals();
        return model;
    }

    @Override
    public AxisAlignedBB getBounds() {
        return new AxisAlignedBB(this.bounds[0], this.bounds[1], this.bounds[2], this.bounds[3], this.bounds[4], this.bounds[5]);
    }

    private void setNormals() {
        for (Face face : this.faces) {
            double[][] p = face.vertices;
            int[] t = face.triangles[0];
            face.normal = Vector3.unit(Vector3.sub(p[t[1]], p[t[0]]).cross(Vector3.sub(p[t[2]], p[t[0]])));
        }
    }

    @Override
    public void addBoxesToList(Trans3 t, List list) {
        if (this.boxes != null && this.boxes.length > 0) {
            Arrays.stream(this.boxes).forEach(b -> this.addBoxToList((double[])b, t, list));
        } else {
            this.addBoxToList(this.bounds, t, list);
        }
    }

    protected void addBoxToList(double[] b, Trans3 t, List list) {
        t.addBox(b[0], b[1], b[2], b[3], b[4], b[5], list);
    }

    @Override
    public void render(Trans3 t, RenderTargetBase target, int baseColourMult, int secondaryColourMult, ITexture ... textures) {
        Vector3 p = null;
        Vector3 n = null;
        for (Face face : this.faces) {
            ITexture tex = textures[face.texture];
            if (tex == null) continue;
            target.setTexture(tex);
            target.setColor(face.texture > 1 ? secondaryColourMult : baseColourMult);
            for (int[] tri : face.triangles) {
                target.beginTriangle();
                for (int i = 0; i < 3; ++i) {
                    int j = tri[i];
                    double[] c = face.vertices[j];
                    p = t.p(c[0], c[1], c[2]);
                    n = t.v(c[3], c[4], c[5]);
                    target.setNormal(n);
                    target.addVertex(p, c[6], c[7]);
                }
                target.endFace();
            }
        }
    }

    public static class Face {
        public int texture;
        double[][] vertices;
        int[][] triangles;
        Vector3 normal;
    }
}

