/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.client.render;

import com.elytradev.architecture.client.render.ICustomRenderer;
import com.elytradev.architecture.client.render.model.IArchitectureModel;
import com.elytradev.architecture.client.render.target.RenderTargetBaked;
import com.elytradev.architecture.client.render.texture.ITexture;
import com.elytradev.architecture.client.render.texture.TextureBase;
import com.elytradev.architecture.common.ArchitectureLog;
import com.elytradev.architecture.common.ArchitectureMod;
import com.elytradev.architecture.common.block.BlockArchitecture;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecture.common.item.ItemArchitecture;
import com.elytradev.architecture.common.render.ITextureConsumer;
import com.elytradev.architecture.common.render.ModelSpec;
import com.elytradev.architecture.legacy.base.ArchitectureModelRenderer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;

public class RenderingManager {
    protected static Trans3 itemTrans = Trans3.blockCenterSideTurn(0, 2);
    protected static String[] texturePrefixes = new String[]{"blocks/", "textures/"};
    protected Map<Block, ICustomRenderer> blockRenderers = new HashMap<Block, ICustomRenderer>();
    protected Map<Item, ICustomRenderer> itemRenderers = new HashMap<Item, ICustomRenderer>();
    protected Map<IBlockState, ICustomRenderer> stateRendererCache = new HashMap<IBlockState, ICustomRenderer>();
    protected Map<ResourceLocation, ITexture> textureCache = new HashMap<ResourceLocation, ITexture>();
    protected CustomBlockStateMapper blockStateMapper = new CustomBlockStateMapper();
    protected List<IBakedModel> bakedModels = new ArrayList<IBakedModel>();
    protected CustomItemBakedModel itemBakedModel;

    public List<IBakedModel> getBakedModels() {
        return this.bakedModels;
    }

    public CustomBlockStateMapper getBlockStateMapper() {
        return this.blockStateMapper;
    }

    public boolean blockNeedsCustomRendering(Block block) {
        return this.blockRenderers.containsKey(block) || this.specifiesTextures(block);
    }

    public boolean itemNeedsCustomRendering(Item item) {
        return this.itemRenderers.containsKey(item) || this.specifiesTextures(item);
    }

    public void registerModelLocationForItem(Item item, CustomItemBakedModel disp) {
        this.registerModelLocationForSubtypes(item, disp.location);
    }

    protected void registerModelLocationForSubtypes(Item item, ModelResourceLocation location) {
        int numVariants = this.getNumItemSubtypes(item);
        for (int i = 0; i < numVariants; ++i) {
            this.registerMesh(item, i, location);
        }
    }

    private void registerMesh(Item item, int meta, ModelResourceLocation resourceLocation) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_175599_af() != null && mc.func_175599_af().func_175037_a() != null) {
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, meta, resourceLocation);
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)resourceLocation);
        }
    }

    private int getNumBlockSubtypes(Block block) {
        if (block instanceof BlockArchitecture) {
            return ((BlockArchitecture)block).getNumSubtypes();
        }
        return 1;
    }

    private int getNumItemSubtypes(Item item) {
        if (item instanceof ItemArchitecture) {
            return ((ItemArchitecture)item).getNumSubtypes();
        }
        if (item instanceof ItemBlock) {
            return this.getNumBlockSubtypes(Block.func_149634_a((Item)item));
        }
        return 1;
    }

    protected boolean specifiesTextures(Object obj) {
        return obj instanceof ITextureConsumer && ((ITextureConsumer)obj).getTextureNames() != null;
    }

    public IArchitectureModel getModel(String name) {
        return ArchitectureMod.PROXY.getModel(name);
    }

    public ICustomRenderer getCustomRenderer(IBlockAccess world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        ICustomRenderer rend = this.blockRenderers.get(block);
        if (rend == null && block instanceof BlockArchitecture) {
            IBlockState astate = block.func_176221_a(state, world, pos);
            rend = this.getCustomRendererForState(astate);
        }
        return rend;
    }

    protected ICustomRenderer getCustomRendererForSpec(int textureType, ModelSpec spec) {
        IArchitectureModel model = this.getModel(spec.modelName);
        ITexture[] textures = new ITexture[spec.textureNames.length];
        for (int i = 0; i < textures.length; ++i) {
            textures[i] = this.getTexture(textureType, spec.textureNames[i]);
        }
        return new ArchitectureModelRenderer(model, spec.origin, textures);
    }

    public ICustomRenderer getCustomRendererForState(IBlockState state) {
        Block block;
        ICustomRenderer rend = this.stateRendererCache.get(state);
        if (rend == null && (block = state.func_177230_c()) instanceof BlockArchitecture) {
            ModelSpec spec = ((BlockArchitecture)block).getModelSpec(state);
            if (spec != null) {
                rend = this.getCustomRendererForSpec(0, spec);
                this.stateRendererCache.put(state, rend);
            } else if (this.blockNeedsCustomRendering(block)) {
                return this.blockRenderers.get(block);
            }
        }
        return rend;
    }

    public ResourceLocation textureResourceLocation(int type, String name) {
        return new ResourceLocation("architecturecraft", texturePrefixes[type] + name);
    }

    public ITexture getTexture(int type, String name) {
        ResourceLocation loc = this.textureResourceLocation(type, name);
        return this.textureCache.get(loc);
    }

    public void registerSprites(int textureType, TextureMap reg, Object obj) {
        String[] names;
        if (obj instanceof ITextureConsumer && (names = ((ITextureConsumer)obj).getTextureNames()) != null) {
            for (String name : names) {
                ResourceLocation loc = this.textureResourceLocation(textureType, name);
                if (this.textureCache.get(loc) != null) continue;
                TextureAtlasSprite icon = reg.func_174942_a(loc);
                TextureBase.Sprite texture = TextureBase.fromSprite(icon);
                this.textureCache.put(loc, texture);
            }
        }
    }

    public TextureAtlasSprite getIcon(int type, String name) {
        return ((TextureBase.Sprite)this.getTexture((int)type, (String)name)).icon;
    }

    public IBlockState getBlockParticleState(IBlockState state, IBlockAccess world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block instanceof BlockArchitecture) {
            return ((BlockArchitecture)block).getParticleState(world, pos);
        }
        return block.func_176221_a(state, world, pos);
    }

    public boolean pathUsesVertexModel(String resourcePath) {
        if (resourcePath.contains("item")) {
            return false;
        }
        return this.blockRenderers.keySet().stream().anyMatch(block -> resourcePath.contains(block.getRegistryName().func_110623_a()));
    }

    public void addBlockRenderer(Block block, ICustomRenderer renderer) {
        this.blockRenderers.put(block, renderer);
    }

    public void addItemRenderer(Item item, ICustomRenderer renderer) {
        this.itemRenderers.put(item, renderer);
    }

    public CustomItemBakedModel getItemBakedModel() {
        if (this.itemBakedModel == null) {
            this.itemBakedModel = new CustomItemBakedModel();
        }
        return this.itemBakedModel;
    }

    public void clearTextureCache() {
        this.textureCache.clear();
    }

    public IBakedModel getCustomBakedModel(IBlockState state, ModelResourceLocation resourceLocation) {
        return new BlockParticleModel(state, resourceLocation);
    }

    public class CustomItemBakedModel
    extends CustomBakedModel {
        protected ItemOverrideList itemOverrideList;

        public CustomItemBakedModel() {
            this.itemOverrideList = new CustomItemRenderOverrideList();
            this.location = new ModelResourceLocation(new ResourceLocation("architecturecraft", "__custitem__"), "");
        }

        public ItemOverrideList func_188617_f() {
            return this.itemOverrideList;
        }
    }

    public class CustomItemRenderOverrideList
    extends ItemOverrideList {
        private IBakedModel emptyModel;

        public CustomItemRenderOverrideList() {
            super((List)ImmutableList.of());
            this.emptyModel = new IBakedModel(){

                public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
                    return Lists.newArrayList();
                }

                public boolean func_177555_b() {
                    return false;
                }

                public boolean func_177556_c() {
                    return false;
                }

                public boolean func_188618_c() {
                    return false;
                }

                public TextureAtlasSprite func_177554_e() {
                    return null;
                }

                public ItemCameraTransforms func_177552_f() {
                    return ItemCameraTransforms.field_178357_a;
                }

                public ItemOverrideList func_188617_f() {
                    return ItemOverrideList.field_188022_a;
                }
            };
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            Block block;
            ModelSpec spec;
            Item item = stack.func_77973_b();
            ICustomRenderer rend = RenderingManager.this.itemRenderers.get(item);
            if (rend == null && item instanceof ItemArchitecture && (spec = ((ItemArchitecture)item).getModelSpec(stack)) != null) {
                rend = RenderingManager.this.getCustomRendererForSpec(1, spec);
            }
            if (rend == null && (block = Block.func_149634_a((Item)item)) != null) {
                rend = RenderingManager.this.getCustomRendererForState(block.func_176223_P());
            }
            if (rend != null) {
                try {
                    GlStateManager.func_179103_j((int)7425);
                }
                catch (RuntimeException e) {
                    ArchitectureLog.warn("Failed to enable smooth shading for item models, {}", e.getMessage());
                }
                RenderTargetBaked target = new RenderTargetBaked();
                rend.renderItemStack(stack, target, itemTrans);
                return target.getBakedModel();
            }
            return this.emptyModel;
        }
    }

    public class BlockParticleModel
    extends CustomBakedModel {
        protected IBlockState state;

        public BlockParticleModel(IBlockState state, ModelResourceLocation location) {
            this.state = state;
            this.location = location;
        }

        public ItemOverrideList func_188617_f() {
            return null;
        }

        @Override
        public TextureAtlasSprite func_177554_e() {
            String[] textures;
            Block block = this.state.func_177230_c();
            if (block instanceof BlockArchitecture && (textures = ((BlockArchitecture)block).getTextureNames()) != null && textures.length > 0) {
                return RenderingManager.this.getIcon(0, textures[0]);
            }
            return null;
        }
    }

    public abstract class CustomBakedModel
    implements IBakedModel {
        public ModelResourceLocation location;

        public void install(ModelBakeEvent event) {
            event.getModelRegistry().func_82595_a((Object)this.location, (Object)this);
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            return null;
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return null;
        }

        public ItemCameraTransforms func_177552_f() {
            return null;
        }
    }

    public static class CustomBlockStateMapper
    extends DefaultStateMapper {
        public ModelResourceLocation func_178132_a(IBlockState state) {
            return super.func_178132_a(state);
        }
    }
}

