/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.tile.Patterns;

import AppliedIntegrations.Blocks.BlocksEnum;
import AppliedIntegrations.api.Multiblocks.BlockData;
import AppliedIntegrations.api.Multiblocks.IAIPatternExtendable;
import appeng.api.util.AEPartLocation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class MultiControllerPattern
implements IAIPatternExtendable {
    private static final BlockPos[] corners = new BlockPos[]{new BlockPos(1, 1, 1), new BlockPos(-1, 1, 1), new BlockPos(1, -1, 1), new BlockPos(1, 1, -1), new BlockPos(-1, -1, 1), new BlockPos(-1, 1, -1), new BlockPos(1, -1, -1), new BlockPos(-1, -1, -1)};

    @Nonnull
    private static BlockPos resizeVector(@Nonnull BlockPos size, @Nonnull EnumFacing facing) {
        if (facing.func_176740_k() == EnumFacing.Axis.X) {
            return new BlockPos(size.func_177958_n(), size.func_177956_o() - 1, size.func_177952_p() - 1);
        }
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            return new BlockPos(size.func_177958_n() - 1, size.func_177956_o(), size.func_177952_p() - 1);
        }
        if (facing.func_176740_k() == EnumFacing.Axis.Z) {
            return new BlockPos(size.func_177958_n() - 1, size.func_177956_o() - 1, size.func_177952_p());
        }
        return size;
    }

    private static void forPosOnAxis(BlockPos sizeVec, BlockPos inverted, Consumer<BlockPos> func, EnumFacing.Axis axis) {
        int x;
        int z;
        if (axis == EnumFacing.Axis.X) {
            for (int y = inverted.func_177956_o(); y < sizeVec.func_177956_o() + 1; ++y) {
                for (z = inverted.func_177952_p(); z < sizeVec.func_177952_p() + 1; ++z) {
                    func.accept(new BlockPos(sizeVec.func_177958_n(), y, z));
                }
            }
        }
        if (axis == EnumFacing.Axis.Y) {
            for (x = inverted.func_177958_n(); x < sizeVec.func_177958_n() + 1; ++x) {
                for (z = inverted.func_177952_p(); z < sizeVec.func_177952_p() + 1; ++z) {
                    func.accept(new BlockPos(x, sizeVec.func_177956_o(), z));
                }
            }
        }
        if (axis == EnumFacing.Axis.Z) {
            for (x = inverted.func_177958_n(); x < sizeVec.func_177958_n() + 1; ++x) {
                for (int y = inverted.func_177956_o(); y < sizeVec.func_177956_o() + 1; ++y) {
                    func.accept(new BlockPos(x, y, sizeVec.func_177952_p()));
                }
            }
        }
    }

    @Nonnull
    private static List<BlockData> inverseEmptySpace(BlockPos size, Block[] options) {
        ArrayList<BlockData> list = new ArrayList<BlockData>();
        BlockPos inverted = size.func_177973_b((Vec3i)size).func_177973_b((Vec3i)size);
        for (int z = inverted.func_177952_p(); z < size.func_177952_p() + 1; ++z) {
            for (int y = inverted.func_177956_o(); y < size.func_177956_o() + 1; ++y) {
                for (int x = inverted.func_177958_n(); x < size.func_177958_n() + 1; ++x) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    list.add(new BlockData(x, y, z, options));
                }
            }
        }
        return list;
    }

    @Nonnull
    private static List<BlockData> fillEdge(BlockPos sizeVec, Block[] options, EnumFacing.Axis axis) {
        ArrayList<BlockData> list = new ArrayList<BlockData>();
        BlockPos inverted = new BlockPos(axis == EnumFacing.Axis.X ? sizeVec.func_177958_n() : -sizeVec.func_177958_n(), axis == EnumFacing.Axis.Y ? sizeVec.func_177956_o() : -sizeVec.func_177956_o(), axis == EnumFacing.Axis.Z ? sizeVec.func_177952_p() : -sizeVec.func_177952_p());
        MultiControllerPattern.forPosOnAxis(sizeVec, inverted, pos -> list.add(new BlockData((BlockPos)pos, options)), axis);
        return list;
    }

    @Nonnull
    private static List<BlockData> getDataMatrixVector(BlockPos size, BlockPos inverted, Block[] options) {
        LinkedList<BlockData> list = new LinkedList<BlockData>();
        for (int x = inverted.func_177958_n(); x < size.func_177958_n(); ++x) {
            list.add(new BlockData(x, size.func_177956_o(), size.func_177952_p(), options));
        }
        for (int y = inverted.func_177956_o(); y < size.func_177956_o(); ++y) {
            list.add(new BlockData(size.func_177958_n(), y, size.func_177952_p(), options));
        }
        for (int z = inverted.func_177952_p(); z < size.func_177952_p(); ++z) {
            list.add(new BlockData(size.func_177958_n(), size.func_177956_o(), z, options));
        }
        list.add(new BlockData(size, options));
        return list;
    }

    public static IAIPatternExtendable generateMultiController(final BlockPos size) {
        BlockPos valuedSize;
        List<Object> list = new ArrayList<BlockData>();
        final HashMap<AEPartLocation, List<BlockPos>> edgeMap = new HashMap<AEPartLocation, List<BlockPos>>(){
            {
                for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
                    this.put(side, new ArrayList());
                }
            }
        };
        for (BlockPos blockPos : corners) {
            valuedSize = new BlockPos(size.func_177958_n() * blockPos.func_177958_n(), size.func_177956_o() * blockPos.func_177956_o(), size.func_177952_p() * blockPos.func_177952_p());
            for (EnumFacing.Axis axis : EnumFacing.Axis.values()) {
                EnumFacing negative = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)axis);
                BlockPos halfInverted = new BlockPos(negative.func_82601_c() == 0 ? valuedSize.func_177958_n() : valuedSize.func_177958_n() * negative.func_82601_c(), negative.func_96559_d() == 0 ? valuedSize.func_177956_o() : valuedSize.func_177956_o() * negative.func_96559_d(), negative.func_82599_e() == 0 ? valuedSize.func_177952_p() : valuedSize.func_177952_p() * negative.func_82599_e());
                list.addAll(MultiControllerPattern.getDataMatrixVector(valuedSize, halfInverted, new Block[]{BlocksEnum.BMCRib.b}));
            }
        }
        for (BlockPos blockPos : EnumFacing.field_82609_l) {
            valuedSize = MultiControllerPattern.resizeVector(size, (EnumFacing)blockPos);
            if (blockPos.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                valuedSize = new BlockPos(blockPos.func_82601_c() == 0 ? valuedSize.func_177958_n() : valuedSize.func_177958_n() * blockPos.func_82601_c(), blockPos.func_96559_d() == 0 ? valuedSize.func_177956_o() : valuedSize.func_177956_o() * blockPos.func_96559_d(), blockPos.func_82599_e() == 0 ? valuedSize.func_177952_p() : valuedSize.func_177952_p() * blockPos.func_82599_e());
            }
            List<BlockData> edge = MultiControllerPattern.fillEdge(valuedSize, new Block[]{BlocksEnum.BMCHousing.b, BlocksEnum.BMCPort.b}, blockPos.func_176740_k());
            list.addAll(edge);
            for (BlockData data : edge) {
                ((List)edgeMap.get(AEPartLocation.fromFacing((EnumFacing)blockPos))).add(data.getPos());
            }
        }
        list.addAll(MultiControllerPattern.inverseEmptySpace(size.func_177982_a(-1, -1, -1), new Block[]{BlocksEnum.BMCHousing.b}));
        final List<Object> finalList = list = list.stream().distinct().collect(Collectors.toList());
        return new IAIPatternExtendable(){

            @Override
            public BlockPos getMinimalFrameSize() {
                return size;
            }

            @Override
            public Map<AEPartLocation, List<BlockPos>> getPosEdgeMap() {
                return edgeMap;
            }

            @Override
            public List<BlockData> getPatternData() {
                return finalList;
            }
        };
    }

    @Override
    @Deprecated
    public List<BlockData> getPatternData() {
        return new ArrayList<BlockData>();
    }

    @Override
    public BlockPos getMinimalFrameSize() {
        return new BlockPos(1, 1, 1);
    }
}

