/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.tile.MultiController.helpers;

import AppliedIntegrations.Items.NetworkCard;
import AppliedIntegrations.tile.MultiController.TileMultiControllerCore;
import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;

public class MultiControllerCoreInventory
implements IMEInventoryHandler<IAEItemStack> {
    private final IItemList<IAEItemStack> itemList = this.getChannel().createList();
    private final TileMultiControllerCore host;

    public MultiControllerCoreInventory(TileMultiControllerCore host) {
        this.host = host;
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public boolean isPrioritized(IAEItemStack input) {
        return false;
    }

    public boolean canAccept(IAEItemStack input) {
        return input.getItem() instanceof NetworkCard;
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return true;
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable action, IActionSource src) {
        if (this.canAccept(input)) {
            if (action == Actionable.SIMULATE) {
                return null;
            }
            this.itemList.add((IAEStack)input);
            this.host.getCardManager().onInventoryChanged();
            return null;
        }
        return input;
    }

    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, IActionSource src) {
        IAEItemStack target = (IAEItemStack)this.itemList.findPrecise((IAEStack)request);
        if (target != null) {
            IAEItemStack output = target.copy();
            if (mode == Actionable.SIMULATE) {
                return output;
            }
            target.setStackSize(0L);
            this.host.getCardManager().onCardRemove(request.createItemStack());
            return output;
        }
        return null;
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        for (IAEItemStack stack : this.itemList) {
            out.add((IAEStack)stack);
        }
        return out;
    }

    public IStorageChannel<IAEItemStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }
}

