/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.tile.MultiController.helpers.Crafting;

import AppliedIntegrations.tile.MultiController.MultiControllerPortHandler;
import AppliedIntegrations.tile.MultiController.TileMultiControllerCore;
import appeng.api.AEApi;
import appeng.api.config.IncludeExclude;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.me.cache.CraftingGridCache;
import com.google.common.collect.ImmutableCollection;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;

public class MultiControllerCraftingHandler
extends MultiControllerPortHandler<IAEItemStack>
implements ICraftingProvider {
    public MultiControllerCraftingHandler(LinkedHashMap<SecurityPermissions, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, List<IAEStack<? extends IAEStack>>>> left, LinkedHashMap<SecurityPermissions, LinkedHashMap<IStorageChannel<? extends IAEStack<?>>, IncludeExclude>> right, TileMultiControllerCore tileMultiControllerCore) {
        super(left, right, tileMultiControllerCore);
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        CraftingGridCache craftingGrid = this.getOuterCraftingGrid();
        if (craftingGrid == null) {
            return;
        }
        if (this.filteredMatter.get(SecurityPermissions.CRAFT) == null || ((LinkedHashMap)this.filteredMatter.get(SecurityPermissions.CRAFT)).get(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) == null) {
            return;
        }
        ((List)((LinkedHashMap)this.filteredMatter.get(SecurityPermissions.CRAFT)).get(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class))).forEach(stack -> {
            if (stack != null) {
                IAEItemStack copy = (IAEItemStack)stack.copy();
                copy.setStackSize(0L);
                ImmutableCollection patterns = craftingGrid.getCraftingFor(copy, null, 0, null);
                for (ICraftingPatternDetails pattern : patterns) {
                    craftingTracker.addCraftingOption((ICraftingMedium)this, pattern);
                }
            }
        });
    }

    private CraftingGridCache getOuterCraftingGrid() {
        try {
            return (CraftingGridCache)this.host.getMainNetworkCraftingGrid();
        }
        catch (ClassCastException classCast) {
            throw new IllegalStateException("Applied integrations tried to cast ICraftingGrid into CraftingGridCache, this message indicates that AIdidn't successfully casted it. It means some mod has overrode crafting grid cache. If you'll get this message, you can submit issue on github: https://github.com/AzazeII/Applied-Integrations/issues");
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (this.filteredMatter.get(SecurityPermissions.CRAFT) == null || ((LinkedHashMap)this.filteredMatter.get(SecurityPermissions.CRAFT)).get(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) == null) {
            return false;
        }
        for (IAEItemStack output : patternDetails.getCondensedOutputs()) {
            if (this.canInteract(output, SecurityPermissions.CRAFT)) continue;
            return false;
        }
        CraftingGridCache craftingGrid = this.getOuterCraftingGrid();
        for (ICraftingMedium medium : craftingGrid.getMediums(patternDetails)) {
            if (medium.isBusy() || !medium.pushPattern(patternDetails, table)) continue;
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        return false;
    }
}

