/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.tile.HoleStorageSystem.singularities;

import AppliedIntegrations.AIConfig;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.HoleStorage.PacketMassChange;
import AppliedIntegrations.Utils.AILog;
import AppliedIntegrations.api.BlackHoleSystem.IPylon;
import AppliedIntegrations.api.BlackHoleSystem.ISingularity;
import AppliedIntegrations.api.Storage.IEnergyStorageChannel;
import AppliedIntegrations.grid.AEEnergyStack;
import AppliedIntegrations.grid.EnergyList;
import AppliedIntegrations.grid.Mana.AEManaStack;
import AppliedIntegrations.grid.Mana.ManaList;
import AppliedIntegrations.tile.HoleStorageSystem.Anomalies.AnomalyEnum;
import AppliedIntegrations.tile.HoleStorageSystem.TimeHandler;
import AppliedIntegrations.tile.HoleStorageSystem.singularities.TileWhiteHole;
import AppliedIntegrations.tile.entities.EntitySingularity;
import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.FluidList;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.item.ItemList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileBlackHole
extends TileEntity
implements ITickable,
ISingularity {
    public static LinkedHashMap<Long, Float> sizeFactor = new LinkedHashMap();
    private static LinkedHashMap<Short, Byte> typeFactor = new LinkedHashMap();
    private final double gravitationalConst = 6.7;
    public long mass = (int)Math.ceil(Math.random() * 16384.0);
    public int MASS_ADDED = 10;
    public ItemList storedItems = new ItemList();
    public FluidList storedFluids = new FluidList();
    public EnergyList storedEnergies = new EnergyList();
    public ManaList storedMana = new ManaList();
    private TimeHandler blockDestroyHandler = new TimeHandler();
    private TimeHandler anomalyTriggerHandler = new TimeHandler();
    private Random randomAnomaly = new Random();
    private float lastGrowth = 1.0f;
    private List<IPylon> listeners = new ArrayList<IPylon>();
    private EntitySingularity entangledHoleEntity = null;
    public TileWhiteHole entangledHole;

    public void func_145843_s() {
        super.func_145843_s();
        for (IPylon pylon : this.listeners) {
            pylon.setSingularity(null);
        }
    }

    public void func_73660_a() {
        if (Platform.isServer()) {
            this.modulateBlockGravity();
        }
        if (this.getGrowthFactor().floatValue() != this.lastGrowth || this.anomalyTriggerHandler.hasTimePassed(this.field_145850_b, 20)) {
            this.onGrowthFactorChange();
            this.lastGrowth = this.getGrowthFactor().floatValue();
        }
        if (this.entangledHoleEntity != null && this.entangledHoleEntity.field_70128_L && this.entangledHoleEntity.getBornSingularity() != null) {
            this.entangledHole = (TileWhiteHole)this.entangledHoleEntity.getBornSingularity();
            this.entangledHoleEntity = null;
        }
    }

    private void modulateBlockGravity() {
        if (this.blockDestroyHandler.hasTimePassed(this.field_145850_b, 1)) {
            double range = this.getMaxDestructionRange();
            for (BlockPos b : this.getBlocksInRadius(range)) {
                this.createItemBlock(b, this.field_145850_b.func_180495_p(b).func_177230_c());
            }
        }
    }

    private Float getGrowthFactor() {
        Float sizeFactorVal = Float.valueOf(1.0f);
        Byte typeFactorVal = 1;
        for (Long value : sizeFactor.keySet()) {
            if (this.mass < value) break;
            sizeFactorVal = sizeFactor.get(value);
        }
        return Float.valueOf(sizeFactorVal.floatValue() * (float)typeFactorVal.byteValue());
    }

    private void onGrowthFactorChange() {
        AnomalyEnum anomaly = AnomalyEnum.values()[this.randomAnomaly.nextInt(AnomalyEnum.values().length)];
    }

    public double getMaxDestructionRange() {
        return Math.cbrt(Math.cbrt(this.mass)) * (double)this.getGrowthFactor().floatValue();
    }

    public List<BlockPos> getBlocksInRadius(double radius) {
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        int x = -((int)radius);
        while ((double)x < radius) {
            int y = -((int)radius);
            while ((double)y < radius) {
                int z = -((int)radius);
                while ((double)z < radius) {
                    Block b;
                    BlockPos blockPos = new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z);
                    if (!(x == this.field_174879_c.func_177958_n() && this.field_174879_c.func_177956_o() == y && this.field_174879_c.func_177952_p() == z || (b = this.field_145850_b.func_180495_p(blockPos).func_177230_c()) instanceof BlockAir || b instanceof ISingularity || b.func_176195_g(b.func_176223_P(), this.field_145850_b, this.field_174879_c) == -1.0f)) {
                        if (this.crossesRadius(blockPos, this.field_174879_c, this.getBlackHoleRadius())) {
                            this.field_145850_b.func_175698_g(blockPos);
                            this.addStack(((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)new ItemStack(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c())), Actionable.MODULATE);
                        }
                        if (this.crossesRadius(blockPos, this.field_174879_c, radius)) {
                            blockPositions.add(blockPos);
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return blockPositions;
    }

    private void createItemBlock(BlockPos pos, Block b) {
        b.func_180663_b(this.field_145850_b, pos, b.func_176223_P());
        this.field_145850_b.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    private boolean crossesRadius(BlockPos posA, BlockPos posB, double radius) {
        return Math.sqrt(posA.func_177951_i((Vec3i)posB)) <= radius;
    }

    public double getBlackHoleRadius() {
        double lightSpeed = 3.0;
        return Math.max(Math.cbrt(Math.cbrt(13.4 * (double)this.mass / Math.pow(lightSpeed, 2.0))), 0.3);
    }

    @Override
    public void addMass(long l) {
        NetworkHandler.sendToAllInRange(new PacketMassChange(this, this.func_174877_v()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
        this.mass += l;
    }

    @Override
    public IAEStack<?> addStack(IAEStack<?> stack, Actionable actionable) {
        if (stack == null) {
            return null;
        }
        if (stack instanceof AEItemStack) {
            this.storedItems.add((IAEItemStack)((AEItemStack)stack));
        } else if (stack instanceof AEFluidStack) {
            this.storedFluids.add((IAEFluidStack)((AEFluidStack)stack));
        } else if (stack instanceof AEManaStack) {
            this.storedMana.add((AEManaStack)stack);
        } else if (stack instanceof AEEnergyStack) {
            this.storedEnergies.add((AEEnergyStack)stack);
        }
        for (IPylon pylon : this.listeners) {
            pylon.setDrain(true);
        }
        this.addMass(stack.getStackSize() * (long)this.MASS_ADDED);
        return null;
    }

    @Override
    public IItemList<?> getList(IStorageChannel chan) {
        if (chan == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            return this.storedItems;
        }
        if (chan == AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
            return this.storedFluids;
        }
        if (AIConfig.enableEnergyFeatures && chan == AEApi.instance().storage().getStorageChannel(IEnergyStorageChannel.class)) {
            return this.storedEnergies;
        }
        if (AIConfig.enableManaFeatures && chan == AEApi.instance().storage().getStorageChannel(IEnergyStorageChannel.class) && Loader.isModLoaded((String)"botania")) {
            return this.storedMana;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setMassFromServer(long mass) {
        this.mass = mass;
    }

    @Override
    public long getMass() {
        return this.mass;
    }

    @Override
    public boolean isEntangled() {
        return this.entangledHole != null;
    }

    @Override
    public void setEntangledHoleEntity(EntitySingularity singularity) {
        AILog.chatLog("Setting entangled singularity to " + singularity.toString());
        this.entangledHoleEntity = singularity;
    }

    @Override
    public void addListener(IPylon pylon) {
        this.listeners.add(pylon);
    }

    public AxisAlignedBB getAxisAABB(int modulateRadius) {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - (double)modulateRadius, (double)this.func_174877_v().func_177956_o() - (double)modulateRadius, (double)this.func_174877_v().func_177952_p() - (double)modulateRadius, (double)this.func_174877_v().func_177958_n() + (double)modulateRadius, (double)this.func_174877_v().func_177956_o() + (double)modulateRadius, (double)this.func_174877_v().func_177952_p() + (double)modulateRadius);
    }

    private boolean destroyWithCondition(Entity entity) {
        Vec3d pos = entity.func_174791_d();
        Vec3d vec3d = new Vec3d((Vec3i)this.func_174877_v());
        if (pos.func_72438_d(vec3d) <= this.getBlackHoleRadius()) {
            entity.func_70106_y();
            this.field_145850_b.func_72900_e(entity);
            this.addMass(this.MASS_ADDED);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    private double getGravityForceBetween(Vec3d posA, Vec3d posB) {
        double radiusSquare = Math.pow(posA.func_72436_e(posB), 2.0);
        return 6.7 * (double)this.mass * 0.1 / radiusSquare;
    }

    private void destroySingularity() {
        this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer p, EnumHand hand) {
        return false;
    }

    @Override
    public BlockPos getHostPos() {
        return this.field_174879_c;
    }

    @Override
    public World getHostWorld() {
        return this.field_145850_b;
    }

    @Override
    public AEPartLocation getHostSide() {
        return AEPartLocation.INTERNAL;
    }

    static {
        sizeFactor.put(81280L, Float.valueOf(1.2f));
        sizeFactor.put(325120L, Float.valueOf(1.3f));
        sizeFactor.put(1300480L, Float.valueOf(1.4f));
        sizeFactor.put(5201920L, Float.valueOf(1.5f));
        sizeFactor.put(10403840L, Float.valueOf(1.6f));
        sizeFactor.put(83230720L, Float.valueOf(1.7f));
        sizeFactor.put(332922880L, Float.valueOf(1.8f));
        sizeFactor.put(1331691520L, Float.valueOf(2.0f));
        sizeFactor.put(5326766080L, Float.valueOf(3.0f));
        sizeFactor.put(21307064320L, Float.valueOf(5.0f));
        sizeFactor.put(85228257280L, Float.valueOf(7.0f));
        typeFactor.put((short)16, (byte)2);
        typeFactor.put((short)32, (byte)3);
        typeFactor.put((short)64, (byte)5);
        typeFactor.put((short)128, (byte)6);
        typeFactor.put((short)256, (byte)7);
        typeFactor.put((short)512, (byte)8);
        typeFactor.put((short)1024, (byte)9);
        typeFactor.put((short)4096, (byte)10);
    }
}

