/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.tile;

import AppliedIntegrations.Blocks.BlocksEnum;
import AppliedIntegrations.api.ISyncHost;
import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.IAEEnergyStack;
import AppliedIntegrations.api.Storage.IEnergyStorageChannel;
import AppliedIntegrations.grid.AEEnergyStack;
import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.me.helpers.MachineSource;
import appeng.util.Platform;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.event.EnergyTileLoadEvent", modid="IC2", striprefs=true), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2", striprefs=true), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="IC2", striprefs=true), @Optional.Interface(iface="ic2.api.energy.tile.IKineticSource", modid="IC2", striprefs=true), @Optional.Interface(iface="ic2.api.energy.tile.IHeatSource", modid="IC2", striprefs=true), @Optional.Interface(iface="mekanism.api.energy.IStrictEnergyStorage", modid="Mekanism", striprefs=true), @Optional.Interface(iface="mekanism.api.energy.IStrictEnergyAcceptor", modid="Mekanism", striprefs=true), @Optional.Interface(iface="cofh.api.energy.EnergyStorage", modid="CoFHAPI", striprefs=true), @Optional.Interface(iface="cofh.api.energy.IEnergyReceiver", modid="CoFHAPI", striprefs=true), @Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHAPI", striprefs=true), @Optional.Interface(iface="Reika.RotaryCraft.api.Interfaces.Transducerable", modid="RotaryCraft", striprefs=true), @Optional.Interface(iface="Reika.RotaryCraft.api.Power.AdvancedShaftPowerReceiver", modid="RotaryCraft", striprefs=true)})
public abstract class AITile
extends TileEntity
implements IActionHost,
ITickable,
IGridProxyable,
ISyncHost {
    protected boolean loaded = false;
    private AENetworkProxy proxy = new AENetworkProxy((IGridProxyable)this, "AITileProxy", this.getMachineStack(), true);

    public void postCellInventoryEvent() {
        this.postGridEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
    }

    public void postGridEvent(MENetworkEvent event) {
        IGridNode node = this.getGridNode(AEPartLocation.INTERNAL);
        if (node != null) {
            IGrid grid = node.getGrid();
            this.postGridEvent(grid, event);
        }
    }

    public void postGridEvent(IGrid iGrid, MENetworkEvent event) {
        if (iGrid == null) {
            return;
        }
        iGrid.postEvent(event);
    }

    public void postCellInventoryEvent(IGrid iGrid) {
        if (iGrid == null) {
            return;
        }
        this.postGridEvent(iGrid, (MENetworkEvent)new MENetworkCellArrayUpdate());
    }

    public void createProxyNode() {
        this.proxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.proxy.setColor(AEColor.TRANSPARENT);
        this.proxy.setValidSides(EnumSet.allOf(EnumFacing.class));
        this.proxy.setIdlePowerUsage(1.0);
        this.proxy.onReady();
        this.proxy.getNode().updateState();
    }

    public void destroyProxyNode() {
        this.getProxy().invalidate();
    }

    private ItemStack getMachineStack() {
        for (BlocksEnum block : BlocksEnum.values()) {
            if (block.tileEnum.clazz != this.getClass()) continue;
            return new ItemStack((Item)block.itemBlock);
        }
        return null;
    }

    public void notifyBlock() {
    }

    protected IGrid getNetwork() {
        return this.getGridNode().getGrid();
    }

    public IGridNode getGridNode() {
        return this.getGridNode(AEPartLocation.INTERNAL);
    }

    public int extractEnergy(EnergyStack resource, Actionable actionable) throws GridAccessException {
        IAEEnergyStack extracted = (IAEEnergyStack)this.getProxy().getStorage().getInventory((IStorageChannel)this.getEnergyChannel()).extractItems((IAEStack)AEEnergyStack.fromStack(resource), actionable, (IActionSource)new MachineSource((IActionHost)this));
        if (extracted == null) {
            return 0;
        }
        return (int)extracted.getStackSize();
    }

    private IEnergyStorageChannel getEnergyChannel() {
        return (IEnergyStorageChannel)AEApi.instance().storage().getStorageChannel(IEnergyStorageChannel.class);
    }

    public int injectEnergy(EnergyStack resource, Actionable actionable) throws GridAccessException {
        if (this.getProxy().getNode() == null) {
            return 0;
        }
        IStorageGrid storage = this.getProxy().getStorage();
        IAEEnergyStack returnAmount = (IAEEnergyStack)storage.getInventory((IStorageChannel)this.getEnergyChannel()).injectItems(this.getEnergyChannel().createStack(resource), actionable, (IActionSource)new MachineSource((IActionHost)this));
        if (returnAmount == null) {
            return (int)resource.amount;
        }
        return (int)(resource.amount - returnAmount.getStackSize());
    }

    public IGridNode getGridNode(@Nonnull AEPartLocation dir) {
        if (this.getProxy().getNode() == null) {
            this.getProxy().getNode();
        }
        return this.getProxy().getNode();
    }

    @Nonnull
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.DENSE_SMART;
    }

    public void securityBreak() {
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.getProxy().writeToNBT(compound);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.getProxy().readFromNBT(compound);
    }

    @Nonnull
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public void gridChanged() {
    }

    public AENetworkProxy getProxy() {
        return this.proxy;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.destroyProxyNode();
    }

    public void onChunkUnload() {
        this.destroyProxyNode();
    }

    @Nonnull
    public IGridNode getActionableNode() {
        if (this.getProxy().getNode() == null) {
            this.createProxyNode();
        }
        return this.getProxy().getNode();
    }

    public void func_73660_a() {
        if (!this.loaded && this.func_145830_o() && Platform.isServer()) {
            this.loaded = true;
            this.createProxyNode();
        }
    }

    @Override
    public BlockPos getHostPos() {
        return this.field_174879_c;
    }

    @Override
    public World getHostWorld() {
        return this.field_145850_b;
    }

    @Override
    public AEPartLocation getHostSide() {
        return AEPartLocation.INTERNAL;
    }
}

