/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.grid.Mana;

import AppliedIntegrations.api.Botania.IAEManaStack;
import AppliedIntegrations.grid.Mana.ManaIterator;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IItemList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ManaList
implements IItemList<IAEManaStack> {
    private final Map<IAEManaStack, IAEManaStack> records = new HashMap<IAEManaStack, IAEManaStack>();

    public void addStorage(IAEManaStack option) {
        if (option == null) {
            return;
        }
        IAEManaStack st = this.getManaRecord(option);
        if (st != null) {
            st.incStackSize(option.getStackSize());
            return;
        }
        IAEManaStack opt = (IAEManaStack)option.copy();
        this.putManaRecord(opt);
    }

    public void addCrafting(IAEManaStack option) {
        if (option == null) {
            return;
        }
        IAEManaStack st = this.getManaRecord(option);
        if (st != null) {
            st.setCraftable(true);
            return;
        }
        IAEManaStack opt = (IAEManaStack)option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(true);
        this.putManaRecord(opt);
    }

    public void addRequestable(IAEManaStack option) {
        if (option == null) {
            return;
        }
        IAEManaStack st = this.getManaRecord(option);
        if (st != null) {
            st.setCountRequestable(st.getCountRequestable() + option.getCountRequestable());
            return;
        }
        IAEManaStack opt = (IAEManaStack)option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(false);
        opt.setCountRequestable(option.getCountRequestable());
        this.putManaRecord(opt);
    }

    public IAEManaStack getFirstItem() {
        Iterator<IAEManaStack> iterator = this.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public int size() {
        return this.records.values().size();
    }

    public Iterator<IAEManaStack> iterator() {
        return new ManaIterator<IAEManaStack>(this.records.values().iterator());
    }

    public void resetStatus() {
        Iterator<IAEManaStack> iterator = this.iterator();
        while (iterator.hasNext()) {
            IAEManaStack s = iterator.next();
            s.reset();
        }
    }

    private IAEManaStack getManaRecord(IAEManaStack stack) {
        return this.records.get(stack);
    }

    private IAEManaStack putManaRecord(IAEManaStack stack) {
        return this.records.put(stack, stack);
    }

    public void add(IAEManaStack option) {
        if (option == null) {
            return;
        }
        IAEManaStack stack = this.getManaRecord(option);
        if (stack != null) {
            stack.add(option);
            return;
        }
        IAEManaStack opt = (IAEManaStack)option.copy();
        this.putManaRecord(opt);
    }

    public IAEManaStack findPrecise(IAEManaStack stack) {
        return stack == null ? null : this.getManaRecord(stack);
    }

    public Collection<IAEManaStack> findFuzzy(IAEManaStack stack, FuzzyMode mode) {
        return stack == null ? Collections.emptyList() : Collections.singletonList(this.findPrecise(stack));
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }
}

