/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.grid;

import AppliedIntegrations.Integration.IntegrationsHelper;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.grid.Implementation.AIEnergy;
import ic2.api.tile.IEnergyStorage;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import java.util.Arrays;
import java.util.Vector;
import mekanism.common.capabilities.Capabilities;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="mekanism.common.capabilities.Capabilities", modid="mekanism", striprefs=true), @Optional.Interface(iface="teamroots.embers.power.EmberCapabilityProvider", modid="embers", striprefs=true), @Optional.Interface(iface="net.darkhax.tesla.capability.TeslaCapabilities", modid="tesla", striprefs=true)})
public class EnumCapabilityType {
    public static EnumCapabilityType FE;
    public static EnumCapabilityType Joules;
    public static EnumCapabilityType EU;
    public static EnumCapabilityType Tesla;
    public static Vector<EnumCapabilityType> values;
    public LiquidAIEnergy energy;
    public Vector<Class> hostClasses = new Vector();
    public Vector<Capability> capabilities = new Vector();

    private EnumCapabilityType(LiquidAIEnergy energy) {
        this.energy = energy;
        values.add(this);
    }

    private EnumCapabilityType(LiquidAIEnergy energy, Class ... hostClasses) {
        this(energy);
        if (hostClasses != null) {
            this.hostClasses.addAll(Arrays.asList(hostClasses));
        }
    }

    private EnumCapabilityType(LiquidAIEnergy energy, Capability ... capability) {
        this(energy);
        if (capability != null) {
            this.capabilities.addAll(Arrays.asList(capability));
        }
    }

    public static EnumCapabilityType fromEnergy(LiquidAIEnergy energy) {
        for (EnumCapabilityType type : values) {
            if (type.energy != energy) continue;
            return type;
        }
        return null;
    }

    public Capability getInputCapability() {
        if (IntegrationsHelper.instance.isLoaded(this.energy, false) && this.capabilities != null && !this.capabilities.isEmpty()) {
            return this.capabilities.firstElement();
        }
        return null;
    }

    public Vector<Class> getHostClassesWithModCheck() {
        if (IntegrationsHelper.instance.isLoaded(this.energy, false) && this.hostClasses != null && !this.hostClasses.isEmpty()) {
            return this.hostClasses;
        }
        return null;
    }

    public Vector<Capability> getCapabilityWithModCheck() {
        if (IntegrationsHelper.instance.isLoaded(this.energy, false) && this.capabilities != null && !this.capabilities.isEmpty()) {
            return this.capabilities;
        }
        return null;
    }

    public Capability getOutputCapabilities() {
        if (IntegrationsHelper.instance.isLoaded(this.energy, false) && this.capabilities != null && !this.capabilities.isEmpty()) {
            return this.capabilities.lastElement();
        }
        return null;
    }

    public boolean isUsesType(TileEntity tileEntity, EnumFacing side) {
        if (this.getCapabilityWithModCheck() != null) {
            for (Capability capability : this.getCapabilityWithModCheck()) {
                if (!tileEntity.hasCapability(capability, side)) continue;
                return true;
            }
        }
        if (this.getHostClassesWithModCheck() != null) {
            for (Class clazz : this.getHostClassesWithModCheck()) {
                if (!clazz.isInstance(tileEntity)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        values = new Vector();
        FE = new EnumCapabilityType(AIEnergy.RF, CapabilityEnergy.ENERGY);
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.J, false)) {
            Joules = new EnumCapabilityType(AIEnergy.J, Capabilities.ENERGY_ACCEPTOR_CAPABILITY, Capabilities.ENERGY_STORAGE_CAPABILITY, Capabilities.ENERGY_OUTPUTTER_CAPABILITY);
        }
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.EU, false)) {
            EU = new EnumCapabilityType(AIEnergy.EU, IEnergyStorage.class, TileEntityElectricMachine.class);
        }
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.TESLA, false)) {
            Tesla = new EnumCapabilityType(AIEnergy.TESLA, TeslaCapabilities.CAPABILITY_CONSUMER, TeslaCapabilities.CAPABILITY_HOLDER, TeslaCapabilities.CAPABILITY_PRODUCER);
        }
    }
}

