/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.grid;

import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.IAEEnergyStack;
import AppliedIntegrations.api.Storage.IEnergyStorageChannel;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.grid.AEEnergyStack;
import AppliedIntegrations.grid.EnergyList;
import appeng.api.storage.data.IItemList;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class EnergyStorageChannel
implements IEnergyStorageChannel {
    @Nonnull
    public IItemList<IAEEnergyStack> createList() {
        return new EnergyList();
    }

    @Nullable
    public IAEEnergyStack createStack(@Nonnull Object o) {
        if (o instanceof LiquidAIEnergy) {
            return this.createStack(new EnergyStack((LiquidAIEnergy)((Object)o), Integer.MAX_VALUE));
        }
        if (o instanceof EnergyStack) {
            return AEEnergyStack.fromStack((EnergyStack)o);
        }
        if (o instanceof AEEnergyStack) {
            return ((AEEnergyStack)o).copy();
        }
        return null;
    }

    @Nullable
    public IAEEnergyStack readFromPacket(@Nonnull ByteBuf buf) {
        return AEEnergyStack.fromPacket(buf);
    }

    @Nullable
    public IAEEnergyStack createFromNBT(@Nonnull NBTTagCompound tag) {
        return AEEnergyStack.fromNBT(tag);
    }

    public int getUnitsPerByte() {
        return 1000;
    }
}

