/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.grid;

import AppliedIntegrations.api.Storage.IAEEnergyStack;
import AppliedIntegrations.grid.EnergyIterator;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IItemList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;

public class EnergyList
implements IItemList<IAEEnergyStack> {
    private final Map<IAEEnergyStack, IAEEnergyStack> records = new HashMap<IAEEnergyStack, IAEEnergyStack>();

    public void addStorage(IAEEnergyStack option) {
        if (option == null) {
            return;
        }
        IAEEnergyStack st = this.getEnergyRecord(option);
        if (st != null) {
            st.incStackSize(option.getStackSize());
            return;
        }
        IAEEnergyStack opt = (IAEEnergyStack)option.copy();
        this.putEnergyRecord(opt);
    }

    public void addCrafting(IAEEnergyStack option) {
        if (option == null) {
            return;
        }
        IAEEnergyStack st = this.getEnergyRecord(option);
        if (st != null) {
            st.setCraftable(true);
            return;
        }
        IAEEnergyStack opt = (IAEEnergyStack)option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(true);
        this.putEnergyRecord(opt);
    }

    public void addRequestable(IAEEnergyStack option) {
        if (option == null) {
            return;
        }
        IAEEnergyStack st = this.getEnergyRecord(option);
        if (st != null) {
            st.setCountRequestable(st.getCountRequestable() + option.getCountRequestable());
            return;
        }
        IAEEnergyStack opt = (IAEEnergyStack)option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(false);
        opt.setCountRequestable(option.getCountRequestable());
        this.putEnergyRecord(opt);
    }

    public IAEEnergyStack getFirstItem() {
        Iterator<IAEEnergyStack> iterator = this.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public int size() {
        return this.records.values().size();
    }

    @Nonnull
    public Iterator<IAEEnergyStack> iterator() {
        return new EnergyIterator<IAEEnergyStack>(this.records.values().iterator());
    }

    public void resetStatus() {
        Iterator<IAEEnergyStack> iterator = this.iterator();
        while (iterator.hasNext()) {
            IAEEnergyStack s = iterator.next();
            s.reset();
        }
    }

    private IAEEnergyStack getEnergyRecord(IAEEnergyStack stack) {
        return this.records.get(stack);
    }

    private IAEEnergyStack putEnergyRecord(IAEEnergyStack stack) {
        return this.records.put(stack, stack);
    }

    public void add(IAEEnergyStack option) {
        if (option == null) {
            return;
        }
        IAEEnergyStack stack = this.getEnergyRecord(option);
        if (stack != null) {
            stack.add(option);
            return;
        }
        IAEEnergyStack opt = (IAEEnergyStack)option.copy();
        this.putEnergyRecord(opt);
    }

    public IAEEnergyStack findPrecise(IAEEnergyStack stack) {
        return stack == null ? null : this.getEnergyRecord(stack);
    }

    public Collection<IAEEnergyStack> findFuzzy(IAEEnergyStack stack, FuzzyMode mode) {
        return stack == null ? Collections.emptyList() : Collections.singletonList(this.findPrecise(stack));
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }
}

