/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.grid;

import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.IAEEnergyStack;
import AppliedIntegrations.api.Storage.IEnergyStorageChannel;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class AEEnergyStack
implements IAEEnergyStack,
Comparable<IAEEnergyStack> {
    private static String KEY_ENERGY = "Energy";
    private static String KEY_COUNT = "Count";
    private static String KEY_AMOUNT = "Amount";
    private static String KEY_REQ = "Req";
    private static String KEY_CRAFT = "Craft";
    private LiquidAIEnergy energy;
    private long stackSize;
    private long countRequestable;
    private boolean isCraftable;
    private int hash;

    private AEEnergyStack(LiquidAIEnergy energy, long amount) {
        this.energy = energy;
        if (this.energy == null) {
            throw new IllegalArgumentException("Energy is null");
        }
        ((IAEEnergyStack)this.setStackSize(amount).setCraftable(false)).setCountRequestable(0L);
        this.hash = ((Object)((Object)this.energy)).hashCode();
    }

    private AEEnergyStack(AEEnergyStack stack) {
        this.energy = stack.getEnergy();
        if (this.energy == null) {
            throw new IllegalArgumentException("Energy is null");
        }
        ((IAEEnergyStack)this.setStackSize(stack.getStackSize()).setCraftable(false)).setCountRequestable(0L);
        this.hash = stack.hash;
    }

    @Override
    public LiquidAIEnergy getEnergy() {
        return this.energy;
    }

    @Override
    public EnergyStack getStack() {
        return new EnergyStack(this.getEnergy(), (int)Math.min(Integer.MAX_VALUE, this.stackSize));
    }

    public static IAEEnergyStack fromPacket(ByteBuf buf) {
        return AEEnergyStack.fromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public static IAEEnergyStack fromNBT(NBTTagCompound t) {
        EnergyStack stack = EnergyStack.readFromNBT(t);
        if (stack == null) {
            return null;
        }
        AEEnergyStack ae = AEEnergyStack.fromStack(stack);
        ae.setStackSize(t.func_74763_f(KEY_AMOUNT));
        ae.setCountRequestable(t.func_74763_f(KEY_REQ));
        ae.setCraftable(t.func_74767_n(KEY_CRAFT));
        return new AEEnergyStack(stack.getEnergy(), stack.getAmount());
    }

    public static AEEnergyStack fromStack(EnergyStack stack) {
        if (stack == null) {
            return null;
        }
        return new AEEnergyStack(stack.getEnergy(), stack.getAmount());
    }

    public void add(IAEEnergyStack option) {
        if (option == null) {
            return;
        }
        this.incStackSize(option.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable());
        this.setCraftable(this.isCraftable() || option.isCraftable());
    }

    public long getStackSize() {
        return this.stackSize;
    }

    public IAEEnergyStack setStackSize(long l) {
        this.stackSize = l;
        return this;
    }

    public long getCountRequestable() {
        return this.countRequestable;
    }

    public IAEEnergyStack setCountRequestable(long l) {
        this.countRequestable = l;
        return this;
    }

    public boolean isCraftable() {
        return this.isCraftable;
    }

    public IAEEnergyStack setCraftable(boolean b) {
        this.isCraftable = b;
        return this;
    }

    public IAEEnergyStack reset() {
        this.setStackSize(0L);
        this.setCountRequestable(0L);
        this.setCraftable(false);
        return this;
    }

    public boolean isMeaningful() {
        return this.getEnergy() != null && this.getStackSize() != 0L || this.countRequestable > 0L || this.isCraftable;
    }

    public void incStackSize(long l) {
        this.setStackSize(this.getStackSize() + l);
    }

    public void decStackSize(long l) {
        this.setStackSize(this.getStackSize() - l);
    }

    public void incCountRequestable(long l) {
        this.setCountRequestable(this.getCountRequestable() + l);
    }

    public void decCountRequestable(long l) {
        this.setCountRequestable(this.getCountRequestable() - l);
    }

    public void writeToNBT(NBTTagCompound t) {
        t.func_74778_a(KEY_ENERGY, this.getEnergy().getTag());
        t.func_74774_a(KEY_COUNT, (byte)0);
        t.func_74772_a(KEY_AMOUNT, this.getStackSize());
        t.func_74772_a(KEY_REQ, this.getCountRequestable());
        t.func_74757_a(KEY_CRAFT, this.isCraftable());
    }

    public boolean fuzzyComparison(IAEEnergyStack other, FuzzyMode mode) {
        return this.energy == other.getEnergy();
    }

    public void writeToPacket(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public IAEEnergyStack copy() {
        return new AEEnergyStack(this);
    }

    public IAEEnergyStack empty() {
        IAEEnergyStack copy = this.copy();
        copy.reset();
        return copy;
    }

    public boolean isItem() {
        return false;
    }

    public boolean isFluid() {
        return false;
    }

    public IStorageChannel<IAEEnergyStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IEnergyStorageChannel.class);
    }

    public ItemStack asItemStackRepresentation() {
        return null;
    }

    @Override
    public int compareTo(IAEEnergyStack o) {
        int diff = this.hashCode() - o.hashCode();
        return Integer.compare(diff, 0);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AEEnergyStack) {
            return ((AEEnergyStack)obj).getEnergy().getTag().equalsIgnoreCase(this.getEnergy().getTag());
        }
        if (obj instanceof EnergyStack) {
            return ((EnergyStack)obj).getEnergy().getTag().equalsIgnoreCase(this.getEnergy().getTag());
        }
        return false;
    }
}

