/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.api;

import AppliedIntegrations.api.IEnergyInterface;
import AppliedIntegrations.api.IInterfaceStorageDuality;
import AppliedIntegrations.grid.Implementation.AIEnergy;
import appeng.api.config.Actionable;
import appeng.api.util.AEPartLocation;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;

public class TeslaInterfaceStorageDuality
extends BaseTeslaContainer
implements IInterfaceStorageDuality<Long> {
    private final IEnergyInterface owner;
    private final AEPartLocation side;

    public TeslaInterfaceStorageDuality(IEnergyInterface owner, AEPartLocation side, Long capacity, Long maxTransfer) {
        super(capacity.longValue(), maxTransfer.longValue(), maxTransfer.longValue());
        this.owner = owner;
        this.side = side;
    }

    @Override
    public void modifyEnergyStored(int i) {
        super.givePower((long)i, false);
        this.owner.setLastInjectedEnergy(this.side, AIEnergy.TESLA);
        if (this.getStored() > this.getMaxStored()) {
            this.takePower(this.getStored() - this.getMaxStored(), false);
        }
        if (this.getStored() < 0L) {
            this.givePower(0L - this.getStored(), false);
        }
    }

    @Override
    public Class<Long> getTypeClass() {
        return Long.class;
    }

    @Override
    public Long getStored() {
        return super.getStoredPower();
    }

    @Override
    public Long getMaxStored() {
        return super.getCapacity();
    }

    @Override
    public Long receive(Long value, Actionable action) {
        this.owner.setLastInjectedEnergy(this.side, AIEnergy.TESLA);
        return super.givePower(value.longValue(), action == Actionable.SIMULATE);
    }

    @Override
    public Long extract(Long value, Actionable action) {
        return super.takePower(value.longValue(), action == Actionable.SIMULATE);
    }

    @Override
    public Long toNativeValue(Number val) {
        return val.longValue();
    }
}

