/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.api;

import AppliedIntegrations.api.IEnergyInterface;
import AppliedIntegrations.api.IInterfaceStorageDuality;
import AppliedIntegrations.api.INBTStorage;
import AppliedIntegrations.grid.Implementation.AIEnergy;
import appeng.api.config.Actionable;
import appeng.api.util.AEPartLocation;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.energy.IStrictEnergyOutputter;
import mekanism.api.energy.IStrictEnergyStorage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="mekanism.api.energy.IStrictEnergyAcceptor", modid="mekanism", striprefs=true), @Optional.Interface(iface="mekanism.api.energy.IStrictEnergyOutputter", modid="mekanism", striprefs=true), @Optional.Interface(iface="mekanism.api.energy.IStrictEnergyStorage", modid="mekanism", striprefs=true)})
public class JouleInterfaceStorage
implements IInterfaceStorageDuality<Double>,
INBTStorage,
IStrictEnergyStorage,
IStrictEnergyOutputter,
IStrictEnergyAcceptor {
    private final double capacity;
    private final AEPartLocation side;
    private IEnergyInterface owner;
    private double storage;

    public JouleInterfaceStorage(IEnergyInterface iEnergyInterface, AEPartLocation side, int capacity) {
        this.owner = iEnergyInterface;
        this.capacity = capacity;
        this.side = side;
    }

    @Override
    public void modifyEnergyStored(int i) {
        this.owner.setLastInjectedEnergy(this.side, AIEnergy.J);
        if (this.storage + (double)i < this.capacity) {
            this.storage += (double)i;
        }
    }

    @Override
    public Class<Double> getTypeClass() {
        return Double.class;
    }

    @Override
    public Double getStored() {
        return this.storage;
    }

    @Override
    public Double getMaxStored() {
        return this.capacity;
    }

    @Override
    public Double receive(Double value, Actionable action) {
        this.owner.setLastInjectedEnergy(this.side, AIEnergy.J);
        double energyReceived = Math.min(this.capacity - this.storage, value);
        if (action == Actionable.MODULATE) {
            this.storage += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public Double extract(Double value, Actionable action) {
        double energyExtracted = Math.min(this.storage, value);
        if (action == Actionable.MODULATE) {
            this.storage -= energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public Double toNativeValue(Number val) {
        return val.doubleValue();
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.storage = tag.func_74769_h("#Joules");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74780_a("#Joules", this.storage);
    }

    public double acceptEnergy(EnumFacing enumFacing, double v, boolean b) {
        this.owner.setLastInjectedEnergy(this.side, AIEnergy.J);
        return this.receive(v, b ? Actionable.SIMULATE : Actionable.MODULATE);
    }

    public boolean canReceiveEnergy(EnumFacing enumFacing) {
        return true;
    }

    public double pullEnergy(EnumFacing enumFacing, double v, boolean b) {
        return this.extract(v, b ? Actionable.SIMULATE : Actionable.MODULATE);
    }

    public boolean canOutputEnergy(EnumFacing enumFacing) {
        return true;
    }

    public double getEnergy() {
        return this.getStored();
    }

    public void setEnergy(double v) {
        this.storage = Math.min(v, this.capacity);
    }

    public double getMaxEnergy() {
        return this.getMaxStored();
    }
}

